/*****************************************************************

  cmdsocket.c -- routines for accepting commands over a socket

  Copyright (c) 1999-2002 by Mike Oliphant - oliphant@gtk.org

    http://www.nostatic.org/grip

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111, USA.

  Socket code based on examples from Linux Socket Programming:
    Copyright (c) 2000 Sean Walton and Macmillan Publishers.  Use
    may be in whole or in part in accordance to the General Public
    License (GPL).

*****************************************************************/



#include <stdio.h>
#include <errno.h>
#include <sys/socket.h>
#include <resolv.h>
#include <arpa/inet.h>
#include <errno.h>
#include <fcntl.h>

/* Initialize the command socket */
int InitCommandSocket(int port)
{
  int sockfd;
  struct sockaddr_in sa;

  if((sockfd = socket(AF_INET,SOCK_STREAM,0))<0) {
    printf("Error: Unable to open command socket\n");

    return -1;
  }

  bzero(&sa,sizeof(sa));
  sa.sin_family=AF_INET;
  sa.sin_port=htons(port);
  sa.sin_addr.s_addr=INADDR_ANY;
  
  if(bind(sockfd,(struct sockaddr*)&sa,sizeof(sa))!=0) {
    printf("Error: Unable to bind command socket\n");

    return -1;
  }

  if(listen(sockfd,20)!=0) {
    printf("Error: Unable to listen on command socket\n");

    return -1;
  }
  
  if(fcntl(sockfd,F_SETFL,O_NONBLOCK)<0) {
    printf("Error: Unable to set command socket in non-blocking mode\n");

    return -1;
  }

  return sockfd;
}

/* Get an incoming command */
int GetSocketCommand(int sockfd,char *cmdbuf,int maxlen)
{
  int client_fd;
  struct sockaddr_in client_addr;
  int len;
  
  len=sizeof(client_addr);
  
  client_fd=accept(sockfd,(struct sockaddr *)&client_addr,&len);

  if(client_fd<0) return -1;

  len=recv(client_fd,cmdbuf,maxlen,0);

  if(len>=0) cmdbuf[len]='\0';

  close(client_fd);

  return len;
}

/* Close the command socket */
void CloseCommandSocket(int sockfd)
{ 
  close(sockfd);
}

#define PORT_FTP        9999              /* FTP connection port */
#define SERVER_ADDR     "127.0.0.1"     /* localhost */


/* Send a command the command server socket */
int SendCommand(char *host_ip,unsigned int port,char *cmd)
{
  int sockfd;
  struct sockaddr_in dest;

  if((sockfd=socket(AF_INET,SOCK_STREAM,0))<0) {
    printf("Error: Unable to open socket to send command\n");
    
    return -1;
  }
  

  bzero(&dest,sizeof(dest));
  dest.sin_family=AF_INET;
  dest.sin_port=htons(port);

  if(inet_aton(host_ip,&dest.sin_addr)==0) {
    printf("Error: Unable to tranlate %s\n",host_ip);

    return -1;
  }

  if(connect(sockfd,(struct sockaddr*)&dest,sizeof(dest))!=0) {
    printf("Error: Unable to connect to %s port %d\n",host_ip,port);

    printf("errno is %d\n",errno);

    return -1;
  }

  send(sockfd,cmd,strlen(cmd),0);

  /*---Clean up---*/
  close(sockfd);

  return 0;
}
