#
# Table structure for table 'artist'
#

ALTER TABLE artist ADD date_added date;

#
# Table structure for table 'db_info'
#

CREATE TABLE db_info (
  db_version int(10) unsigned default NULL
) TYPE=MyISAM;

INSERT INTO db_info (db_version) VALUES (2);

#
# Table structure for table 'disc'
#

ALTER TABLE disc ADD date_added date;
ALTER TABLE disc ADD gain_adjustment int;
ALTER TABLE disc MODIFY COLUMN artistid int NOT NULL;
ALTER TABLE disc ADD KEY artistid(artistid);

#
# Table structure for table 'playlist_data'
#

CREATE TABLE playlist_data (
  id int(10) unsigned NOT NULL auto_increment,
  name varchar(255) default NULL,
  type enum('SONG','ARTIST','DISC','GENRE') default 'SONG',
  size int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (id),
  UNIQUE KEY name (name)
) TYPE=MyISAM;

#
# Table structure for table 'playlist_items'
#

CREATE TABLE playlist_items (
  playlist_id int(10) unsigned NOT NULL default '0',
  item_id int(10) unsigned NOT NULL default '0',
  position int(10) unsigned NOT NULL default '0'
) TYPE=MyISAM;

#
# Table structure for table 'song'
#

ALTER TABLE song ADD date_added date;
ALTER TABLE song ADD gain_adjustment int;
ALTER TABLE song MODIFY COLUMN artistid int NOT NULL;
ALTER TABLE song ADD KEY artistid (artistid);
ALTER TABLE song MODIFY COLUMN discid int NOT NULL;
ALTER TABLE song ADD KEY discid (discid);
