/* Copyright (C) 2004 - 2007  db4objects Inc.  http://www.db4o.com

This file is part of the db4o open source object database.

db4o is free software; you can redistribute it and/or modify it under
the terms of version 2 of the GNU General Public License as published
by the Free Software Foundation and as clarified by db4objects' GPL 
interpretation policy, available at
http://www.db4o.com/about/company/legalpolicies/gplinterpretation/
Alternatively you can write to db4objects, Inc., 1900 S Norfolk Street,
Suite 350, San Mateo, CA 94403, USA.

db4o is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with this program; if not, write to the Free Software Foundation, Inc.,
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. */
namespace Db4objects.Db4o.Internal.Classindex
{
	/// <exclude></exclude>
	public abstract class AbstractClassIndexStrategy : Db4objects.Db4o.Internal.Classindex.IClassIndexStrategy
	{
		protected readonly Db4objects.Db4o.Internal.ClassMetadata _yapClass;

		public AbstractClassIndexStrategy(Db4objects.Db4o.Internal.ClassMetadata yapClass
			)
		{
			_yapClass = yapClass;
		}

		protected virtual int YapClassID()
		{
			return _yapClass.GetID();
		}

		public virtual int OwnLength()
		{
			return Db4objects.Db4o.Internal.Const4.ID_LENGTH;
		}

		protected abstract void InternalAdd(Db4objects.Db4o.Internal.Transaction trans, int
			 id);

		public void Add(Db4objects.Db4o.Internal.Transaction trans, int id)
		{
			CheckId(id);
			InternalAdd(trans, id);
		}

		protected abstract void InternalRemove(Db4objects.Db4o.Internal.Transaction ta, int
			 id);

		public void Remove(Db4objects.Db4o.Internal.Transaction ta, int id)
		{
			CheckId(id);
			InternalRemove(ta, id);
		}

		private void CheckId(int id)
		{
		}

		public abstract System.Collections.IEnumerator AllSlotIDs(Db4objects.Db4o.Internal.Transaction
			 arg1);

		public abstract void DefragIndex(Db4objects.Db4o.Internal.ReaderPair arg1);

		public abstract void DefragReference(Db4objects.Db4o.Internal.ClassMetadata arg1, 
			Db4objects.Db4o.Internal.ReaderPair arg2, int arg3);

		public abstract void DontDelete(Db4objects.Db4o.Internal.Transaction arg1, int arg2
			);

		public abstract int EntryCount(Db4objects.Db4o.Internal.Transaction arg1);

		public abstract int Id();

		public abstract void Initialize(Db4objects.Db4o.Internal.ObjectContainerBase arg1
			);

		public abstract void Purge();

		public abstract void Read(Db4objects.Db4o.Internal.ObjectContainerBase arg1, int 
			arg2);

		public abstract void TraverseAll(Db4objects.Db4o.Internal.Transaction arg1, Db4objects.Db4o.Foundation.IVisitor4
			 arg2);

		public abstract int Write(Db4objects.Db4o.Internal.Transaction arg1);
	}
}
