// ------------------------------------------------------- 
// Copyright (C) Bradley M. Bell 2003, All rights reserved 
// ------------------------------------------------------- 
Keyword = 
[
"CppAD  cppad-20140000.3: A Package for Differentiation of C++ Algorithms   algorithmic automatic derivative version introduction include cppad.hpp symbol preprocessor namespace",
"Install  CppAD Download, Test, and Install Instructions  ",
"download  Download The CppAD Source Code  ",
"cmake  Using CMake to Configure CppAD   command makefile generator install prefix include directories data directory library postfix package c++ compile flags documentation maximum number threads sparsity internal structure vector of sets memory usage tape implicit explicit",
"adolc_prefix  Including the ADOL-C Examples and Tests   speed unix cygwin get",
"get_adolc.sh  Download and Install Adolc in Build Directory  ",
"get_colpack.sh  Download and Install ColPack in Build Directory  ",
"eigen_prefix  Including the Eigen Examples and Tests   vector get",
"get_eigen.sh  Download and Install Eigen in Build Directory  ",
"fadbad_prefix  Including the FADBAD Speed Tests   get",
"get_fadbad.sh  Download and Install Fadbad in Build Directory  ",
"ipopt_prefix  Including the cppad_ipopt Library and Tests   example get",
"get_ipopt.sh  Download and Install Ipopt in Build Directory  ",
"sacado_prefix  Including the Sacado Speed Tests   get",
"get_sacado.sh  Download and Install Sacado in Build Directory  ",
"cppad_testvector  Choosing the CppAD Test Vector Template Class   boost eigen",
"cppad_test  Running the CppAD Examples and Tests  ",
"pkgconfig  CppAD pkg-config Files   pc",
"InstallUnix  Unix Test and Installation   cppad free configure speed profile prefix directory documentation std vector boost eigen sparse internal sets implicit explicit compile flags openmp postfix adolc fadbad ipopt sacado memory usage tape",
"Introduction  An Introduction by Example to Algorithmic Differentiation   ad automatic",
"get_started.cpp  Getting Started Using CppAD to Compute Derivatives   simple example",
"exp_2  Second Order Exponential Approximation   example algorithm",
"exp_2.hpp  exp_2: Implementation  ",
"exp_2.cpp  exp_2: Test  ",
"exp_2_for0  exp_2: Operation Sequence and Zero Order Forward Mode   example expansion",
"exp_2_for1  exp_2: First Order Forward Mode   example expansion",
"exp_2_rev1  exp_2: First Order Reverse Mode   example",
"exp_2_for2  exp_2: Second Order Forward Mode   example expansion",
"exp_2_rev2  exp_2: Second Order Reverse Mode   example",
"exp_2_for0.cpp  exp_2: Verify Zero Order Forward Sweep  ",
"exp_2_for1.cpp  exp_2: Verify First Order Forward Sweep  ",
"exp_2_rev1.cpp  exp_2: Verify First Order Reverse Sweep   mode",
"exp_2_for2.cpp  exp_2: Verify Second Order Forward Sweep  ",
"exp_2_rev2.cpp  exp_2: Verify Second Order Reverse Sweep   mode",
"exp_2_cppad  exp_2: CppAD Forward and Reverse Sweeps  ",
"exp_eps  An Epsilon Accurate Exponential Approximation   example algorithm",
"exp_eps.hpp  exp_eps: Implementation  ",
"exp_eps.cpp  exp_eps: Test of exp_eps  ",
"exp_eps_for0  exp_eps: Operation Sequence and Zero Order Forward Sweep   example",
"exp_eps_for1  exp_eps: First Order Forward Sweep   expansion",
"exp_eps_rev1  exp_eps: First Order Reverse Sweep   mode example",
"exp_eps_for2  exp_eps: Second Order Forward Mode   example expansion",
"exp_eps_rev2  exp_eps: Second Order Reverse Sweep   mode example",
"exp_eps_for0.cpp  exp_eps: Verify Zero Order Forward Sweep  ",
"exp_eps_for1.cpp  exp_eps: Verify First Order Forward Sweep   exp_2",
"exp_eps_rev1.cpp  exp_eps: Verify First Order Reverse Sweep  ",
"exp_eps_for2.cpp  exp_eps: Verify Second Order Forward Sweep   first exp_2",
"exp_eps_rev2.cpp  exp_eps: Verify Second Order Reverse Sweep  ",
"exp_eps_cppad  exp_eps: CppAD Forward and Reverse Sweeps  ",
"exp_apx_main.cpp  Correctness Tests For Exponential Approximation in Introduction   run",
"AD  AD Objects   base require",
"ad_ctor  AD Constructors   convert base vecad deprecated",
"ad_ctor.cpp  AD Constructors: Example and Test   object",
"ad_assign  AD Assignment Operator   base vecad",
"ad_assign.cpp  AD Assignment: Example and Test   object",
"Convert  Conversion and I/O of AD Objects   from",
"Value  Convert From an AD Type to its Base Type  ",
"value.cpp  Convert From AD to its Base Type: Example and Test   record",
"Integer  Convert From AD to Integer  ",
"integer.cpp  Convert From AD to Integer: Example and Test  ",
"ad_input  AD Output Stream Operator   >> write",
"ad_output  AD Output Stream Operator   << write",
"ad_input.cpp  AD Output Operator: Example and Test   <<",
"ad_output.cpp  AD Output Operator: Example and Test   <<",
"PrintFor  Printing AD Values During Forward Mode   text output debug",
"print_for_cout.cpp  Printing During Forward Mode: Example and Test  ",
"print_for_string.cpp  Print During Zero Order Forward Mode: Example and Test  ",
"Var2Par  Convert an AD Variable to a Parameter   from value_ obtain during taping",
"var2par.cpp  Convert an AD Variable to a Parameter: Example and Test   value during taping",
"ADValued  AD Valued Operations and Functions  ",
"Arithmetic  AD Arithmetic Operators and Computed Assignments  ",
"UnaryPlus  AD Unary Plus Operator   +",
"unary_plus.cpp  AD Unary Plus Operator: Example and Test  ",
"UnaryMinus  AD Unary Minus Operator   -",
"unary_minus.cpp  AD Unary Minus Operator: Example and Test  ",
"ad_binary  AD Binary Arithmetic Operators   + add plus - subtract minus * multiply times / divide",
"add.cpp  AD Binary Addition: Example and Test   + plus",
"sub.cpp  AD Binary Subtraction: Example and Test   - minus",
"mul.cpp  AD Binary Multiplication: Example and Test   * multiply times",
"div.cpp  AD Binary Division: Example and Test   / divide quotient",
"compute_assign  AD Computed Assignment Operators   + add plus - subtract minus * multiply times / divide multiple",
"AddEq.cpp  AD Computed Assignment Addition: Example and Test   += plus",
"sub_eq.cpp  AD Computed Assignment Subtraction: Example and Test   -= plus add",
"mul_eq.cpp  AD Computed Assignment Multiplication: Example and Test   *= multiply plus add",
"div_eq.cpp  AD Computed Assignment Division: Example and Test   /= divide plus add",
"std_math_ad  AD Standard Math Unary Functions   acos asin atan cosh exp fabs log log10 sinh sqrt tanh",
"Acos.cpp  The AD acos Function: Example and Test  ",
"Asin.cpp  The AD asin Function: Example and Test  ",
"atan.cpp  The AD atan Function: Example and Test  ",
"cos.cpp  The AD cos Function: Example and Test  ",
"cosh.cpp  The AD cosh Function: Example and Test  ",
"exp.cpp  The AD exp Function: Example and Test  ",
"log.cpp  The AD log Function: Example and Test  ",
"log10.cpp  The AD log10 Function: Example and Test  ",
"sin.cpp  The AD sin Function: Example and Test  ",
"sinh.cpp  The AD sinh Function: Example and Test  ",
"sqrt.cpp  The AD sqrt Function: Example and Test  ",
"tan.cpp  The AD tan Function: Example and Test  ",
"tanh.cpp  The AD tanh Function: Example and Test  ",
"MathOther  Other AD Math Functions  ",
"abs  AD Absolute Value Function   fabs",
"abs.cpp  AD Absolute Value Function: Example and Test   fabs",
"sign  Sign Function   ad",
"sign.cpp  Sign Function: Example and Test  ",
"atan2  AD Two Argument Inverse Tangent Function  ",
"atan2.cpp  The AD atan2 Function: Example and Test  ",
"erf  The AD Error Function  ",
"erf.cpp  The AD erf Function: Example and Test  ",
"pow  The AD Power Function   exponent",
"pow.cpp  The AD Power Function: Example and Test  ",
"limits  Numeric Limits For an AD and Base Types   epsilon max min",
"limits.cpp  Numeric Limits: Example and Test  ",
"CondExp  AD Conditional Expressions   assign",
"cond_exp.cpp  Conditional Expressions: Example and Test   condexp",
"Discrete  Discrete AD Functions   cppad_discrete_function parallel cppadcreatediscrete deprecated",
"tape_index.cpp  Taping Array Index Operation: Example and Test  ",
"interp_onetape.cpp  Interpolation With Out Retaping: Example and Test   interpolate retape",
"interp_retape.cpp  Interpolation With Retaping: Example and Test   interpolate",
"atomic  Atomic AD Functions   operation",
"checkpoint  Checkpointing Functions  ",
"checkpoint.cpp  Simple Checkpointing: Example and Test  ",
"atomic_base  User Defined Atomic AD Functions   operation",
"atomic_ctor  Atomic Function Constructor  ",
"atomic_option  Set Atomic Function Options   atomic_sparsity bool_sparsity_enum set_sparsity_enum",
"atomic_afun  Using AD Version of Atomic Function   use",
"atomic_forward  Atomic Forward Mode   callback virtual",
"atomic_reverse  Atomic Reverse Mode   callback virtual",
"atomic_for_sparse_jac  Atomic Forward Jacobian Sparsity Patterns   callback virtual",
"atomic_rev_sparse_jac  Atomic Reverse Jacobian Sparsity Patterns   callback virtual",
"atomic_rev_sparse_hes  Atomic Reverse Hessian Sparsity Patterns   callback virtual",
"atomic_base_clear  Free Static Variables  ",
"atomic_get_started.cpp  Getting Started with Atomic Operations: Example and Test  ",
"atomic_norm_sq.cpp  Euclidean Norm Squared: Example and Test   operation",
"atomic_reciprocal.cpp  Reciprocal as an Atomic Operation: Example and Test   simple",
"atomic_tangent.cpp  Tan and Tanh as User Atomic Operations: Example and Test  ",
"atomic_mat_mul.cpp  User Atomic Matrix Multiply: Example and Test  ",
"atomic_matrix_mul.hpp  Matrix Multiply as an Atomic Operation  ",
"BoolValued  Bool Valued Operations and Functions with AD Arguments  ",
"Compare  AD Binary Comparison Operators   < <= > >= == !=",
"compare.cpp  AD Binary Comparison Operators: Example and Test   < <= > >= == !=",
"NearEqualExt  Compare AD and Base Objects for Nearly Equal   with",
"near_equal_ext.cpp  Compare AD with Base Objects: Example and Test   nearequalext",
"BoolFun  AD Boolean Functions   unary binary cppad_bool_unary cppad_bool_binary",
"bool_fun.cpp  AD Boolean Functions: Example and Test  ",
"ParVar  Is an AD Object a Parameter or Variable  ",
"par_var.cpp  AD Parameter and Variable Functions: Example and Test  ",
"EqualOpSeq  Check if Two Value are Identically Equal   operation sequence",
"equal_op_seq.cpp  EqualOpSeq: Example and Test  ",
"VecAD  AD Vectors that Record Index Operations   tape vecad<base>::reference",
"vec_ad.cpp  AD Vectors that Record Index Operations: Example and Test   vecad",
"base_require  AD<Base> Requirements for Base Type   output operator integer",
"base_member  Required Base Class Member Functions  ",
"base_cond_exp  Base Type Requirements for Conditional Expressions   condexp cppad_cond_exp_rel",
"base_identical  Base Type Requirements for Identically Equal Comparisons   equalopseq",
"base_ordered  Base Type Requirements for Ordered Comparisons  ",
"base_std_math  Base Type Requirements for Standard Math Functions   unary cppad_standard_math_unary sign pow isnan numeric limits numeric_limits",
"base_example  Example AD Base Types That are not AD<OtherBase>  ",
"base_alloc.hpp  Example AD<Base> Where Base Constructor Allocates Memory  ",
"base_require.cpp  Using a User Defined AD Base Type: Example and Test  ",
"base_adolc.hpp  Enable use of AD<Base> where Base is Adolc's adouble Type  ",
"mul_level_adolc.cpp  Using Adolc with Multiple Levels of Taping: Example and Test  ",
"base_float.hpp  Enable use of AD<Base> where Base is float  ",
"base_double.hpp  Enable use of AD<Base> where Base is double  ",
"base_complex.hpp  Enable use of AD<Base> where Base is std::complex<double>  ",
"complex_poly.cpp  Complex Polynomial: Example and Test  ",
"not_complex_ad.cpp  Not Complex Differentiable: Example and Test   polynomial imag() real()",
"ADFun  ADFun Objects  ",
"Independent  Declare Independent Variables and Start Recording   parallel",
"independent.cpp  Independent and ADFun Constructor: Example and Test  ",
"FunConstruct  Construct an ADFun Object and Stop Recording   tape default constructor sequence copy assignment operator parallel",
"fun_assign.cpp  ADFun Assignment: Example and Test  ",
"Dependent  Stop Recording and Store Operation Sequence   adfun tape parallel",
"abort_recording  Abort Recording of an Operation Sequence   tape",
"abort_recording.cpp  Abort Current Recording: Example and Test  ",
"seq_property  ADFun Sequence Properties   domain range parameter size_var size_par size_vecad",
"seq_property.cpp  ADFun Sequence Properties: Example and Test   domain range parameter size_var size_par size_op size_op_arg size_vecad",
"FunEval  Evaluate ADFun Functions, Derivatives, and Sparsity Patterns  ",
"Forward  Forward Mode  ",
"ForwardZero  Zero Order Forward Mode: Function Values  ",
"ForwardOne  First Order Forward Mode: Derivative Values  ",
"ForwardAny  Any Order Forward Mode   derivative calculate",
"size_taylor  Number Taylor Coefficients, Per Variable, Currently Stored  ",
"CompareChange  Comparison Changes During Zero Order Forward Mode   adfun ndebug",
"compare_change.cpp  CompareChange and Re-Tape: Example and Test  ",
"capacity_taylor  Controlling Taylor Coefficients Memory Allocation   forward",
"capacity_taylor.cpp  Controlling Taylor Coefficient Memory Allocation: Example and Test  ",
"number_skip  Number of Variables that Can be Skipped  ",
"number_skip.cpp  Number of Variables That Can be Skipped: Example and Test   optimize conditional expression",
"forward.cpp  Forward Mode: Example and Test  ",
"forward_mul.cpp  Forward Mode: Example and Test of Multiple Orders  ",
"Reverse  Reverse Mode  ",
"reverse_one  First Order Reverse Mode   derivative",
"reverse_two  Second Order Reverse Mode   derivative",
"reverse_any  Any Order Reverse Mode   derivative",
"reverse_one.cpp  First Order Reverse Mode: Example and Test  ",
"reverse_two.cpp  Second Order Reverse ModeExample and Test  ",
"hes_times_dir.cpp  Hessian Times Direction: Example and Test  ",
"reverse_three.cpp  Third Order Reverse Mode: Example and Test  ",
"reverse_any.cpp  Reverse Mode General Case: Example and Test  ",
"Sparse  Calculating Sparsity Patterns  ",
"ForSparseJac  Jacobian Sparsity Pattern: Forward Mode  ",
"for_sparse_jac.cpp  Forward Mode Jacobian Sparsity: Example and Test   forsparsejac",
"RevSparseJac  Jacobian Sparsity Pattern: Reverse Mode  ",
"rev_sparse_jac.cpp  Reverse Mode Jacobian Sparsity: Example and Test   revsparsejac",
"RevSparseHes  Hessian Sparsity Pattern: Reverse Mode  ",
"rev_sparse_hes.cpp  Reverse Mode Hessian Sparsity: Example and Test   revsparsehes",
"Drivers  First and Second Derivatives: Easy Drivers   forward reverse",
"Jacobian  Jacobian: Driver Routine   first derivative",
"jacobian.cpp  Jacobian: Example and Test  ",
"ForOne  First Order Partial Derivative: Driver Routine   easy",
"for_one.cpp  First Order Partial Driver: Example and Test  ",
"RevOne  First Order Derivative: Driver Routine   easy",
"rev_one.cpp  First Order Derivative Driver: Example and Test  ",
"Hessian  Hessian: Easy Driver   second derivative",
"hessian.cpp  Hessian: Example and Test  ",
"hes_lagrangian.cpp  Hessian of Lagrangian and ADFun Default Constructor: Example and Test   heslagrangian",
"ForTwo  Forward Mode Second Partial Derivative Driver   order easy",
"for_two.cpp  Subset of Second Order Partials: Example and Test  ",
"RevTwo  Reverse Mode Second Partial Derivative Driver   order easy",
"rev_two.cpp  Second Partials Reverse Driver: Example and Test  ",
"sparse_jacobian  Sparse Jacobian: Easy Driver   sparsejacobian",
"sparse_jacobian.cpp  Sparse Jacobian: Example and Test   spare",
"sparse_hessian  Sparse Hessian: Easy Driver   sparsehessian",
"sparse_hessian.cpp  Sparse Hessian: Example and Test   spare",
"FunCheck  Check an ADFun Sequence of Operations  ",
"fun_check.cpp  ADFun Check and Re-Tape: Example and Test   funcheck dependent",
"optimize  Optimize an ADFun Object Tape   sequence operations speed memory ndebug",
"optimize.cpp  ADFun Operation Sequence Optimization: Example and Test  ",
"check_for_nan  Check an ADFun Object For Nan   in",
"check_for_nan.cpp  ADFun Checking For Nan: Example and Test  ",
"preprocessor  CppAD API Preprocessor Symbols   cppad_ null pointer cppad_null",
"multi_thread  Using CppAD in a Multi-Threading Environment   parallel mode execution maximum number of threads cppad_max_num_threads",
"parallel_ad  Enable AD Calculations During Parallel Mode  ",
"thread_test.cpp  Run Multi-Threading Examples and Speed Tests   openmp pthread bthread",
"a11c_openmp.cpp  A Simple OpenMP Example and Test   a.1.1c thread",
"a11c_bthread.cpp  A Simple Boost Thread Example and Test   a.1.1c",
"a11c_pthread.cpp  A Simple Parallel Pthread Example and Test   openmp a.1.1c",
"simple_ad_openmp.cpp  A Simple OpenMP AD: Example and Test  ",
"simple_ad_bthread.cpp  A Simple Boost Threading AD: Example and Test  ",
"simple_ad_pthread.cpp  A Simple pthread AD: Example and Test  ",
"team_example.cpp  Using a Team of AD Threads: Example and Test  ",
"harmonic.cpp  Multi-Threaded Implementation of Summation of 1/i   multi_thread",
"harmonic_time.cpp  Timing Test of Multi-Threaded Summation of 1/i   multi_thread speed",
"harmonic_work.cpp  Multi-threading Sum of 1/i Utility Routines   harmonic_setup harmonic_worker harmonic_combine",
"multi_newton.cpp  A Multi-Threaded Newton's Method   threading multi-threading",
"multi_newton_time.cpp  Timing Test of Multi-Threaded Newton Method   multi_thread speed",
"multi_newton_work.cpp  Multi-threading Newton Method Utility Routines   multi_newton_setup multi_newton_worker multi_newton_combine",
"team_thread.hpp  Specifications for A Team of AD Threads  ",
"team_openmp.cpp  OpenMP Implementation of a Team of AD Threads  ",
"team_bthread.cpp  Boost Thread Implementation of a Team of AD Threads  ",
"team_pthread.cpp  Pthread Implementation of a Team of AD Threads   bug cygwin pthread_exit",
"library  The CppAD General Purpose Library   numerical c++ template concept",
"ErrorHandler  Replacing the CppAD Error Handler   replace assert exception parallel",
"error_handler.cpp  Replacing The CppAD Error Handler: Example and Test  ",
"cppad_assert  CppAD Assertions During Execution   error macro ndebug cppad_assert_known cppad_assert_unknown",
"NearEqual  Determine if Two Values Are Nearly Equal   absolute difference relative exercise",
"near_equal.cpp  NearEqual Function: Example and Test  ",
"speed_test  Run One Speed Test and Return Results  ",
"SpeedTest  Run One Speed Test and Print Results  ",
"speed_test.cpp  speed_test: Example and test  ",
"speed_program.cpp  Example Use of SpeedTest  ",
"time_test  Determine Amount of Time to Execute a Test   speed",
"elapsed_seconds  Returns Elapsed Number of Seconds   time",
"elapsed_seconds.cpp  Elapsed Seconds: Example and Test   timer",
"time_test.cpp  time_test: Example and test  ",
"NumericType  Definition of a Numeric Type   default constructor int copy exercise",
"numeric_type.cpp  The NumericType: Example and Test  ",
"CheckNumericType  Check NumericType Class Concept   parallel",
"check_numeric_type.cpp  The CheckNumericType Function: Example and Test  ",
"SimpleVector  Definition of a Simple Vector   class template default constructor size copy element destructor assignment resize value_type [] exercise ndebug",
"simple_vector.cpp  Simple Vector Template Class: Example and Test  ",
"CheckSimpleVector  Check Simple Vector Concept   parallel",
"check_simple_vector.cpp  The CheckSimpleVector Function: Example and Test  ",
"nan  Obtain Nan or Determine if a Value is Nan   isnan hasnan macro",
"nan.cpp  nan: Example and Test  ",
"pow_int  The Integer Power Function   exponent",
"pow_int.cpp  The Pow Integer Exponent: Example and Test  ",
"Poly  Evaluate a Polynomial or its Derivative   template",
"poly.cpp  Polynomial Evaluation: Example and Test  ",
"poly.hpp  Source: Poly  ",
"LuDetAndSolve  Compute Determinants and Solve Equations by LU Factorization   matrix linear",
"LuSolve  Compute Determinant and Solve Linear Equations  ",
"lu_solve.cpp  LuSolve With Complex Arguments: Example and Test  ",
"lu_solve.hpp  Source: LuSolve  ",
"LuFactor  LU Factorization of A Square Matrix   linear equation determinant solve",
"lu_factor.cpp  LuFactor: Example and Test  ",
"lu_factor.hpp  Source: LuFactor  ",
"LuInvert  Invert an LU Factored Equation   linear",
"lu_invert.cpp  LuInvert: Example and Test  ",
"lu_invert.hpp  Source: LuInvert  ",
"RombergOne  One DimensionalRomberg Integration   integrate",
"romberg_one.cpp  One Dimensional Romberg Integration: Example and Test  ",
"RombergMul  Multi-dimensional Romberg Integration   integrate",
"Rombergmul.cpp  One Dimensional Romberg Integration: Example and Test  ",
"Runge45  An Embedded 4th and 5th Order Runge-Kutta ODE Solver   differential equation parallel",
"runge45_1.cpp  Runge45: Example and Test  ",
"runge45_2.cpp  Runge45: Example and Test  ",
"Rosen34  A 3rd and 4th Order Rosenbrock ODE Solver   stiff differential equation parallel",
"rosen_34.cpp  Rosen34: Example and Test  ",
"OdeErrControl  An Error Controller for ODE Solvers   differential equation",
"ode_err_control.cpp  OdeErrControl: Example and Test  ",
"ode_err_maxabs.cpp  OdeErrControl: Example and Test Using Maxabs Argument  ",
"OdeGear  An Arbitrary Order Gear Method   stiff differential equation",
"ode_gear.cpp  OdeGear: Example and Test  ",
"OdeGearControl  An Error Controller for Gear's Ode Solvers   differential equation",
"ode_gear_control.cpp  OdeGearControl: Example and Test  ",
"CppAD_vector  The CppAD::vector Template Class   assignment [] push_back push_vector vectorbool thread_alloc exercise",
"cppad_vector.cpp  CppAD::vector Template Class: Example and Test  ",
"vector_bool.cpp  CppAD::vectorBool Class: Example and Test  ",
"thread_alloc  A Fast Multi-Threading Memory Allocator   allocation",
"thread_alloc.cpp  Fast Multi-Threading Memory Allocator: Example and Test   openmp allocation pthread boost",
"ta_parallel_setup  Setup thread_alloc For Use in Multi-Threading Environment   num_threads in_parallel thread_num initialize",
"ta_num_threads  Get Number of Threads   thread_alloc",
"ta_in_parallel  Is The Current Execution in Parallel Mode   thread_alloc sequential",
"ta_thread_num  Get the Current Thread Number   thread_alloc",
"ta_get_memory  Get At Least A Specified Amount of Memory   thread_num thread_alloc allocate",
"ta_return_memory  Return Memory to thread_alloc   available",
"ta_free_available  Free Memory Currently Available for Quick Use by a Thread   thread_alloc",
"ta_hold_memory  Control When Thread Alloc Retains Memory For Future Use   thread_alloc",
"ta_inuse  Amount of Memory a Thread is Currently Using   thread_alloc",
"ta_available  Amount of Memory Available for Quick Use by a Thread   thread_alloc",
"ta_create_array  Allocate An Array and Call Default Constructor for its Elements   thread_alloc",
"ta_delete_array  Deallocate An Array and Call Destructor for its Elements   thread_alloc",
"ta_free_all  Free All Memory That Was Allocated for Use by thread_alloc  ",
"index_sort  Returns Indices that Sort a Vector  ",
"index_sort.cpp  Index Sort: Example and Test  ",
"BenderQuad  Computing Jacobian and Hessian of Bender's Reduced Objective  ",
"bender_quad.cpp  BenderQuad: Example and Test  ",
"opt_val_hes  Jacobian and Hessian of Optimal Values  ",
"opt_val_hes.cpp  opt_val_hes: Example and Test  ",
"LuRatio  LU Factorization of A Square Matrix and Stability Calculation   linear equation determinant solve",
"lu_ratio.cpp  LuRatio: Example and Test  ",
"ipopt_solve  Use Ipopt to Solve a Nonlinear Programming Problem  ",
"ipopt_solve_get_started.cpp  Nonlinear Programming Using CppAD and Ipopt: Example and Test  ",
"ipopt_solve_retape.cpp  Nonlinear Programming Retaping: Example and Test  ",
"ipopt_solve_ode_inverse.cpp  ODE Inverse Problem Definitions: Source Code   example",
"Example  Examples  ",
"General  General Examples   realistic",
"ExampleUtility  Utility Routines used by CppAD Examples  ",
"ListAllExamples  List of All the CppAD Examples  ",
"ad_fun.cpp  Creating Your Own Interface to an ADFun Object   example test",
"ad_in_c.cpp  Example and Test Linking CppAD to Languages Other than C++   algorithmic differentiation automatic",
"conj_grad.cpp  Differentiate Conjugate Gradient Algorithm: Example and Test  ",
"cppad_eigen.hpp  Enable Use of Eigen Linear Algebra Package with CppAD  ",
"eigen_plugin.hpp  Source Code for eigen_plugin.hpp  ",
"eigen_array.cpp  Using Eigen Arrays: Example and Test  ",
"eigen_det.cpp  Using Eigen To Compute Determinant: Example and Test  ",
"hes_minor_det.cpp  Gradient of Determinant Using Expansion by Minors: Example and Test  ",
"hes_lu_det.cpp  Gradient of Determinant Using LU Factorization: Example and Test  ",
"interface2c.cpp  Interfacing to C: Example and Test   difference central",
"jac_minor_det.cpp  Gradient of Determinant Using Expansion by Minors: Example and Test  ",
"jac_lu_det.cpp  Gradient of Determinant Using Lu Factorization: Example and Test  ",
"mul_level  Using Multiple Levels of AD  ",
"mul_level.cpp  Multiple Tapes: Example and Test   ad",
"change_const.cpp  Computing a Jacobian With Constants that Change   multiple ad level",
"ode_stiff.cpp  A Stiff Ode: Example and Test  ",
"mul_level_ode.cpp  Taylor's Ode Solver: An Example and Test  ",
"mul_level_adolc_ode.cpp  Using Adolc with Taylor's Ode Solver: An Example and Test  ",
"ode_taylor.cpp  Taylor's Ode Solver: An Example and Test  ",
"stack_machine.cpp  Example Differentiating a Stack Machine Interpreter   test",
"example.cpp  CppAD Examples and Tests  ",
"speed_example.cpp  Run the Speed Examples   program",
"lu_vec_ad.cpp  Lu Factor and Solve with Recorded Pivoting   luvecad linear equation determinant",
"lu_vec_ad_ok.cpp  Lu Factor and Solve With Recorded Pivoting: Example and Test  ",
"testvector  Using The CppAD Test Vector Template Class   cppad_testvector",
"speed  AD Speed Test Routines   windows",
"speed_main  Speed Testing Main Program   cppad uniform_01",
"link_det_lu  Speed Testing Gradient of Determinant Using Lu Factorization  ",
"link_det_minor  Speed Testing Gradient of Determinant by Minor Expansion  ",
"link_mat_mul  Speed Testing Derivative of Matrix Multiply   multiple",
"link_ode  Speed Testing the Jacobian of Ode Solution  ",
"link_poly  Speed Testing Second Derivative of a Polynomial  ",
"link_sparse_hessian  Speed Testing Sparse Hessian  ",
"link_sparse_jacobian  Speed Testing Sparse Jacobian  ",
"microsoft_timer  Microsoft Version of Elapsed Number of Seconds  ",
"speed_utility  Speed Testing Utilities  ",
"det_by_lu  Determinant Using Expansion by Lu Factorization  ",
"det_by_lu.cpp  Determinant Using Lu Factorization: Example and Test   minors",
"det_by_lu.hpp  Source: det_by_lu  ",
"det_of_minor  Determinant of a Minor   matrix",
"det_of_minor.cpp  Determinant of a Minor: Example and Test  ",
"det_of_minor.hpp  Source: det_of_minor  ",
"det_by_minor  Determinant Using Expansion by Minors  ",
"det_by_minor.cpp  Determinant Using Expansion by Minors: Example and Test  ",
"det_by_minor.hpp  Source: det_by_minor  ",
"det_33  Check Determinant of 3 by 3 matrix   correct",
"det_33.hpp  Source: det_33  ",
"det_grad_33  Check Gradient of Determinant of 3 by 3 matrix   correct",
"det_grad_33.hpp  Source: det_grad_33  ",
"mat_sum_sq  Sum Elements of a Matrix Times Itself   multiply speed test",
"mat_sum_sq.cpp  Sum of the Elements of the Square of a Matrix: Example and Test  ",
"mat_sum_sq.hpp  Source: mat_sum_sq  ",
"ode_evaluate  Evaluate a Function Defined in Terms of an ODE  ",
"ode_evaluate.cpp  ode_evaluate: Example and test  ",
"ode_evaluate.hpp  Source: ode_evaluate  ",
"sparse_jac_fun  Evaluate a Function That Has a Sparse Jacobian  ",
"sparse_jac_fun.cpp  sparse_jac_fun: Example and test  ",
"sparse_jac_fun.hpp  Source: sparse_jac_fun  ",
"sparse_hes_fun  Evaluate a Function That Has a Sparse Hessian  ",
"sparse_hes_fun.cpp  sparse_hes_fun: Example and test  ",
"sparse_hes_fun.hpp  Source: sparse_hes_fun  ",
"uniform_01  Simulate a [0,1] Uniform Random Variate   vector",
"uniform_01.hpp  Source: uniform_01  ",
"speed_double  Speed Test of Functions in Double  ",
"double_det_minor.cpp  Double Speed: Determinant by Minor Expansion   link_det_minor",
"double_det_lu.cpp  Double Speed: Determinant Using Lu Factorization   link_det_lu matrix",
"double_mat_mul.cpp  CppAD Speed: Matrix Multiplication (Double Version)   multiply link_mat_mul",
"double_ode.cpp  Double Speed: Ode Solution   link_ode",
"double_poly.cpp  Double Speed: Evaluate a Polynomial   link_poly",
"double_sparse_hessian.cpp  Double Speed: Sparse Hessian   link_sparse_hessian",
"double_sparse_jacobian.cpp  Double Speed: Sparse Jacobian   link_sparse_jacobian",
"speed_adolc  Speed Test of Derivatives Using Adolc  ",
"adolc_det_minor.cpp  Adolc Speed: Gradient of Determinant by Minor Expansion   link_det_minor",
"adolc_det_lu.cpp  Adolc Speed: Gradient of Determinant Using Lu Factorization   link_det_lu matrix",
"adolc_mat_mul.cpp  Adolc Speed: Matrix Multiplication   link_mat_mul multiply",
"adolc_ode.cpp  Adolc Speed: Ode   link_ode",
"adolc_poly.cpp  Adolc Speed: Second Derivative of a Polynomial   link_poly",
"adolc_sparse_hessian.cpp  Adolc Speed: Sparse Hessian   link_sparse_hessian",
"adolc_sparse_jacobian.cpp  adolc Speed: Sparse Jacobian   link_sparse_jacobian",
"adolc_alloc_mat  Adolc Test Utility: Allocate and Free Memory For a Matrix  ",
"speed_cppad  Speed Test Derivatives Using CppAD  ",
"cppad_det_minor.cpp  CppAD Speed: Gradient of Determinant by Minor Expansion   link_det_minor",
"cppad_det_lu.cpp  CppAD Speed: Gradient of Determinant Using Lu Factorization   link_det_lu matrix",
"cppad_mat_mul.cpp  CppAD Speed: Matrix Multiplication   link_mat_mul multiply",
"cppad_ode.cpp  CppAD Speed: Gradient of Ode Solution   link_ode",
"cppad_poly.cpp  CppAD Speed: Second Derivative of a Polynomial   link_poly",
"cppad_sparse_hessian.cpp  CppAD Speed: Sparse Hessian   link_sparse_hessian",
"cppad_sparse_jacobian.cpp  CppAD Speed: Sparse Jacobian   link_sparse_jacobian",
"cppad_print_optimize  Speed Test Utility: Optimize Operation Sequences and Print Results  ",
"speed_fadbad  Speed Test Derivatives Using Fadbad  ",
"fadbad_det_minor.cpp  Fadbad Speed: Gradient of Determinant by Minor Expansion   link_det_minor",
"fadbad_det_lu.cpp  Fadbad Speed: Gradient of Determinant Using Lu Factorization   link_det_lu matrix",
"fadbad_mat_mul.cpp  Fadbad Speed: Matrix Multiplication   link_mat_mul multiply",
"fadbad_ode.cpp  Fadbad Speed: Ode   link_ode",
"fadbad_poly.cpp  Fadbad Speed: Second Derivative of a Polynomial   link_poly",
"fadbad_sparse_hessian.cpp  Fadbad Speed: Sparse Hessian  ",
"fadbad_sparse_jacobian.cpp  fadbad Speed: sparse_jacobian  ",
"speed_sacado  Speed Test Derivatives Using Sacado  ",
"sacado_det_minor.cpp  Sacado Speed: Gradient of Determinant by Minor Expansion   link_det_minor",
"sacado_det_lu.cpp  Sacado Speed: Gradient of Determinant Using Lu Factorization   link_det_lu matrix",
"sacado_mat_mul.cpp  Sacado Speed: Matrix Multiplication   link_mat_mul multiply",
"sacado_ode.cpp  Sacado Speed: Gradient of Ode Solution   link_ode",
"sacado_poly.cpp  Sacado Speed: Second Derivative of a Polynomial   link_poly",
"sacado_sparse_hessian.cpp  Sacado Speed: Sparse Hessian  ",
"sacado_sparse_jacobian.cpp  sacado Speed: sparse_jacobian  ",
"Appendix  Appendix  ",
"Faq  Frequently Asked Questions and Answers   assignment operator independent bugs reporting comparechange ndebug complex test exception errorhandler variable tape avoid record speed taping math functions inverse matrix forward reverse mode namespace cppad_testvector preprocessor symbols standard using storage memory disk",
"Theory  The Theory of Derivative Calculations  ",
"ForwardTheory  The Theory of Forward Mode  ",
"ExpForward  Exponential Function Forward Taylor Polynomial Theory  ",
"LogForward  Logarithm Function Forward Taylor Polynomial Theory  ",
"SqrtForward  Square Root Function Forward Taylor Polynomial Theory  ",
"SinCosForward  Trigonometric and Hyperbolic Sine and Cosine Forward Theory   sinh cosh",
"AtanForward  Arctangent Function Forward Taylor Polynomial Theory  ",
"AsinForward  Arcsine Function Forward Taylor Polynomial Theory  ",
"AcosForward  Arccosine Function Forward Taylor Polynomial Theory  ",
"tan_forward  Tangent and Hyperbolic Tangent Forward Taylor Polynomial Theory  ",
"ReverseTheory  The Theory of Reverse Mode  ",
"ExpReverse  Exponential Function Reverse Mode Theory  ",
"LogReverse  Logarithm Function Reverse Mode Theory  ",
"SqrtReverse  Square Root Function Reverse Mode Theory  ",
"SinCosReverse  Trigonometric and Hyperbolic Sine and Cosine Reverse Theory   sinh cosh",
"AtanReverse  Arctangent Function Reverse Mode Theory  ",
"AsinReverse  Arcsine Function Reverse Mode Theory  ",
"AcosReverse  Arccosine Function Reverse Mode Theory  ",
"tan_reverse  Tangent and Hyperbolic Tangent Reverse Mode Theory  ",
"reverse_identity  An Important Reverse Mode Identity  ",
"glossary  Glossary   ad function of base levels above type elementary vector operation atomic sequence dependent independent parameter sparsity pattern efficient boolean sets tape active inactive variable variables taylor coefficient",
"Bib  Bibliography  ",
"Bugs  Know Bugs and Problems Using CppAD   gcc 3.4.4",
"WishList  The CppAD Wish List   new features adolc atan2 checkpoint forward iterator compile speed ad<double> testing machine epsilon sequence operation optimize tape preprocessor tracing",
"whats_new  Changes and Additions to CppAD  ",
"whats_new_13  CppAD Changes and Additions During 2013  ",
"whats_new_12  CppAD Changes and Additions During 2012  ",
"whats_new_11  Changes and Additions to CppAD During 2011  ",
"whats_new_10  Changes and Additions to CppAD During 2010  ",
"whats_new_09  Changes and Additions to CppAD During 2009  ",
"whats_new_08  Changes and Additions to CppAD During 2008   erf ipopt_cppad_nlp",
"whats_new_07  Changes and Additions to CppAD During 2007  ",
"whats_new_06  Changes and Additions to CppAD During 2006   aclocal",
"whats_new_05  Changes and Additions to CppAD During 2005  ",
"whats_new_04  Changes and Additions to CppAD During 2004  ",
"whats_new_03  Changes and Additions to CppAD During 2003  ",
"deprecated  CppAD Deprecated API Features  ",
"include_deprecated  Deprecated Include Files  ",
"FunDeprecated  ADFun Object Deprecated Member Functions   dependent order memory size taylor_size use_vecad",
"omp_max_thread  OpenMP Parallel Setup   depreciated",
"TrackNewDel  Routines That Track Use of New and Delete   memory deprecated tracknewvec ndebug cppad_track_new_vec cppadtracknewvec trackdelvec cppad_track_del_vec cppadtrackdelvec trackextend cppad_track_extend cppadtrackextend trackcount cppad_track_count multi-threading",
"TrackNewDel.cpp  Tracking Use of New and Delete: Example and Test  ",
"omp_alloc  A Quick OpenMP Memory Allocator Used by CppAD   multi-threading allocation",
"omp_max_num_threads  Set and Get Maximum Number of Threads for omp_alloc Allocator   set_max_num_threads get_max_num_threads",
"omp_in_parallel  Is The Current Execution in OpenMP Parallel Mode   omp_alloc",
"omp_get_thread_num  Get the Current OpenMP Thread Number   omp_alloc",
"omp_get_memory  Get At Least A Specified Amount of Memory   get_thread_num omp_alloc",
"omp_return_memory  Return Memory to omp_alloc  ",
"omp_free_available  Free Memory Currently Available for Quick Use by a Thread   omp_alloc",
"omp_inuse  Amount of Memory a Thread is Currently Using   omp_alloc",
"omp_available  Amount of Memory Available for Quick Use by a Thread   omp_alloc",
"omp_create_array  Allocate Memory and Create A Raw Array   omp_alloc",
"omp_delete_array  Return A Raw Array to The Available Memory for a Thread   omp_alloc",
"omp_efficient  Check If A Memory Allocation is Efficient for Another Use   omp_alloc",
"old_max_num_threads  Set Maximum Number of Threads for omp_alloc Allocator  ",
"omp_alloc.cpp  OpenMP Memory Allocator: Example and Test   allocation multi-thread",
"memory_leak  Memory Leak Detection   check static deprecated",
"epsilon  Machine Epsilon For AD Types   deprecated",
"test_vector  Choosing The Vector Testing Template Class   cppad_test_vector deprecated",
"cppad_ipopt_nlp  Nonlinear Programming Using the CppAD Interface to Ipopt   deprecated",
"ipopt_nlp_get_started.cpp  Nonlinear Programming Using CppAD and Ipopt: Example and Test  ",
"ipopt_nlp_ode  Example Simultaneous Solution of Forward and Inverse Problem  ",
"ipopt_nlp_ode_problem  An ODE Inverse Problem Example  ",
"ipopt_nlp_ode_simple  ODE Fitting Using Simple Representation   cppad_ipopt_nlp",
"ipopt_nlp_ode_fast  ODE Fitting Using Fast Representation   cppad_ipopt_nlp",
"ipopt_nlp_ode_problem.hpp  ODE Inverse Problem Definitions: Source Code   example",
"ipopt_nlp_ode_simple.hpp  ODE Fitting Using Simple Representation   cppad_ipopt_nlp example source",
"ipopt_nlp_ode_fast.hpp  ODE Fitting Using Fast Representation   cppad_ipopt_nlp example source",
"ipopt_nlp_ode_run.hpp  Driver for Running the Ipopt ODE Example  ",
"ipopt_nlp_ode_check.cpp  Correctness Check for Both Simple and Fast Representations  ",
"ipopt_ode_speed.cpp  Speed Test for Both Simple and Fast Representations  ",
"old_atomic  User Defined Atomic AD Functions   cppad_user_atomic operation parallel",
"old_reciprocal.cpp  Old Atomic Operation Reciprocal: Example and Test   user",
"old_usead_1.cpp  Using AD to Compute Atomic Function Derivatives   inside user checkpoint",
"old_usead_2.cpp  Using AD to Compute Atomic Function Derivatives   inside user checkpoint",
"old_tan.cpp  Tan and Tanh as User Atomic Operations: Example and Test   old_atomic",
"old_mat_mul.cpp  Matrix Multiply as a User Atomic Operation: Example and Test   old_atomic",
"old_mat_mul.hpp  Define Matrix Multiply as a User Atomic Operation   old_atomic test example",
"compare_c  Compare Speed of C and C++   with",
"det_of_minor_c  Determinant of a Minor  ",
"det_by_minor_c  Compute Determinant using Expansion by Minors  ",
"uniform_01_c  Simulate a [0,1] Uniform Random Variate  ",
"correct_det_by_minor_c  Correctness Test of det_by_minor Routine  ",
"repeat_det_by_minor_c  Repeat det_by_minor Routine A Specified Number of Times  ",
"elapsed_seconds_c  Returns Elapsed Number of Seconds  ",
"time_det_by_minor_c  Determine Amount of Time to Execute det_by_minor  ",
"main_compare_c  Main Program For Comparing C and C++ Speed  ",
"License  Your License for the CppAD Software  "
]

var MaxList = 100;
var Choice  = "";
var Nstring = -1;
var Nkeyword = Keyword.length;
Initialize();

function Initialize()
{
	var i;
	var line;
	for(i = 0; (i < Nkeyword) && (i < MaxList) ; i++)
	{
		line       = Keyword[i].split(/\s+/)
		line[0]    = line[0].toUpperCase();
		line       = line.join(" ");
		Keyword[i] = line;
	}
	UpdateList();
	document.search.string.focus();
}
function UpdateList(event)
{
	key = 0;
	if( window.event )
		key = window.event.keyCode;
	else if( event )
		key = event.which;
	if( key == 13 )
	{	Choose();
		return;
	}
	var string  = document.search.string.value;
	if( Nstring == string.length )
		return;
	Nstring     = string.length;

	var word    = string.match(/\S+/g);
	var nword   = 0;
	if(word != null )
		nword   = word.length;

	var pattern = new Array(nword);
	for(var j = 0; j < nword; j++)
		pattern[j] = new RegExp(word[j], "i");

	var nlist = 0;
	var list  = "";
	Choice    = "";

	for(i = 0; (i < Nkeyword) && (nlist < MaxList) ; i++)
	{
		var match = true;
		for(j = 0; j < nword; j++)
			match = match && pattern[j].test(Keyword[i]);

		if( match )
		{
			line     = Keyword[i].split(/\s+/);

			if( Choice == "" )
				Choice = line[0];

			line  = line.join(" ");
			list  = list + line + "\n";
			nlist = nlist + 1;
		}
	}
	document.search.choice.value  = Choice.toLowerCase();
	document.search.list.value    = list;
}
function Choose()
{
parent.location = document.search.choice.value.toLowerCase() + ".xml";
}
