# (c) 2002-2004 LOGILAB S.A. (Paris, FRANCE).
# http://www.logilab.fr/ -- mailto:contact@logilab.fr
#
# This program is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free Software
# Foundation; either version 2 of the License, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along with
# this program; if not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA  02111-1307
# USA.

"""Provides an psyobj class regardless of the availability of psyco"""

__revision__ = '$Id: psyco_wrapper.py,v 1.10 2005/04/15 13:15:08 alf Exp $'

import os

try:
    from psyco.classes import psyobj as Psyobj
except ImportError:
    from warnings import warn
    warn("""Psyco could not be loaded.
Psyco is a Python just in time compiler available at http://psyco.sf.net
Installing it will enhance the performance of logilab.constraint""",
         stacklevel=2)
          
    class Psyobj:
        pass


