;;; -*- Mode: Lisp; Package: System -*-
;;;
;;; **********************************************************************
;;; This code was written as part of the CMU Common Lisp project at
;;; Carnegie Mellon University, and has been placed in the public domain.
;;;

;;; Heavy modifications by Peter Van Eynde

(in-package "SYSTEM")

(if (probe-file "/etc/lisp-config.lisp")
    (load "/etc/lisp-config.lisp")
  (format t "~%;;; Hey: there is no /etc/lisp-config.lisp file, please run cmuclconfig"))

;;; If you have sources installed on your system, un-comment the following form
;;; and change it to point to the source location.  This will allow the Hemlock
;;; "Edit Definition" command and the debugger to find sources for functions in
;;; the core.
(setf (ext:search-list "target:")
      '(
        "/usr/share/common-lisp/source/cmucl/"      ; object dir
        ))

(setf (ext:search-list "library:") '("/usr/lib/cmucl/"))
;;; for safety...

;;; optional extentions to the lisp image: delete if you
;;; don't like them :-).
(in-package :common-lisp-user)

(defvar hs-index (make-hash-table))

(defun read-hyperspec-index ()
  (with-open-file (table
                   "/usr/share/doc/hyperspec/Data/Symbol-Table.text"
		   :direction :input
		   :if-does-not-exist nil)
    (if (not table)
	(format t "I can't find the symbol table of the Hyperspec,~%Are you sure you've installed the hyperspec package?~%")
	(progn
	  (loop
	   (let* ((symbol (read table nil :einde))
		  (section (read-line table nil :einde)))
	     (if (or (eq symbol :einde)
		     (eq section :einde))
		 (return))
	     (setf (gethash symbol hs-index)
		   section)))))))

(defun lookup-in-hyperspec (key)
  (if (not (gethash 'nil hs-index))
      (read-hyperspec-index))
  (concatenate 'string "/usr/share/doc/hyperspec/Data/"
	       (gethash key hs-index)))

(defun show-hs (symbol)
  "Shows the definition of a lisp symbol in the HyperSpec in a Netscape
  window, or opens Netscape if it can."
  (when (not (gethash 'nil hs-index))
    (read-hyperspec-index))
  (if (not (gethash symbol hs-index))
      (format t "Symbol ~A not found in hyperspec, sorry~%"
	      symbol)
      ;; stupid but works: if there isn't a window open
      ;; the remote will fail, so we try to start a new
      ;; window :-)
      (unless (= 0
	       (process-exit-code
		(run-program "netscape"
			     (list "-remote" (format
					      nil "openURL(file:~A)"
					      (lookup-in-hyperspec symbol)))
			     :env *ENVIRONMENT-LIST*
			     :wait nil
			     :input nil
			     :output nil
			     :error nil)))
	(run-program "netscape"
		     (list (format nil "file:~A"
				   (lookup-in-hyperspec symbol)))
		     :env *ENVIRONMENT-LIST*
		     :wait nil
		     :input nil
		     :output nil
		     :error nil))))

;;; newbie functions, delete if you don't like them, but
;;; also modify the *herald-items* above

#-hemlock
(defun ed (&rest rest)
  (multiple-value-bind (return errorp)
    (ignore-errors (require :cmucl-hemlock))
   (if errorp
     (error "Sorry, cannot find hemlock, please install and use ilisp. Reason: ~S" errorp)
    (apply #'ed rest))))

(defun help ()
  (format t "~
Welcome to CMUCL for Linux.

If you aren't running this with ilisp in emacs,
or aren't intending to use hemlock then you
deserve to lose. :-)

Read the documentation in /usr/share/doc/cmucl.

Create your own personal image with
/usr/sbin/cmuclconfig

(quit) is to quit.
(ed) starts hemlock (if installed)
(demo) shows a list of demos
(describe 'progn) gives information about progn for 
 example.
(inspect '*a*) interactively inspects *a* for example.
"))

(defun demo ()
  (format t "Some demos are in the source package, some in the
normal package.

General demos:
CLX demos:
 if you have installed cmucl-source you can do:
 (requre :cmucl-clx)
 (load \"cl-library:cmucl-clx;demo;hello\")
 (xlib::hello-world \"\")
 (load \"cl-library:;cmucl-clx;demo;menu\")
 (xlib::just-say-lisp \"\")
 (xlib::pop-up \"\"
	       '(\"Linux\" \"FreeBSD\" \"OpenBSD\"))
  exit by pressing control+C followed by a keypress.

Clue demos:
 if you have installed the clue package you can do:
 (require :clue)
 (load \"cl-library:;clue;examples;menu\")
 (clue-examples::beatlemenuia \"\")
 (clue-examples::pick-one \"\"
			  \"One\"
			  \"Two\"
			  \"Three\")
 (clue-examples::just-say-lisp \"\")
 
 or you can use the Clio demos:
 (require :clio)
 (require :clio-examples)
 (clio-examples::sketch :host  "")

Pictures demos:
 (require :pictures)
 (load \"cl-library:;pictures;examples;road-demo\")
 (pictures::road-demo)
 press control-a to animate

"))

(load "/usr/share/common-lisp/source/common-lisp-controller/common-lisp-controller.lisp")

(common-lisp-controller:init-common-lisp-controller 
 (cond
   ((member :high-security *features*)
    "/usr/lib/common-lisp/cmucl-safe/")
   ((member :small *features*)
    "/usr/lib/common-lisp/cmucl-small/")
   (t
    "/usr/lib/common-lisp/cmucl-normal/")))

