/*
 *  Copyright (C) 2004 Tony Sin(x) '76 <tony@becrux.com>
 *  All rights reserved.
 *
 */

/*
 *			 GNU GENERAL PUBLIC LICENSE
 *			    Version 2, June 1991
 *
 *  Copyright (C) 1989, 1991 Free Software Foundation, Inc.
 *                           675 Mass Ave, Cambridge, MA 02139, USA
 *  Everyone is permitted to copy and distribute verbatim copies
 *  of this license document, but changing it is not allowed.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.

 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifdef HAVE_CONFIG_H
  #ifndef __main_config_h__
    #define __main_config_h__
    #include "../config.h"
  #endif

  #include <stdlib.h>
  #include <string.h>
#endif

#include "list.h"

//---------------------------------------------------------------------
cNode::cNode()
{
  Next = NULL;
  Item = NULL;
}

cNode::~cNode()
{
  if (Item != NULL)
    delete [] Item;
  Next = NULL;
}

cNode::cNode(const char *buf)
{
  Item = new char[strlen(buf)+1];

  strcpy(Item,buf);

  Next = NULL;
}

cNode *cNode::GetNext() const
{
  return Next;
}

char *cNode::GetItem() const
{
  return Item;
}

void cNode::LatchUp(cNode *p)
{
  Next = p;
}
//---------------------------------------------------------------------

//---------------------------------------------------------------------
cList::cList()
{
  First = Now = Last = NULL;
}

cList::~cList()
{
  cNode *p;

  while ((p = First) != NULL)
  {
    First = First->GetNext();
    delete p;
  }

  First = Now = Last = NULL;
}

void cList::Add(const char *buf)
{
  if (First == NULL)
    Now = First = (Last = new cNode(buf));
  else
  {
    cNode *p = new cNode(buf);
  
    Last->LatchUp(p);
    Last = p;
  }
}

char *cList::GetFile()
{
  char *p = NULL;

  if (Now != NULL)
  {
    p = Now->GetItem();
    Now = Now->GetNext();
  }

  return p;
}

bool cList::AreMore() const
{
  return (Now != NULL);
}
//---------------------------------------------------------------------
