;;; -*- Mode: Lisp -*-
;;;; MaiSQL --- Common Lisp Interface Layer to SQL Databases
;;;; This is copyrighted software.  See documentation for terms.
;;;; 
;;;; packages.cl --- Package definitions for MaiSQL
;;;; 
;;;; Checkout Tag: $Name:  $
;;;; $Id: package.lisp,v 1.31 2001/12/28 21:06:12 craig Exp $

(in-package :CL-USER)

;;;; %File Description:
;;;; 
;;;; 
;;;; 

(eval-when (:COMPILE-TOPLEVEL :LOAD-TOPLEVEL :EXECUTE)
(defpackage :maisql-sys
    (:nicknames :sql-sys)
    ;; This is for working with the CMUCL PCL MOP, which is kinda whacky
    #+(or cmu sbcl)
    (:shadowing-import-from #+cmu :mop #+sbcl :sb-pcl
                                  :built-in-class 
                                  :class-direct-slots
                                  :class-name
                                  :class-of
                                  :class-slots
                                  :compute-effective-slot-definition
                                  :direct-slot-definition-class
                                  :effective-slot-definition-class
                                  :find-class
                                  :slot-boundp
                                  :slot-definition-name
                                  :slot-definition-type
                                  :slot-value-using-class
                                  :standard-direct-slot-definition
                                  :standard-effective-slot-definition
                                  :validate-superclass)
    #+(or sbcl cmu)
    (:shadowing-import-from #+cmu :pcl #+sbcl sb-pcl
                                  :class-direct-superclasses
                                  :name
                                  :standard-class)
    (:use :common-lisp :odcl #+lispworks :clos)
    (:export
     ;; "Private" exports for use by interface packages
     "CHECK-CONNECTION-SPEC"
     "DATABASE-INITIALIZE-DATABASE-TYPE"
     "DATABASE-TYPE-LOAD-FOREIGN"
     "DATBASE-NAME-FROM-SPEC"
     "DATABASE-CONNECT"
     "DATABASE-DISCONNECT"
     "DATABASE-QUERY"
     "DATABASE-EXECUTE-COMMAND"
     "DATABASE-CREATE-SEQUENCE"
     "DATABASE-DROP-SEQUENCE"
     "DATABASE-SEQUENCE-NEXT"
     "DATABASE-QUERY-RESULT-SET"
     "DATABASE-DUMP-RESULT-SET"
     "DATABASE-STORE-NEXT-ROW"
     "DATABASE-START-TRANSACTION"
     "DATABASE-COMMENT-TRANSACTION"
     "DATABASE-ABORT-TRANSACTION"
     "DATABASE-GET-TYPE-SPECIFIER"
     "DATABASE-LIST-TABLES"
     "DATABASE-LIST-ATTRIBUTES"
     "DATABASE-ATTRIBUTE-TYPE"
     .
     ;; Shared exports for re-export by MAISQL.
     ;; I = Implemented, D = Documented
     ;;  name                           ; file          ID
     #1=("ADD-SQL-STREAM"		; recording     XX
	 "ATTRIBUTE-TYPE"		; table		XX
	 "COMMIT"			; sql		.
	 "CONNECT"			; sql		XX
	 "*CONNECT-IF-EXISTS*"		; sql		XX 
	 "CONNECTED-DATABASES"		; sql	        XX
	 "WITH-DATABASE"                ; sql           XX
	 "CREATE-INDEX"			; table		.
         "CREATE-SEQUENCE"              ; sql
	 "CREATE-TABLE"			; table	        X
	 "CREATE-VIEW"			; ?		.
	 "CREATE-SEQUENCE-FROM-CLASS"	; objects    	X
	 "CREATE-VIEW-FROM-CLASS"	; objects    	X
	 "DATABASE"			; sql		X
	 "DATABASE-NAME"		; sql		X
	 "*DEFAULT-DATABASE*"		; sql		X
	 "*DEFAULT-DATABASE-TYPE*"	; sql		X
	 "DEF-VIEW-CLASS"		; objects    	X
	 "DELETE-INSTANCE-RECORDS"	; objects 
	 "DELETE-RECORDS"		; sql		X
	 "DELETE-SQL-STREAM"		; recording	X
         "DESTROY-CONNECTION-POOL"      ; pools - unimpl.
	 "DISABLE-SQL-READER-SYNTAX"	; syntax	X
	 "DISCONNECT"			; sql		X
	 "DO-QUERY"			; sql		X
	 "DROP-INDEX"			; table		.
         "DROP-SEQUENCE"                ; sql
	 "DROP-TABLE"			; table 	X
	 "DROP-VIEW"			; ?		.
	 "DROP-SEQUENCE-FROM-CLASS"     ; objects    	
	 "DROP-VIEW-FROM-CLASS"		; objects    	X
	 "SEQUENCE-FROM-CLASS"		; objects    	X
	 "ENABLE-SQL-READER-SYNTAX"	; syntax	X
	 "EXECUTE-COMMAND"		; sql		X
	 "FIND-DATABASE"		; sql		X
	 "INITIALIZE-DATABASE-TYPE"	; sql		X
	 "*INITIALIZED-DATABASE-TYPES*"	; sql		X
	 "INSERT-RECORDS"		; sql.lisp      X
	 "LIST-ATTRIBUTES"		; table		X
	 "LIST-CLASSES"			; objects    	X
	 "LIST-SQL-STREAMS"		; recording    	X
	 "LIST-TABLES"			; table		X
	 "LOCALLY-DISABLE-SQL-READER-SYNTAX" ; syntax	X
	 "LOCALLY-ENABLE-SQL-READER-SYNTAX" ; syntax	X
	 "LOOP"				; sql		X
         "MAKE-CONNECTION-POOL"         ; pools
	 "MAP-QUERY"			; sql		X
	 "PRINT-QUERY"			; sql		.
	 "QUERY"			; sql		X
	 "RESTORE-SQL-READER-SYNTAX-STATE" ; syntax    	X
	 "ROLLBACK"			; sql		.
	 "SELECT"			; sql		X
         "SEQUENCE-NEXT"                ; sql
	 "SQL"				; sql		X
	 "DATABASE-OUTPUT-SQL"
	 "SQL-EXPRESSION"		; sql		X
	 "SQL-OPERATION"		; operations   	X
	 "SQL-OPERATOR"			; operations   	X
	 "SQL-RECORDING-P"		; recording     X
	 "SQL-STREAM"			; recording    	X
	 "START-SQL-RECORDING"		; recording    	X
	 "STATUS"			; ?		.
	 "STANDARD-DB-OBJECT"		; metaclass     X
	 "STOP-SQL-RECORDING"		; recording    	X
	 "UPDATE-INSTANCE-FROM-DB"      ; object        X
	 "UPDATE-RECORDS"		; sql		X
	 "UPDATE-RECORDS-FROM-INSTANCE"	; object    	X
         "STORE-INSTANCE"               ; aliases above function
	 "UPDATE-RECORD-FROM-SLOT"	; object       	X
	 "UPDATE-RECORD-FROM-SLOTS"	; object       	X
	 "ADD-TO-RELATION"              ; object        X
	 "REMOVE-FROM-RELATION"
	 "VIEW-TABLE"                   ; metaclass     X
         "WITH-DATABASE-CONNECTION"     ; pools
         "CONNECTION-DATABASE"          ; pools
	 "WITH-TRANSACTION"		; sql		.
	 "DATABASE-GET-TYPE-SPECIFIER"  ; object        X
	 "DATABASE-OUTPUT-SQL-AS-TYPE"  ; object        X
	 "READ-SQL-VALUE"               ; object        X
	 
	 ;; Added my MaiSQL
	 "*LOADED-DATABASE-TYPES*"
	 "RELOAD-DATABASE-TYPES"
	 "CLOSED-DATABASE"
	 "DATABASE-NAME-FROM-SPEC"

         ;; Schema instantiation and versioning
         "DESCRIBE-SCHEMA"
         "VALIDATE-SCHEMA"
         "INSTALL-SCHEMA"
         "REMOVE-SCHEMA"

         ;; Query construction support
         "DEFQUERY"

         ;; general purpose metadata
         "DEF-METADATA"
         "META-QUAL"
         "FIND-META"
         "DELETE-META"
         "STORE-META"
         "GET-META"
         "META-JOIN"
         "OID"

         ;;
         "SQL-AND-QUALIFIER"
         "SQL-ESCAPE"
	 "SQL-QUERY"
	 "SQL-ANY"
	 "SQL-ALL"
	 "SQL-NOT"
	 "SQL-UNION"
	 "SQL-INTERSECTION"
	 "SQL-MINUS"
	 "SQL-GROUP-BY"
	 "SQL-HAVING"
	 "SQL-NULL"
	 "SQL-NOT-NULL"
	 "SQL-EXISTS"
	 "SQL-*"
	 "SQL-+"
	 "SQL-/"
	 "SQL-LIKE"
	 "SQL-UPLIKE"
	 "SQL-AND"
	 "SQL-OR"
	 "SQL-IN"
	 "SQL-||"
	 "SQL-IS"
	 "SQL-="
	 "SQL-=="
	 "SQL-<"
	 "SQL->"
	 "SQL->="
	 "SQL-<="
	 "SQL-COUNT"
	 "SQL-MAX"
	 "SQL-MIN"
	 "SQL-AVG"
	 "SQL-SUM"
	 "SQL-VIEW-CLASS"
	 "SQL_SLOT-VALUE"
         
	 ;; Conditions and errors
	 "MAISQL-CONDITION"
	 "MAISQL-ERROR"
	 "MAISQL-SIMPLE-ERROR"
	 "MAISQL-WARNING"
	 "MAISQL-SIMPLE-WARNING"
	 "MAISQL-INVALID-SPEC-ERROR"
	 "MAISQL-INVALID-SPEC-ERROR-CONNECTION-SPEC"
	 "MAISQL-INVALID-SPEC-ERROR-DATABASE-TYPE"
	 "MAISQL-INVALID-SPEC-ERROR-TEMPLATE"
	 "MAISQL-CONNECT-ERROR"
	 "MAISQL-CONNECT-ERROR-DATABASE-TYPE"
	 "MAISQL-CONNECT-ERROR-CONNECTION-SPEC"
	 "MAISQL-CONNECT-ERROR-ERRNO"
	 "MAISQL-CONNECT-ERROR-ERROR"
	 "MAISQL-SQL-ERROR"
	 "MAISQL-TYPE-ERROR"
	 "MAISQL-SQL-ERROR-DATABASE"
	 "MAISQL-SQL-ERROR-EXPRESSION"
	 "MAISQL-SQL-ERROR-ERRNO"
	 "MAISQL-SQL-ERROR-ERROR"
	 "Maisql-EXISTS-CONDITION"
	 "MAISQL-EXISTS-CONDITION-NEW-DB"
	 "MAISQL-EXISTS-CONDITION-OLD-DB"
	 "MAISQL-EXISTS-WARNING"
	 "MAISQL-EXISTS-ERROR"
	 "MAISQL-CLOSED-ERROR"
	 "MAISQL-CLOSED-ERROR-DATABASE"

         ;; Editing Context
         "WITH-CONTEXT"
         "WITHOUT-CONTEXT"
         "MAKE-EDITING-CONTEXT"
         "DESTROY-EDITING-CONTEXT"
         "EC-REGISTER"
         "REGISTERED-IN-EDITING-CONTEXT?"
         "EC-RESET"
         "EC-INSERT"
         "EC-DELETE"
         "EC-EDIT"
         "EC-COMMIT"
         "EC-UNWIND-STACK"
         "VIEW-OBJECTS-EQUAL"
         "INSTANCE-KEY"
         "INSTANCE-BY-KEY"
         "INSTANCE-BY-KEY-NOCACHE"
	 ))
    (:documentation "This is the INTERNAL SQL-Interface package of MaiSQL."))

(defpackage :maisql
    (:nicknames :sql)
    (:use :common-lisp :odcl)
    (:import-from "MAISQL-SYS" . #1#)
    (:export . #1#)
    (:documentation "This is the SQL-Interface package of MaiSQL."))
)                                       ;progn

(defpackage "MAISQL-USER"
    (:use "COMMON-LISP" "MAISQL")
    (:documentation "This is the user package for experimenting with MaiSQL."))



