(defpackage :pop-sql
  (:use :common-lisp :mp :sql)
  (:export :kill))

(in-package :pop-sql)

(defvar *connection-pool* nil)

(defvar *select-count* 0)
(defvar *last-row-count* 0)

(setq ext:*gc-verbose* t)

(def-view-class widget ()
  ((number
    :db-kind :key
    :type integer
    :initarg :number)
   (name
    :db-kind :base
    :type string
    :initarg :name))
  (:schemas "TRASH"))

(defun kill (kind)
  (case kind
    (:all
     (pop-db))
    (:db
     (pop-serially))
    (:noyield
     (pop-no-yield))))

;; SEGVs

(defun pop-db ()
  (setq *connection-pool*
        (make-connection-pool :db-type :postgresql
                              :db-dict '(nil "trash" "jesse" nil)))
  (format t ";; here we go~%")
  (setq *select-count* 0
        *last-row-count* 0)
  (mp::start-sigalrm-yield)
  (with-database-connection *connection-pool*
    (install-schema "TRASH"))
  (loop
   (make-process #'select-widget)
   (make-process #'build-widget)
   (when (< 16 (length mp::*all-processes*))
     (format t ";; snore~%")
     (sleep 10))))

;; doesn't SEGV

(defun pop-serially ()
  (setq *connection-pool*
        (make-connection-pool :db-type :postgresql
                              :db-dict '(nil "trash" "jesse" nil)))
  (format t ";; here we go~%")
  (setq *select-count* 0
        *last-row-count* 0)
  (with-database-connection *connection-pool*
    (install-schema "TRASH"))
  (loop
   (select-widget)
   (build-widget)))

(defun pop-no-yield ()
  (setq *connection-pool*
        (make-connection-pool :db-type :postgresql
                              :db-dict '(nil "trash" "jesse" nil)))
  (format t ";; here we go~%")
  (setq *select-count* 0
        *last-row-count* 0)
  (with-database-connection *connection-pool*
    (install-schema "TRASH"))
  (loop
   (make-process #'select-widget)
   (make-process #'build-widget)
   (process-yield)
   (when (< 16 (length mp::*all-processes*))
     (format t ";; snore~%")
     (sleep 10))))

(defun pop-simple-1 ()
  (loop
   (format t ";; snore~%")
   (sleep 10)))

(defun select-widget ()
  (with-database-connection *connection-pool*
    (dotimes (x 100)
      (setq *last-row-count* (length (select 'widget)))
      (process-yield)
      (incf *select-count*))))

(defun random-string ()
  (let* ((length (random 4000))
         (id (make-string length)))
    (do ((x 0 (incf x)))
	(( = x length))
      (setf (aref id x) (code-char (+ 97 (random 26)))))
    id))

(defun build-widget ()
  (with-database-connection *connection-pool*
    (dotimes (x 1000)
      (let ((widget (make-instance 'widget
                                   :number (sequence-next (sequence-from-class 'widget))
                                   :name (random-string))))
        (process-yield)
        (store-instance widget)))))
