;;; -*- Mode: Lisp -*-
;;; $Id: unix.lisp,v 1.8 2001/11/12 19:48:20 jesse Exp $
;;;
;;; Copyright (c) 2000, 2001 onShore Development, Inc.
;;;
;;; Calls to unix.

(in-package :local-time)

(declaim (optimize (speed 3) (debug 1) #+cmu (extensions:inhibit-warnings 3)))

#+cmu
(progn
(def-alien-type time-t long)

(def-alien-type nil
    (struct time
            (tm-sec   int)              ; seconds
            (tm-min   int)              ; minutes
            (tm-hour  int)              ; hours
            (tm-mday  int)              ; day of month
            (tm-mon   int)              ; month
            (tm-year  int)              ; year
            (tm-wday  int)              ; day of week
            (tm-yday  int)              ; day of year
            (tm-isdst int)))            ; daylight savings time

(defun libc-gmtime (time)
  (let ((fn (extern-alien "gmtime" (function (* (struct time)) (* time-t)))))
    (with-alien ((alien-time time-t time))
      (let ((result (alien-funcall fn (addr alien-time))))
        (values (slot result 'tm-sec)              ; seconds
                (slot result 'tm-min)              ; minutes
                (slot result 'tm-hour)              ; hours
                (slot result 'tm-mday)              ; day of month
                (slot result 'tm-mon)              ; month
                (slot result 'tm-year)              ; year
                (slot result 'tm-wday)              ; day of week
                (slot result 'tm-yday)              ; day of year
                (slot result 'tm-isdst))))))            ; daylight savings time

(defun libc-localtime (time)
  (declare (type integer time))
  (let ((fn (extern-alien "localtime" (function (* (struct time)) (* time-t)))))
    (with-alien ((alien-time time-t time))
      (let ((result (alien-funcall fn (addr alien-time))))
        (values (slot result 'tm-sec)              ; seconds
                (slot result 'tm-min)              ; minutes
                (slot result 'tm-hour)              ; hours
                (slot result 'tm-mday)              ; day of month
                (slot result 'tm-mon)              ; month
                (slot result 'tm-year)              ; year
                (slot result 'tm-wday)              ; day of week
                (slot result 'tm-yday)              ; day of year
                (slot result 'tm-isdst))))))            ; daylight savings time

(defun gmt-offset (time)
  (let* ((gmt (multiple-value-list (libc-gmtime time)))
         (loc (multiple-value-list (libc-localtime time)))
         (delta (mapcar #'- gmt loc)))
    (* -3600 (if (not (= 0 (nth 7 delta)))
                (+ 24 (nth 2 delta))
                (nth 2 delta)))))

(defun utc-offset ()
  (gmt-offset (nth 1 (multiple-value-list (unix:unix-gettimeofday)))))

(def-alien-variable ("timezone" libc-timezone) time-t)

(def-alien-variable ("tzname" libc-tzname) (array c-string 2))

(defun libc-mktime (year mon mday &optional (hour 0) (min 0) (sec 0))
  (declare (type integer year mon mday hour min sec))
  (let ((fn (extern-alien "mktime" (function time-t (* (struct time))))))
    (with-alien ((alien-time (struct time)))
      (setf (slot alien-time 'tm-year) (- year 1900))
      (setf (slot alien-time 'tm-mon) (1- mon))
      (setf (slot alien-time 'tm-mday) mday)
      (setf (slot alien-time 'tm-hour) hour)
      (setf (slot alien-time 'tm-min) min)
      (setf (slot alien-time 'tm-sec) sec)
      (setf (slot alien-time 'tm-yday) 0)
      (setf (slot alien-time 'tm-wday) 0)
      (setf (slot alien-time 'tm-isdst) 0)
      (let ((result (alien-funcall fn (addr alien-time))))
        result))))

(defun maketime (year mon mday)
  (let ((time-a (libc-mktime year mon mday))
        (time-b (libc-mktime year 1 1)))
    (+ time-a (- (gmt-offset time-a) (gmt-offset time-b)))))
)