#include "cp_types.h"
#include "cp_proto.h"

int set_aim_current(struct p_data *p,int flag)
/* put current curvatures into aim. If flag, put neg aim in for 
bdry, since they are considered free. */
{
  int i;
  struct K_data *pK_ptr;
  struct R_data *pR_ptr;

  pK_ptr=p->packK_ptr;
  pR_ptr=p->packR_ptr;
  for (i=1;i<=p->nodecount;i++)
    {
      pR_ptr[i].aim=pR_ptr[i].curv;
      if (flag && pK_ptr[i].bdry_flag) pR_ptr[i].aim=-1;
    }
  return 1;
} /* set_aim_current */

int set_aim_default(struct p_data *p)
     /* put 2pi aim in for interior and -1 for bdry.*/
{
  int i;
  struct K_data *pK_ptr;
  struct R_data *pR_ptr;

  pK_ptr=p->packK_ptr;
  pR_ptr=p->packR_ptr;
  for (i=1;i<=p->nodecount;i++)
    {
      if (pK_ptr[i].bdry_flag) pR_ptr[i].aim=-1;
      else pR_ptr[i].aim=2.0*M_PI;
    }
  return 1;
} /* set_aim_default */

int set_aims(struct p_data *p,char *datastr)
/* Set the intended target angle sums. */ 
{ 
  int count=0,mode=0,k,hits;
  double inc,ang;
  char *nextpoint,*endptr;
  char next[256];
  struct Vertlist *vertlist,*trace;
  struct R_data *pR_ptr;
  struct K_data *pK_ptr;
  
  pR_ptr=p->packR_ptr;pK_ptr=p->packK_ptr;
  nextpoint=datastr;
  grab_next(&nextpoint,next);
  if (next[0]=='-' && next[1]=='d') mode=0; /* default mode */
  else if (next[0]=='-' && next[1]=='c') mode=1;/* current mode */
  else if (next[0]=='-' && next[1]=='%') /* modify mode */
    {
      mode=2;
      grab_next(&nextpoint,next);
      if (sscanf(next,"%lf",&inc)!=1) return 0; 
      /* no increment was given */
    }
  else mode=3;
  if (mode==3 && sscanf(next,"%lf",&ang)!=1) return 0;
  /* no angle given */
  if ((vertlist=Node_link_parse(p,nextpoint,&endptr,&hits,
		&Vlist,&Elist,&Flist,&region,pathlist,pathlength))
      ==NULL)
    {
      if (mode==3 || mode==2) return 0; /* no verts given */
      if (mode==0)
	{ 
	  set_aim_default(p);
	  return (p->nodecount);
	}
      if (mode==1)
	{
	  set_aim_current(p,0);
	  return (p->nodecount);
	}
    }
  if (mode==3 && ang==0.0 && p->hes >= 0) return 0;
  /* inappropriate angle */
  trace=vertlist;
  do {
    k=trace->v;
    if (mode==0) 
      {
	if (!pK_ptr[k].bdry_flag) pR_ptr[k].aim=2.0*M_PI;
	else pR_ptr[k].aim=-1.0;
      }
    else if (mode==1) pR_ptr[k].aim=pR_ptr[k].curv;
    else if (mode==2) pR_ptr[k].aim=pR_ptr[k].aim+inc*M_PI;
    else if (mode==3)
      {
	if (ang!=0.0 || ((p->hes < 0) && pK_ptr[k].bdry_flag))
	  pR_ptr[k].aim=ang*M_PI;
	else count--;
      }
    count++;
    trace=trace->next;
  } while (trace!=NULL);
  vert_free(&vertlist);
  return count;
} /* set_aims */


























  
