#include "cp_types.h"
#include "cp_proto.h"

/* given linked list of edges, return list of faces on their left. 
flag means to close up with last face. On error return partial 
list if consistent. */

struct Vertlist *path_follow(struct p_data *p,
			     struct Edgelist *edgelist,int flag)
{
  int v,u,w,stopv,nextf;
  struct Edgelist *etrace;
  struct Vertlist *facelist,*ftrace;
     
  facelist=NULL;
  /* find first face */
  if (edgelist==NULL || !(nextf=
			  left_face(p,(v=edgelist->v),(w=edgelist->w),&u))) return facelist;
  facelist=(struct Vertlist *)
    calloc((size_t)1,sizeof(struct Vertlist));
  facelist->v=nextf;
  etrace=edgelist->next;
  ftrace=facelist;
  /* add while edges last */
  while (etrace!=NULL)
    {
      stopv=etrace->w;
      /* get clockwise faces about w */
      v=u;
      while (u!=stopv && (nextf= left_face(p,v,w,&u)))
	{
	  v=u;
	  ftrace=ftrace->next=(struct Vertlist *)
	    calloc((size_t)1,sizeof(struct Vertlist));
	  ftrace->v=nextf;
	}
      if (u!=stopv) return facelist; /* ran into boundary */
      v=etrace->v;
      w=etrace->w;
      left_face(p,v,w,&u);
      etrace=etrace->next;
    }
  if (!flag || ftrace->v==facelist->v) return facelist;
  stopv=v;
  v=u;
  while (u!=stopv && (nextf=left_face(p,u,w,&u)))
    {
      ftrace=ftrace->next=(struct Vertlist *)
	calloc((size_t)1,sizeof(struct Vertlist));
      ftrace->v=nextf;
      if (nextf==facelist->v) return facelist;
    }
  return facelist;
} /* path_follow */
