#include "cp_types.h"
#include "cp_proto.h"

/* returns best radius at vert i to get anglesum aim, via secant 
method. s = first guess. */

extern int iterates;

double h_radcalc(struct p_data *p,int i,double s,double aim,int *chgflag)
{
  int n,flag;
  double bestcurv,lower=0.5,upper=0.5,upcurv,lowcurv,factor=0.5;

  h_anglesum_overlap(p,i,s,&bestcurv,&flag);
  if (bestcurv>(aim+okerr))
    {
      lower=s*factor;
      h_anglesum_overlap(p,i,lower,&lowcurv,&flag);
      (*chgflag)++;
      if (lowcurv>aim) return lower;
    }
  else if (bestcurv<(aim-okerr))
    {
      upper=1-factor+s*factor;
      h_anglesum_overlap(p,i,upper,&upcurv,&flag);
      (*chgflag)++;
      if (upcurv<aim) return upper;
    }
  else return s;
  (*chgflag)++;
  for (n=1;n<=iterates;n++)
    {
      if (bestcurv>(aim+okerr)) 
	{
	  upper=s;
	  upcurv=bestcurv;
	  s -= (bestcurv-aim)*(lower-s)/(lowcurv-bestcurv);
	}
      else if (bestcurv<(aim-okerr))
	{
	  lower=s;
	  lowcurv=bestcurv;
	  s += (aim-bestcurv)*(upper-s)/(upcurv-bestcurv);
	}
      else return s;
      h_anglesum_overlap(p,i,s,&bestcurv,&flag);
    }
  return s;
} /* h_radcalc */
