// Copyright (c) 2011 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CHROME_BROWSER_UI_TABS_TAB_MENU_MODEL_H_
#define CHROME_BROWSER_UI_TABS_TAB_MENU_MODEL_H_

#include "chrome/browser/ui/send_tab_to_self/send_tab_to_self_sub_menu_model.h"
#include "ui/base/models/simple_menu_model.h"

class TabStripModel;

// A menu model that builds the contents of the tab context menu. To make sure
// the menu reflects the real state of the tab a new TabMenuModel should be
// created each time the menu is shown.
// IDS in the TabMenuModel cannot overlap. Most menu items will use an ID
// defined in chrome/app/chrome_command_ids.h however dynamic menus will not.
// If adding dynamic IDs to a submenu of this menu, add it to this list
// and make sure the values don't overlap with ranges used by any of the models
// in this list. Also make sure to allocate a fairly large range so you're not
// likely having to expand it later on:
//   ExistingTabGroupSubMenuModel
//   ExistingWindowSubMenuModel
//   SendTabToSelfSubMenuModel
class TabMenuModel : public ui::SimpleMenuModel {
 public:
  TabMenuModel(ui::SimpleMenuModel::Delegate* delegate,
               TabStripModel* tab_strip,
               int index);
  TabMenuModel(const TabMenuModel&) = delete;
  TabMenuModel& operator=(const TabMenuModel&) = delete;
  ~TabMenuModel() override;

 private:
  void Build(TabStripModel* tab_strip, int index);

  std::unique_ptr<ui::SimpleMenuModel> add_to_existing_group_submenu_;
  std::unique_ptr<ui::SimpleMenuModel> add_to_existing_window_submenu_;

  // Send tab to self submenu.
  std::unique_ptr<send_tab_to_self::SendTabToSelfSubMenuModel>
      send_tab_to_self_sub_menu_model_;
};

#endif  // CHROME_BROWSER_UI_TABS_TAB_MENU_MODEL_H_
