(include "test-infrastructure.scm")

(define testit
(lambda ()
	;; the output-style-human display function only take ONE package at the
	;; toplevel. It cannot handle a sequence of packages or test cases so
	;; everything must be encapsulated in a single package.
	(test-package "Package 1" p1d p1e

		(test-package "Package 2" pd pe

			(gloss "example of some textual information")

			(test-case "Test Case 1" d e
				(warn "Warning for test case 1")
				(expect-zero "Plus" (+ -1 1))
				(expect-positive "Plus" (+ 1 1))
				(expect-negative "Plus" (+ -1 -1))
				(expect-nonzero "Plus" (+ 0 1))))

		(test-package "Package 3" pd pe
			(warn "warning for package 3")
			(test-case "Test Case 2" d e
				(expect-zero "Minus" (- 1 1))
				(expect-positive "Minus" (- 2 1))
				(expect-negative "Minus" (warn "thingy") (- 1 2))
				(expect-nonzero "Minus" (- 0 1))))

		(test-package "Package 4" pd pe
			(test-case "Test Case 3" d e
				(expect-near "tolcheck" 100 0.1 (+ 100 .01))
				(expect-eq "eq check" 1 1)
				(expect-eqv "eqv check" 2 2)
				(expect-equal "equal check" 3 3)))

		(test-package "Package 5" pd pe
			(test-case "Test Case 4" d e
				(warn "Terminating this test case")
				(terminate e "Terminated in test case 4....")))

		(test-package "Package 6" pd pe
			(test-case "Test Case 5" d e
				(expect-zero "literal" 0))))))

;; print out everything and get the return value of the toplevel package.
(let ((res (output-human-simple (testit))))
	(print res))
(print "\nNOTE: the preceding test is expected to fail (TERMINATION and others).")
