from lib.common import *
from basechecker import BaseChecker
from lib.pop3 import *

class POP3Checker(BaseChecker):
	def __init__(self, notifier, account_id, status_cb, username, password, server, port, ssl):
		self.username = username
		self.server = server
		self.port = port
		
		self.notified = []

		self.popbox = PopBox(username, password, server, port, ssl)

		BaseChecker.__init__(self, notifier, account_id, status_cb)
					
	def reset(self):
		self.notified = []
	
	def update_info(self, account):
		username = account["username"]
		password = account["password"]
		ssl = account["ssl"]
		self.server = account["server"]
		self.port = account["port"]
		ssl = False
		if account.has_key("ssl"):
			if account["ssl"] == "1":
				ssl = True
			elif account["ssl"] == "0":
				ssl = False
		del self.popbox
		self.popbox = PopBox(username, password, self.server, self.port, ssl)
	
	def check(self):
		# prevent recalling
		if self.checking: return
		self.start_check()

		mailbox = "%s@%s" % (self.username, self.server)
		
		print "BEGIN checking pop3 account %s@%s ..." % (self.username, self.server)
		try:
			# each mail in mail: [subject, from, msgid]
			mails = self.popbox.get_mails()
		except PopBoxConnectionError:
			err = _("POP3 Error")
			msg = _("Error while connecting to %s on port %s") % (self.server, 
										self.port)
			self.notify_error(err, msg, False)
			self.stop_check()
			return
		except PopBoxAuthError:
			err = _("POP3 Auth Error")
			msg = _("Invalid Username or password for account %s@%s") % (self.username, 
										self.server)
			self.notify_error(err, msg, True)
			self.stop_check()
			return

		count = len(mails)
		returnlist = []

		if count == 0:
			self.stop_check()
			self.notify_msg(mailbox, count, mails)
			print "END checking pop3 account %s@%s ..." % (self.username, self.server)
			return
			#return mailbox, 0, returnlist

		if count < MAX_NOTIFIED_MAILS:
			loop = count
		else:
			loop = MAX_NOTIFIED_MAILS

		tmp = 0
		
		mustnotify = False
		mails.reverse()
		for mail in mails:
			msgid = mail[2]
			if msgid not in self.notified:
				if tmp <= loop:
					try:
						subject = mail[0]
						author = mail[1]
						returnlist.append([author, subject])
					except:
						print "Warning: pop3checker cannot display the message"
					tmp += 1
				self.notified.append(msgid)
				mustnotify = True

		if not mustnotify:
			self.notify_msg(mailbox, count, [])
		else:
			self.notify_msg(mailbox, count, returnlist)

		self.stop_check()

		print "END checking pop3 account %s@%s ..." % (self.username, self.server)

