#!
#! @ingroup group_sdk_cmake
#!
#! camitk_init_test is a macro to initialize a group of test (for the same command)
#! It is used to initialize a series of tests for a given target.
#! Usually this is placed in the same CMakeLists.txt as the add_executable() cmake instruction or
#! camitk_application() macro
#!
#! It does few useful things:
#! - check if the application is properly defined
#! - initialize test id (then automatically incremented in camitk_test_declare
#! - initialize test output directory
#!
#! Usage:
#! \code
#! camitk_init_test(applicationname)
#! \endcode
#!
#! \param applicationname (required)   The name of the test application (in camitk context, name of the project
#!
#! Example invocation:
#!
#! \code
#!
#! camitk_application()
#!
#! ...
#! # Start the test series for myprogram
#! camitk_init_test(myprogram)
#! camitk_add_test(...) # will be called myprogram_1
#! ...
#! camitk_add_test(...) # myprogram_2
#!
#! \endcode
#
#! @sa camitk_add_test
macro(camitk_init_test)
    parse_arguments(CAMITK_INIT_TEST
        ""  # possible lists
        ""
        ${ARGN}
    )

    set(CAMITK_TEST_ID "0")
    set(CAMITK_TEST_LIST "")

    # check for executable
    if(NOT CAMITK_INIT_TEST_DEFAULT_ARGS)
        message(FATAL_ERROR "Initializing test ${CAMITK_TEST_BASENAME} cannot proceed: please specify the target in brackets")
    else()
        if(NOT TARGET ${CAMITK_INIT_TEST_DEFAULT_ARGS})
            message(FATAL_ERROR "Initializing test ${CAMITK_TEST_BASENAME} cannot proceed: ${CAMITK_INIT_TEST_DEFAULT_ARGS} is not a proper target")
        endif()
        get_target_property( APP_NAME ${CAMITK_INIT_TEST_DEFAULT_ARGS} OUTPUT_NAME )
        set( APP_SUFFIX "" )
        if(MSVC)
            get_target_property( APP_SUFFIX ${CAMITK_INIT_TEST_DEFAULT_ARGS} DEBUG_POSTFIX )
        endif()
#         message( STATUS "CAMITK_INIT_TEST_DEFAULT_ARGS " ${CAMITK_INIT_TEST_DEFAULT_ARGS} "APP_SUFFIX "  ${APP_SUFFIX} "APP_NAME "  ${APP_NAME})        
    endif()
    set(CAMITK_TEST_BASENAME ${CAMITK_INIT_TEST_DEFAULT_ARGS})
#     message(STATUS "Initializing test series for ${CAMITK_TEST_BASENAME}")
    set( CAMITK_INIT_TEST_EXECUTABLE ${CAMITK_BUILD_BIN_DIR}/${APP_NAME}${APP_SUFFIX} ) #Here, it is not the application name we give but the name of the binary to be executed.
endmacro()
