#
# dicts.py
#

# from pygtk/pygtk.h
GTK_TYPE = { 'type':"PyGtk_Type",
             'obj':"PyGtk_Object*",
	     'new':"PyGtk_New",
	     'get':"PyGtk_Get" }

ACCEL_TYPE = { 'type' : 'PyGtkAccelGroup_Type',
               'obj' : 'PyObject*',
               'new' : 'PyGtkAccelGroup_New',
	       'get' : 'PyGtkAccelGroup_Get' }
	      
# from pygtk/pygtkpixbuf.h
PIXBUF_TYPE = { 'type' : 'PyGdkPixbuf_Type',
                'obj' : 'PyGdkPixbuf_Object*',
                'new' : 'PyGdkPixbuf_New',
                'get' : 'PyGdkPixbuf_Get' }

# from pybonobo/pybonob.h
UINODE_TYPE = { 'type' : 'PyBonoboUINode_Type',
                'obj' : 'PyBonoboUINode*',
                'new' : 'PyBonoboUINode_New',
	        'get' : 'PyBonoboUINode_Get' }

# from orbit-python/orbit-python.h
CORBA_TYPE = { 'obj' : 'PyORBit_Object*', 
               'new' : 'PyORBit_Object_New',
               'get' : 'PyORBit_Object_Get' }
	      
CORBA_ORB_TYPE = { 'type' : 'PyORBit_ORB_Type',
                   'obj' : 'PyORBit_ORB*',
                   'new' : 'PyORBit_ORB_New',
		   'get' : 'PyORBit_ORB_Get' }
		   
CORBA_ANY_TYPE = { 'obj' :'PyORBit_Any*', 
                   'new' : 'PyORBit_Any_New',
                   'get' : 'PyORBit_Any_Get', 
		   'type' : 'PyORBit_Any_Type' }
		   
CORBA_TC_TYPE = { 'obj' : 'PyORBit_TypeCode*', 
                  'new' : 'PyORBit_TypeCode_New',
                  'type' : 'PyORBit_TypeCode_Type',
		  'get' : 'PyORBit_TypeCode_Get' }
		  
CORBA_POA_TYPE = { 'type' : 'PyORBit_POA_Type', 
                   'obj' : 'PyORBit_POA*',
                   'new' : 'PyORBit_POA_New', 
		   'get' : 'PyORBit_POA_Get' }
		  
CORBA_POAMANAGER_TYPE = { 'type' : 'PyORBit_POAManager_Type',
                          'obj' : 'PyORBit_POAManager*',
                          'new' : 'PyORBit_POAManager_New',
                          'get' : 'PyORBit_POAManager_Get' }

# Implented in bonbomodule.c			  
GLIST_TYPE = { 'obj' : 'PyObject*',
               'get' : 'PySequence_ToGList',
               'new' : 'GList_ToPyList' }
# Type
type_dict = {
   "BonoboArgType"                    : CORBA_TC_TYPE,   
   "BonoboCanvasItem*"                : GTK_TYPE,
   "BonoboControl*"                   : GTK_TYPE,
   "BonoboControlFrame*"              : GTK_TYPE,
   "BonoboDesktopWindow*"             : GTK_TYPE,
   "BonoboEmbeddable*"                : GTK_TYPE,
   "BonoboEventSource*"               : GTK_TYPE,
   "BonoboGenericFactory*"            : GTK_TYPE,
   "BonoboMoniker*"                   : GTK_TYPE,
   "BonoboMonikerSimple*"             : GTK_TYPE,
   "BonoboObject*"                    : GTK_TYPE,
   "BonoboObjectClient*"              : GTK_TYPE,
   "BonoboPropertyBag*"               : GTK_TYPE,
   "BonoboPropertyClient*"            : GTK_TYPE,
   "BonoboStreamMem*"                 : GTK_TYPE,
   "BonoboUIContainer*"               : GTK_TYPE,
   "BonoboUIComponent*"               : GTK_TYPE,
   "BonoboUIEngine*"                  : GTK_TYPE,
   "BonoboUINode*"                    : UINODE_TYPE,
   "BonoboUISync*"                    : GTK_TYPE,
   "BonoboUIToolbarToggleButtonItem*" : GTK_TYPE, 
   "BonoboWidget*"                    : GTK_TYPE,
   "BonoboWindow*"                    : GTK_TYPE,
   "BonoboZoomable*"                  : GTK_TYPE,
   "CORBA_Object"                     : CORBA_TYPE,
   "CORBA_ORB"                        : CORBA_ORB_TYPE,
   "CORBA_any*"                       : CORBA_ANY_TYPE,
   "CORBA_TypeCode"                   : CORBA_TC_TYPE,
   "GList*"                           : GLIST_TYPE,
   "GdkPixbuf*"                       : PIXBUF_TYPE,
   "GtkAccelGroup*"                   : ACCEL_TYPE,
   "GtkWidget*"                       : GTK_TYPE,
   "GtkWindow*"                       : GTK_TYPE,
   "PortableServer_POA"               : CORBA_POA_TYPE,
   "PortableServer_POAManager"        : CORBA_POAMANAGER_TYPE
}

# Casting
# This could almost be generated by a function.
# BonoboUI* makes some trouble.
cast_dict = {
   "BonoboCanvasComponent*"           : "BONOBO_CANVAS_COMPONENT", 
   "BonoboCanvasItem*"                : "BONOBO_CANVAS_ITEM",
   "BonoboClientSite*"                : "BONOBO_CLIENT_SITE",
   "BonoboControl*"                   : "BONOBO_CONTROL",
   "BonoboControlFrame*"              : "BONOBO_CONTROL_FRAME",
   "BonoboDesktopWindow*"             : "BONOBO_DESKTOP_WINDOW",   
   "BonoboEmbeddable*"                : "BONOBO_EMBEDDABLE",
   "BonoboEventSource*"               : "BONOBO_EVENT_SOURCE",
   "BonoboGenericFactory*"            : "BONOBO_GENERIC_FACTORY",
   "BonoboItemContainer*"             : "BONOBO_ITEM_CONTAINER", 
   "BonoboItemHandler*"               : "BONOBO_ITEM_HANDLER",
   "BonoboMoniker*"                   : "BONOBO_MONIKER",
   "BonoboMonikerSimple*"             : "BONOBO_MONIKER_SIMPLE",   
   "BonoboObject*"                    : "BONOBO_OBJECT", 
   "BonoboObjectClient*"              : "BONOBO_OBJECT_CLIENT",
   "BonoboPersistFile*"               : "BONOBO_PERSIST_FILE",
   "BonoboPersistStream*"             : "BONOBO_PERSIST_STREAM",
   "BonoboPlug*"                      : "BONOBO_PLUG",
   "BonoboPropertyBag*"               : "BONOBO_PROPERTY_BAG",
   "BonoboPropertyControl*"           : "BONOBO_PROPERTY_CONTROL",   
   "BonoboPrint*"                     : "BONOBO_PRINT",
   "BonoboPrintClient*"               : "BONOBO_PRINT_CLIENT",   
   "BonoboSelector*"                  : "BONOBO_SELECTOR",
   "BonoboSelectorWidget*"            : "BONOBO_SELECTOR_WIDGET",
   "BonoboSocket*"                    : "BONOBO_SOCKET",
   "BonoboStream*"                    : "BONOBO_STREAM",
   "BonoboStreamMem*"                 : "BONOBO_STREAM_MEM",
   "BonoboStorage*"                   : "BONOBO_STORAGE",
   "BonoboTransient*"                 : "BONOBO_TRANSIENT",
   "BonoboUIComponent*"               : "BONOBO_UI_COMPONENT",
   "BonoboUIConfigWidget*"            : "BONOBO_UI_CONFIG_WIDGET",   
   "BonoboUIContainer*"               : "BONOBO_UI_CONTAINER",
   "BonoboUIEngine*"                  : "BONOBO_UI_ENGINE",
   "BonoboUISync*"                    : "BONOBO_UI_SYNC", 
   "BonoboUIToolbarButtonItem*"       : "BONOBO_UI_TOOLBAR_BUTTON_ITEM",
   "BonoboUIToolbarIcon*"             : "BONOBO_UI_TOOLBAR_ICON",
   "BonoboUIToolbarItem*"             : "BONOBO_UI_TOOLBAR_ITEM",
   "BonoboUIToolbarToggleButtonItem*" : "BONOBO_UI_TOOLBAR_TOGGLE_BUTTON_ITEM",
   "BonoboView*"                      : "BONOBO_VIEW",
   "BonoboViewFrame*"                 : "BONOBO_VIEW_FRAME", 
   "BonoboWidget*"                    : "BONOBO_WIDGET", 
   "BonoboWindow*"                    : "BONOBO_WINDOW",
   "BonoboWrapper*"                   : "BONOBO_WRAPPER",
   "BonoboZoomable*"                  : "BONOBO_ZOOMABLE",
   "BonoboZoomableFrame*"             : "BONOBO_ZOOMABLE_FRAME",   
   "GnomeCanvasItem*"                 : "GNOME_CANVAS_ITEM",
   "GtkWidget*"                       : "GTK_WIDGET",
   "GtkWindow*"                       : "GTK_WINDOW"
}

# Variable conv dict
convert_dict = {
   "const-char*"                  : "const gchar*",
   "const-char**"                 : "const gchar*",   
   "const-gchar*"                 : "const gchar*",   
   "const-gchar**"                : "const gchar**",
   "const-CORBA_char*"            : "const gchar*",
   "const-BonoboArg*"             : "const BonoboArg*",
   "const-GtkArg*"                : "const GtkArg*",
   "const-BonoboAsyncMethod*"     : "const BonoboAsyncMethod*",
   "const-Bonobo_ResolveOptions*" : "const Bonobo_ResolveOptions*",
   "const-Bonobo_Stream"          : "const Bonobo_Stream",
   "const-size_t"                 : "const size_t",
   "const-gboolean"               : "const gboolean",
   "const-CORBA_any*"             : "CORBA_any*"
}

BOOLEAN_TYPES = ['gboolean']
INT_TYPES = ['int', 'gint', 'guint', 'guint32',
             'BonoboUIToolbarItemStyle',
             'BonoboUIError', "GtkOrientation",
             "BonoboUIToolbarIconDrawMode",
             "BonoboPropertyFlags",
             "GnomeIOStatus", "GtkType", 'GdkModifierType']
STRING_TYPES = ["CORBA_char*", "gchar*", "char*", 'const gchar*',
	        "Bonobo_Control_windowId"]
LONG_TYPES = ["long", "size_t", "glong", "long long",
              "CORBA_long", "Bonobo_EventSource_ListenerId"]
FLOAT_TYPES = ['float', 'gfloat']
DOUBLE_TYPES = ['double', 'gdouble']
GLIST_TYPES = ['GList*']
ANY_TYPES = ['CORBA_any*']
ORB_TYPES = ['CORBA_ORB']
TYPECODE_TYPES = ["CORBA_TypeCode", "BonoboArgType"]
NONE_TYPES = ['CORBA_Environment*']

format_dict = {}
types_list = BOOLEAN_TYPES + INT_TYPES + STRING_TYPES + LONG_TYPES + \
             FLOAT_TYPES + DOUBLE_TYPES + GLIST_TYPES + ORB_TYPES + \
             TYPECODE_TYPES + NONE_TYPES
for type in types_list:
    if type in BOOLEAN_TYPES:
        format_dict[type] = 'b'
    elif type in INT_TYPES:
        format_dict[type] = 'i'
    elif type in STRING_TYPES:
        format_dict[type] = 's'
    elif type in LONG_TYPES:
        format_dict[type] = 'l'
    elif type in FLOAT_TYPES:
        format_dict[type] = 'f'
    elif type in DOUBLE_TYPES:
        format_dict[type] = 'd'
    elif type in GLIST_TYPES:
        format_dict[type] = 'O'
    elif type in ORB_TYPES + TYPECODE_TYPES + ANY_TYPES:
        format_dict[type] = '!O'
    elif type in NONE_TYPES:
        format_dict[type] = ''
format_dict['CORBA_Object'] = 'O'

if __name__ == '__main__':
    print "Do NOT run this from the commandline!"
    raise SystemExit

