/*=====================================================================*/
/*    serrano/prgm/project/bigloo/runtime/Include/bigloo_gc.h          */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Tue Oct 12 08:22:13 2004                          */
/*    Last change :  Thu May 12 09:07:28 2005 (serrano)                */
/*    Copyright   :  2004-05 Manuel Serrano                            */
/*    -------------------------------------------------------------    */
/*    The Bigloo garbage collector configuration                       */
/*=====================================================================*/
#ifndef BIGLOO_GC_H 
#define BIGLOO_GC_H

/*---------------------------------------------------------------------*/
/*    The BGL_HEAP_DEBUG requires the GC backpointers allocation       */
/*---------------------------------------------------------------------*/
#if(defined( BGL_HEAP_DEBUG ) )
    --> error "BGL_HEAP_DEBUG Deprecated. Should not be defined any longer!"
#endif
   
#define BGL_HEAP_DEBUG_MARK_OBJ( x ) x
#define BGL_HEAP_DEBUG_MARK_STR( x ) x

/*---------------------------------------------------------------------*/
/*    Allocation procedures                                            */
/*---------------------------------------------------------------------*/
#if( BGL_GC == BGL_BOEHM_GC )
#  if( !defined( GC_PRIVATE_H ) )
     BGL_RUNTIME_DECL obj_t GC_malloc( size_t );
     BGL_RUNTIME_DECL obj_t GC_realloc( obj_t, size_t );
     BGL_RUNTIME_DECL void GC_free( obj_t );
     extern obj_t GC_malloc_atomic( size_t );
     extern obj_t GC_local_malloc( size_t );
     extern obj_t GC_local_malloc_atomic();
     extern obj_t GC_debug_malloc( size_t, char *, long );
     extern obj_t GC_debug_malloc_atomic( size_t, char *, long );
     extern int GC_gc_no;
     extern int GC_size( void * );
     extern void GC_init();
     extern void GC_expand_hp( size_t );
     extern void GC_register_displacement( int );
     extern void GC_debug_register_displacement( int );
#    if( defined( PROFILE ) )
       extern void GC_profile_start();
#    endif
#  endif
#  undef GC_MALLOC
#  undef GC_MALLOC_ATOMIC
#  undef GC_THREAD_MALLOC
#  undef GC_THREAD_MALLOC_ATOMIC
#  undef GC_REALLOC
#  undef GC_FREE
#  define GC_MALLOC( sz_ ) (obj_t)GC_malloc( sz_ )
#  define GC_MALLOC_ATOMIC( sz_ ) (obj_t)GC_malloc_atomic( sz_ )
#  define GC_THREAD_MALLOC( sz_ ) (obj_t)GC_local_malloc( sz_ )
#  define GC_THREAD_MALLOC_ATOMIC( sz_ ) (obj_t)GC_local_malloc_atomic( sz_ )
#  define GC_REALLOC GC_realloc
#  define GC_FREE GC_free
#  define GC_COLLECT() GC_gcollect()

#  if( !defined( GC_REGISTER_DISPLACEMENT ) )
#    define GC_REGISTER_DISPLACEMENT( o ) GC_register_displacement( o )
#  endif
#  if( defined( TAG_STRUCT ) && ( TAG_STRUCT != 0) )
#    define STRUCT_DISPLACEMENT() GC_REGISTER_DISPLACEMENT( TAG_STRUCT ) 
#  else
#    define STRUCT_DISPLACEMENT() 0
#  endif
#  if( defined( TAG_PAIR ) && ( TAG_PAIR != 0) )
#    define PAIR_DISPLACEMENT() GC_REGISTER_DISPLACEMENT( TAG_PAIR ) 
#  else
#    define PAIR_DISPLACEMENT() 0
#  endif
#  if( defined( TAG_VECTOR ) && ( TAG_VECTOR != 0) )
#    define VECTOR_DISPLACEMENT() GC_REGISTER_DISPLACEMENT( TAG_VECTOR ) 
#  else
#    define VECTOR_DISPLACEMENT() 0
#  endif
#  if( defined( TAG_CELL ) && ( TAG_CELL != 0) )
#    define CELL_DISPLACEMENT() GC_REGISTER_DISPLACEMENT( TAG_CELL ) 
#  else
#    define CELL_DISPLACEMENT() 0
#  endif
#  if( defined( TAG_STRUCTURE ) && ( TAG_STRUCTURE != 0) )
#    define STRUCTURE_DISPLACEMENT() GC_REGISTER_DISPLACEMENT( TAG_STRUCTURE ) 
#   else
#    define STRUCTURE_DISPLACEMENT() 0
#  endif
#  if( defined( TAG_STRING ) && ( TAG_STRING != 0) )
#    define STRING_DISPLACEMENT() GC_REGISTER_DISPLACEMENT( TAG_STRING ) 
#  else
#    define STRING_DISPLACEMENT() 0
#  endif
#  if( defined( TAG_REAL ) && ( TAG_REAL != 0) )
#    define REAL_DISPLACEMENT() GC_REGISTER_DISPLACEMENT( TAG_REAL ) 
#  else
#    define REAL_DISPLACEMENT() 0
#  endif

#  define INIT_ALLOCATION( size ) \
     ( GC_init(), \
       GC_expand_hp( size ), \
       STRUCT_DISPLACEMENT(), \
       PAIR_DISPLACEMENT(), \
       VECTOR_DISPLACEMENT(), \
       CELL_DISPLACEMENT(), \
       STRUCTURE_DISPLACEMENT(), \
       STRING_DISPLACEMENT(), \
       REAL_DISPLACEMENT(), \
       1 )
#  define FREE_ALLOCATION()
#else
#  if( THE_GC == NO_GC )
#    undef GC_MALLOC
#    define GC_MALLOC( size ) heap_alloc( size )
#    undef GC_MALLOC_ATOMIC
#    define GC_MALLOC_ATOMIC( size ) GC_MALLOC( size )
#    define INIT_ALLOCATION( size ) init_heap( size )
#    define FREE_ALLOCATION() free_heap()
#    define GC_COLLECT() 
#  else
     --> error "Unknown garbage collector type"
#  endif                
#endif          

#if( !defined( GC_THREAD_MALLOC ) )
#  define GC_THREAD_MALLOC GC_MALLOC
#  define GC_THREAD_MALLOC_ATOMIC GC_MALLOC_ATOMIC
#endif

#endif
