;*=====================================================================*/
;*    serrano/prgm/project/bigloo/runtime/Ieee/flonum.scm              */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Thu Nov 26 14:04:03 1992                          */
;*    Last change :  Tue Oct 18 15:25:04 2005 (serrano)                */
;*    -------------------------------------------------------------    */
;*    6.5. Numbers (page 18, r4) The `flonum' functions                */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module __r4_numbers_6_5_flonum
   
   (import  __error)
   
   (use     __type
	    __bigloo
	    __tvector
	    __r4_booleans_6_1
	    __r4_vectors_6_8
	    __r4_strings_6_7
	    __r4_characters_6_6
	    __r4_pairs_and_lists_6_3
	    __r4_symbols_6_4
	    __r4_numbers_6_5_fixnum
	    
	    __evenv)
   
   (extern  (macro c-flonum?::bool (::obj) "REALP")
	    (infix macro c-=fl::bool (::double ::double) "==")
	    (infix macro c-<fl::bool (::double ::double) "<")
	    (infix macro c-<=fl::bool (::double ::double) "<=")
	    (infix macro c->fl::bool (::double ::double) ">")
	    (infix macro c->=fl::bool (::double ::double) ">=")
	    (infix macro c-+fl::double (::double ::double) "+")
	    (infix macro c--fl::double (::double ::double) "-")
	    (infix macro c-*fl::double (::double ::double) "*")
	    (infix macro c-/fl::double (::double ::double) "/")
	    (macro c-negfl::double (::double) "NEG")
	    (macro c-floor::double (::double) "floor")
	    (macro c-ceiling::double (::double) "ceil")
	    (macro c-fmod::double (::double ::double) "fmod")
	    (macro c-exp::double (::double) "exp")
	    (macro c-log::double (::double) "log")
	    (macro c-sin::double (::double) "sin")
	    (macro c-cos::double (::double) "cos")
	    (macro c-tan::double (::double) "tan")
	    (macro c-asin::double (::double) "asin")
	    (macro c-acos::double (::double) "acos")
	    (macro c-atan::double (::double) "atan")
	    (macro c-atan2::double (::double ::double) "atan2")
	    (macro c-sqrt::double (::double) "sqrt")
	    (macro c-pow::double (::double ::double) "pow")
	    (macro strtod::double (::string ::long) "strtod")
	    (c-real->string::bstring (::double) "real_to_string")
	    (%ieee-string->double::double (::bstring)
					  "bgl_ieee_string_to_double")
	    (%double->ieee-string::bstring (::double)
					   "bgl_double_to_ieee_string"))
   
   (java    (class foreign
	       (method static c-flonum?::bool (::obj)
		       "REALP")
	       (method static c-=fl::bool (::double ::double)
		       "EQ_FL")
	       (method static c-<fl::bool (::double ::double)
		       "LT_FL")
	       (method static c-<=fl::bool (::double ::double)
		       "LE_FL")
	       (method static c->fl::bool (::double ::double)
		       "GT_FL")
	       (method static c->=fl::bool (::double ::double)
		       "GE_FL")
	       (method static c-+fl::double (::double ::double)
		       "PLUS_FL")
	       (method static c--fl::double (::double ::double)
		       "MINUS_FL")
	       (method static c-*fl::double (::double ::double)
		       "MUL_FL")
	       (method static c-/fl::double (::double ::double)
		       "DIV_FL")
	       (method static c-negfl::double (::double)
		       "NEG_FL")
	       (method static c-fmod::double (::double ::double)
		       "fmod")
	       (method static c-floor::double (::double)
		       "floor")
	       (method static c-ceiling::double (::double)
		       "ceil")
	       (method static c-exp::double (::double)
		       "exp")
	       (method static c-log::double (::double)
		       "log")
	       (method static c-sin::double (::double)
		       "sin")
	       (method static c-cos::double (::double)
		       "cos")
	       (method static c-tan::double (::double)
		       "tan")
	       (method static c-asin::double (::double)
		       "asin")
	       (method static c-acos::double (::double)
		       "acos")
	       (method static c-atan::double (::double)
		       "atan")
	       (method static c-atan2::double (::double ::double)
		       "atan2")
	       (method static c-sqrt::double (::double)
		       "sqrt")
	       (method static c-pow::double (::double ::double)
		       "pow")
	       (method static strtod::double (::string ::long)
		       "strtod")
	       (method static c-real->string::bstring (::double)
		       "real_to_string")
	       (method static %ieee-string->double::double (::bstring)
		       "bgl_ieee_string_to_double")
	       (method static %double->ieee-string::bstring (::double)
		       "bgl_double_to_ieee_string")))
   
   (export  (inline real?::bool ::obj)
	    (inline flonum?::bool ::obj)
	    (inline =fl::bool ::double ::double)
	    (inline >fl::bool ::double ::double)
	    (inline >=fl::bool ::double ::double)
	    (inline <fl::bool ::double ::double)
	    (inline <=fl::bool ::double ::double)
	    (inline zerofl?::bool ::double)
	    (inline positivefl?::bool ::double)
	    (inline negativefl?::bool ::double)
	    (maxfl::double ::double . rn)
	    (minfl::double ::double . rn)
	    (inline max-2fl::double ::double ::double)
	    (inline min-2fl::double ::double ::double)
	    (inline +fl::double ::double ::double)
	    (inline -fl::double ::double ::double)
	    (inline *fl::double ::double ::double)
	    (inline /fl::double ::double ::double)
	    (inline negfl::double ::double)
	    (inline absfl::double ::double)
	    (inline floorfl::double ::double)
	    (inline ceilingfl::double ::double)
	    (inline truncatefl::double ::double)
	    (roundfl::double ::double)
	    (inline remainderfl::double ::double ::double)
	    (inline expfl::double ::double)
	    (inline logfl::double ::double)
	    (inline sinfl::double ::double)
	    (inline cosfl::double ::double)
	    (inline tanfl::double ::double)
	    (inline asinfl::double ::double)
	    (inline acosfl::double ::double)
	    (atanfl::double ::double . y)
	    (inline atan-1fl::double ::double)
	    (inline atan-2fl::double ::double ::double)
	    (inline atan-2fl-ur::double ::double ::double)
	    (inline sqrtfl::double ::double)
	    (inline sqrtfl-ur::double ::double)
	    (inline exptfl::double ::double ::double)
	    (inline string->real::double ::string)
	    (inline real->string::bstring ::real)
	    (inline ieee-string->real::real ::bstring)
	    (inline real->ieee-string::bstring ::real)
	    (inline ieee-string->double::double ::bstring)
	    (inline double->ieee-string::bstring ::double)
	    (inline ieee-string->float::float ::bstring)
	    (inline float->ieee-string::bstring ::float))
   
   (pragma  (c-flonum? side-effect-free (predicate-of real) no-cfa-top nesting)
	    (real? side-effect-free no-cfa-top nesting)
	    (c-=fl side-effect-free no-cfa-top nesting args-safe)
	    (c->fl side-effect-free no-cfa-top nesting args-safe)
	    (c->=fl side-effect-free no-cfa-top nesting args-safe)
	    (c-<fl side-effect-free no-cfa-top nesting args-safe)
	    (c-<=fl side-effect-free no-cfa-top nesting args-safe)
	    (c-+fl side-effect-free no-cfa-top nesting args-safe)
	    (c--fl side-effect-free no-cfa-top nesting args-safe)
	    (c-*fl side-effect-free no-cfa-top nesting args-safe)
	    (c-/fl side-effect-free no-cfa-top nesting args-safe)
	    (c-negfl side-effect-free no-cfa-top nesting args-safe)
	    (c-exp side-effect-free no-cfa-top nesting args-safe)
	    (c-log side-effect-free no-cfa-top nesting args-safe)
	    (c-sin side-effect-free no-cfa-top nesting args-safe)
	    (c-cos side-effect-free no-cfa-top nesting args-safe)
	    (c-tan side-effect-free no-cfa-top nesting args-safe)
	    (c-asin side-effect-free no-cfa-top nesting args-safe)
	    (c-acos side-effect-free no-cfa-top nesting args-safe)
	    (c-atan side-effect-free no-cfa-top nesting args-safe)
	    (c-sqrt side-effect-free no-cfa-top nesting args-safe)
	    (flonum? (predicate-of real) no-cfa-top nesting)
	    (real? side-effect-free no-cfa-top nesting)
	    (=fl side-effect-free no-cfa-top nesting)
	    (>fl side-effect-free no-cfa-top nesting)
	    (>=fl side-effect-free no-cfa-top nesting)
	    (<fl side-effect-free no-cfa-top nesting)
	    (<=fl side-effect-free no-cfa-top nesting)
	    (+fl side-effect-free no-cfa-top nesting)
	    (-fl side-effect-free no-cfa-top nesting)
	    (*fl side-effect-free no-cfa-top nesting)
	    (/fl side-effect-free no-cfa-top nesting)
	    (negfl side-effect-free no-cfa-top nesting)
	    (expfl side-effect-free no-cfa-top nesting)
	    (logfl side-effect-free no-cfa-top nesting)
	    (sinfl side-effect-free no-cfa-top nesting)
	    (cosfl side-effect-free no-cfa-top nesting)
	    (tanfl side-effect-free no-cfa-top nesting)
	    (asinfl side-effect-free no-cfa-top nesting)
	    (acosfl side-effect-free no-cfa-top nesting)
	    (atanfl side-effect-free no-cfa-top nesting)
	    (sqrtfl side-effect-free no-cfa-top nesting)))

;*---------------------------------------------------------------------*/
;*    real? ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (real? obj)
   (if (c-fixnum? obj)
       #t
       (c-flonum? obj)))

;*---------------------------------------------------------------------*/
;*    flonum? ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (flonum? obj)
   (c-flonum? obj))

;*---------------------------------------------------------------------*/
;*    =fl ...                                                          */
;*---------------------------------------------------------------------*/
(define-inline (=fl r1 r2)
   (c-=fl r1 r2))

;*---------------------------------------------------------------------*/
;*    <fl ...                                                          */
;*---------------------------------------------------------------------*/
(define-inline (<fl r1 r2)
   (c-<fl r1 r2))

;*---------------------------------------------------------------------*/
;*    >fl ...                                                          */
;*---------------------------------------------------------------------*/
(define-inline (>fl r1 r2)
   (c->fl r1 r2))

;*---------------------------------------------------------------------*/
;*    <=fl ...                                                         */
;*---------------------------------------------------------------------*/
(define-inline (<=fl r1 r2)
   (c-<=fl r1 r2))

;*---------------------------------------------------------------------*/
;*    >=fl ...                                                         */
;*---------------------------------------------------------------------*/
(define-inline (>=fl r1 r2)
   (c->=fl r1 r2))

;*---------------------------------------------------------------------*/
;*    zerofl? ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (zerofl? r)
   (=fl r 0.0))

;*---------------------------------------------------------------------*/
;*    positivefl? ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline (positivefl? r)
   (>fl r 0.0))

;*---------------------------------------------------------------------*/
;*    negativefl? ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline (negativefl? r)
   (<fl r 0.0))

;*---------------------------------------------------------------------*/
;*    +fl ...                                                          */
;*---------------------------------------------------------------------*/
(define-inline (+fl r1 r2)
   (c-+fl r1 r2))
	    
;*---------------------------------------------------------------------*/
;*    -fl ...                                                          */
;*---------------------------------------------------------------------*/
(define-inline (-fl r1 r2)
   (c--fl r1 r2))

;*---------------------------------------------------------------------*/
;*    *fl ...                                                          */
;*---------------------------------------------------------------------*/
(define-inline (*fl r1 r2)
   (c-*fl r1 r2))

;*---------------------------------------------------------------------*/
;*    /fl ...                                                          */
;*---------------------------------------------------------------------*/
(define-inline (/fl r1 r2)
   (c-/fl r1 r2))

;*---------------------------------------------------------------------*/
;*    negfl ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (negfl r1)
   (c-negfl r1))
    
;*---------------------------------------------------------------------*/
;*    maxfl ...                                                        */
;*---------------------------------------------------------------------*/
(define (maxfl r1 . rn)
   (let loop ((max r1)
	      (rn  rn))
      (if (null? rn)
	  max
	  (if (>fl (car rn) max)
	      (loop (car rn) (cdr rn))
	      (loop max (cdr rn))))))

;*---------------------------------------------------------------------*/
;*    max-2fl ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (max-2fl r1 r2)
   (if (>fl r1 r2)
       r1
       r2))

;*---------------------------------------------------------------------*/
;*    min-2fl ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (min-2fl r1 r2)
   (if (>fl r1 r2)
       r2
       r1))
   
;*---------------------------------------------------------------------*/
;*    minfl ...                                                        */
;*---------------------------------------------------------------------*/
(define (minfl r1 . rn)
   (let loop ((min r1)
	      (rn  rn))
      (if (null? rn)
	  min
	  (if (<fl (car rn) min)
	      (loop (car rn) (cdr rn))
	      (loop min (cdr rn))))))
   
;*---------------------------------------------------------------------*/
;*    absfl ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (absfl r)
   (if (<fl r 0.0)
       (negfl r)
       r))

;*---------------------------------------------------------------------*/
;*    floorfl ...                                                      */
;*---------------------------------------------------------------------*/
(define-inline (floorfl r)
   (c-floor r))

;*---------------------------------------------------------------------*/
;*    ceilingfl ...                                                    */
;*---------------------------------------------------------------------*/
(define-inline (ceilingfl r)
   (c-ceiling r))

;*---------------------------------------------------------------------*/
;*    truncatefl ...                                                   */
;*---------------------------------------------------------------------*/
(define-inline (truncatefl r)
   (if (negativefl? r)
       (ceilingfl r)
       (floorfl r)))

;*---------------------------------------------------------------------*/
;*    roundfl ...                                                      */
;*---------------------------------------------------------------------*/
(define (roundfl r)
   (let* ((int (floorfl r))
          (frac (-fl r int)))
      (cond ((<fl frac 0.5) int)
            ((>fl frac 0.5) (+fl int 1.0))
            (else (*fl 2.0 (ceilingfl (/fl int 2.0)))))))

;*---------------------------------------------------------------------*/
;*    remainderfl ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline (remainderfl n1 n2)
   (c-fmod n1 n2))

;*---------------------------------------------------------------------*/
;*    expfl ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (expfl x)
   (c-exp x))

;*---------------------------------------------------------------------*/
;*    logfl ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (logfl x)
   (c-log x))
 
;*---------------------------------------------------------------------*/
;*    sinfl ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (sinfl x)
   (c-sin x))

;*---------------------------------------------------------------------*/
;*    cosfl ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (cosfl x)
   (c-cos x))

;*---------------------------------------------------------------------*/
;*    tanfl ...                                                        */
;*---------------------------------------------------------------------*/
(define-inline (tanfl x)
   (c-tan x))

;*---------------------------------------------------------------------*/
;*    asinfl ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (asinfl x)
   (c-asin x))

;*---------------------------------------------------------------------*/
;*    acosfl ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (acosfl x)
   (c-acos x))

;*---------------------------------------------------------------------*/
;*    atanfl ...                                                       */
;*---------------------------------------------------------------------*/
(define (atanfl x . y)
   (if (null? y)
       (c-atan x)
       (let ((y (car y)))
	  (atan-2fl x y))))

;*---------------------------------------------------------------------*/
;*    atan-1fl ...                                                     */
;*---------------------------------------------------------------------*/
(define-inline (atan-1fl x)
   (c-atan x))

;*---------------------------------------------------------------------*/
;*    atan-2fl ...                                                     */
;*---------------------------------------------------------------------*/
(define-inline (atan-2fl x y)
   (let ((t (if (=fl x 0.0)
		(=fl y 0.0)
		#f)))
      (if t
	  (let ((proc::obj (string->bstring "atanfl"))
		(msg::obj (string->bstring "Domain error"))
		(obj::obj (double->real 0.0)))
	     ;; !!! Warning
	     ;; the_failure is prefered to Error in order to fix a
	     ;; registers allocation bug in gcc 2.96
	     (the_failure proc msg obj)
	     0.0)
	  (c-atan2 x y))))

;*---------------------------------------------------------------------*/
;*    atan-2fl-ur ...                                                  */
;*---------------------------------------------------------------------*/
(define-inline (atan-2fl-ur x y)
   (c-atan2 x y))

;*---------------------------------------------------------------------*/
;*    sqrtfl ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (sqrtfl r)
   (if (<fl r 0.0)
       (let ((proc::obj (string->bstring "sqrtfl"))
	     (msg::obj (string->bstring "Domain error"))
	     (obj::obj (double->real r)))
	  (begin
	     (error proc msg obj)
	     0.0))
       (c-sqrt r)))

;*---------------------------------------------------------------------*/
;*    sqrtfl-ur ...                                                    */
;*---------------------------------------------------------------------*/
(define-inline (sqrtfl-ur r)
   (c-sqrt r))

;*---------------------------------------------------------------------*/
;*    exptfl ...                                                       */
;*---------------------------------------------------------------------*/
(define-inline (exptfl r1 r2)
   (c-pow r1 r2))

;*---------------------------------------------------------------------*/
;*    string->real ...                                                 */
;*---------------------------------------------------------------------*/
(define-inline (string->real string)
   (strtod string 0))

;*---------------------------------------------------------------------*/
;*    real->string ...                                                 */
;*---------------------------------------------------------------------*/
(define-inline (real->string real)
   (c-real->string real))

;*---------------------------------------------------------------------*/
;*    ieee-string->real ...                                            */
;*---------------------------------------------------------------------*/
(define-inline (ieee-string->real string)
   (%ieee-string->double string))

;*---------------------------------------------------------------------*/
;*    real->ieee-string ...                                            */
;*---------------------------------------------------------------------*/
(define-inline (real->ieee-string real)
   (%double->ieee-string real))

;*---------------------------------------------------------------------*/
;*    ieee-string->double ...                                          */
;*---------------------------------------------------------------------*/
(define-inline (ieee-string->double string)
   (%ieee-string->double string))

;*---------------------------------------------------------------------*/
;*    double->ieee-string ...                                          */
;*---------------------------------------------------------------------*/
(define-inline (double->ieee-string double)
   (%double->ieee-string double))

;*---------------------------------------------------------------------*/
;*    ieee-string->float ...                                           */
;*---------------------------------------------------------------------*/
(define-inline (ieee-string->float string)
   (%ieee-string->double string))

;*---------------------------------------------------------------------*/
;*    float->ieee-string ...                                           */
;*---------------------------------------------------------------------*/
(define-inline (float->ieee-string float)
   (%double->ieee-string float))
