/*=====================================================================*/
/*    serrano/prgm/project/bigloo/runtime/Jlib/stackwriter.java        */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Wed Jan 31 21:00:51 2001                          */
/*    Last change :  Wed Feb 28 12:44:30 2001 (serrano)                */
/*    Copyright   :  2001 Manuel Serrano                               */
/*    -------------------------------------------------------------    */
/*    The PrintWriter to display print stack trace                     */
/*=====================================================================*/

/*---------------------------------------------------------------------*/
/*    The package                                                      */
/*---------------------------------------------------------------------*/
package bigloo;
import java.io.*;

/*---------------------------------------------------------------------*/
/*    stackwriter ...                                                  */
/*---------------------------------------------------------------------*/
public class stackwriter extends PrintWriter {
    OutputStream _out;

    public stackwriter( OutputStream __out, boolean _flush ) {
	super( __out, _flush );
	_out = __out;
    }

    private int next_index( char[] s, int start ) {
	int len = s.length;
	while( start < len ) {
	    if( !Character.isJavaIdentifierPart( s[ start ] ) ) {
		return start;
	    }
	    start++;
	}
	return len;
    }

    private byte[] char_to_byte( char[] src, int start, int len ) {
	int nlen = len - start;
	byte[] res = new byte[ nlen ];

	for( int i = 0; i < nlen; i++ ) {
	    res[ i ] = (byte)src[ start + i ];
	}

	return res;
    }

    private void demangle( byte[] id ) throws IOException {
	if( bigloo.runtime.Llib.bigloo.bigloo_mangledp( id ) ) {
	    byte[] did = (byte[])bigloo.runtime.Llib.bigloo.bigloo_demangle( id );
	    
	    for( int i = 0; i < did.length; i++ ) {
		_out.write( did[ i ] );
	    } 
	} else {
	    for( int i = 0; i < id.length; i++ ) {
		_out.write( id[ i ] );
	    }
	}
    }

    private void print_demangle( char[] s ) {
	int start = 0;
	int len = s.length;
	int next = 0;
	try {
	    while( start < len ) {
		next = next_index( s, start );
		if( next > start ) {
		    demangle( char_to_byte( s, start, next ) );
		}
		if( next < len ) _out.write( s[ next ] );
		start = next + 1;
	    }
	    _out.flush();
	} catch( Exception e ) {
	    e.printStackTrace();
	}
    }

    public void print( char[] s ) {
	print_demangle( s );
    }
}
