/*=====================================================================*/
/*    serrano/prgm/project/bigloo/runtime/Clib/inline-alloc.c          */
/*    -------------------------------------------------------------    */
/*    Author      :  Manuel Serrano                                    */
/*    Creation    :  Wed Sep 21 15:33:10 1994                          */
/*    Last change :  Thu Sep  6 19:46:25 2001 (serrano)                */
/*    -------------------------------------------------------------    */
/*    On fait des fonctions d'allocations specialisees pour les cons   */
/*    et les flottants.                                                */
/*=====================================================================*/
#ifndef GC_PRIVATE_H
#  include <include/private/gc_priv.h>
#endif
#undef abs

#include <bigloo.h>

#if( THE_GC == BOEHM_GC )
#   define NUMBER_OF_CONS_WORDS (long)BYTES_TO_WORDS( PAIR_SIZE )
#   define NUMBER_OF_FLOAT_WORDS BYTES_TO_WORDS( REAL_SIZE )

#ifdef PROFILE
extern long GC_words_allocd_byte;
#endif

/*---------------------------------------------------------------------*/
/*    alloc_make_pair ...                                              */
/*---------------------------------------------------------------------*/
static obj_t 
alloc_make_pair( obj_t car, obj_t cdr )
{
   obj_t pair;

   pair = (obj_t)GC_generic_malloc_words_small( NUMBER_OF_CONS_WORDS, NORMAL );

#if( !defined( TAG_PAIR ) )
   pair->pair_t.header = MAKE_HEADER( PAIR_TYPE, PAIR_SIZE );
#endif
   pair->pair_t.car    = car;
   pair->pair_t.cdr    = cdr;
   
   return BGL_HEAP_DEBUG_MARK_OBJ( BPAIR( pair ) );
}   

/*---------------------------------------------------------------------*/
/*    make_pair ...                                                    */
/*---------------------------------------------------------------------*/
obj_t 
make_pair( obj_t car, obj_t cdr )
{
   obj_t pair;
   ptr_t op;
   ptr_t *opp;
   DCL_LOCK_STATE;
#ifdef PROFILE
   GC_words_allocd_byte += PAIR_SIZE;
#endif
   opp = &(GC_objfreelist[ NUMBER_OF_CONS_WORDS ]);

   FASTLOCK();

   if( !FASTLOCK_SUCCEEDED() || (op = *opp) == 0 )
   {
      FASTUNLOCK();
      return alloc_make_pair( car, cdr );
   }
   else
   {
      *opp = obj_link( op );
      GC_words_allocd += NUMBER_OF_CONS_WORDS;
      FASTUNLOCK();

      pair = (obj_t)op;

#if( !defined( TAG_PAIR ) )
      pair->pair_t.header = MAKE_HEADER( PAIR_TYPE, PAIR_SIZE );
#endif
      pair->pair_t.car    = car;
      pair->pair_t.cdr    = cdr;
   
      return BGL_HEAP_DEBUG_MARK_OBJ( BPAIR( pair ) );
   }
}

/*---------------------------------------------------------------------*/
/*    alloc_make_real ...                                              */
/*---------------------------------------------------------------------*/
static obj_t
alloc_make_real( double d )
{
   obj_t real;

   real = (obj_t)GC_generic_malloc_words_small(NUMBER_OF_FLOAT_WORDS, PTRFREE);
   
#if( !defined( TAG_REAL ) || defined( BUMPY_GC ) )
   real->real_t.header = MAKE_HEADER( REAL_TYPE, REAL_SIZE );
#endif
   real->real_t.real   = d;

   return BGL_HEAP_DEBUG_MARK_OBJ( BREAL( real ) );
}

/*---------------------------------------------------------------------*/
/*    make_real ...                                                    */
/*---------------------------------------------------------------------*/
obj_t
make_real( double d )
{
   obj_t real;
   ptr_t op;
   ptr_t *opp;
   DCL_LOCK_STATE;
   
#ifdef PROFILE
   GC_words_allocd_byte += REAL_SIZE;
#endif
   
   opp =  &(GC_aobjfreelist[ NUMBER_OF_FLOAT_WORDS ]);

   FASTLOCK();

   if( !FASTLOCK_SUCCEEDED() || (op = *opp) == 0 )
   {
      FASTUNLOCK();
      return alloc_make_real( d );
   }
   else
   {
      *opp = obj_link(op);
      GC_words_allocd += NUMBER_OF_FLOAT_WORDS;
      FASTUNLOCK();

      real = (obj_t)op;

#if( !defined( TAG_REAL ) )
      real->real_t.header = MAKE_HEADER( REAL_TYPE, REAL_SIZE );
#endif
      real->real_t.real   = d;

      return BGL_HEAP_DEBUG_MARK_OBJ( BREAL( real ) );
   }
}

#else

/*---------------------------------------------------------------------*/
/*    make_real ...                                                    */
/*---------------------------------------------------------------------*/
obj_t
make_real( double real )
{
   obj_t a_real;

#ifdef PROFILE
   GC_words_allocd_byte += REAL_SIZE;
#endif
   
   a_real = GC_MALLOC_ATOMIC( REAL_SIZE );
	
#if( !defined( TAG_REAL ) )
   a_real->real_t.header = MAKE_HEADER( REAL_TYPE, REAL_SIZE );
#endif
   a_real->real_t.real = real;
	
   return BGL_HEAP_DEBUG_MARK_OBJ( BREAL( a_real ) );
}
#endif

