/* tag.h:
 *
 ****************************************************************
 * Copyright (C) 2003 Tom Lord
 *
 * See the file "COPYING" for further information about
 * the copyright and warranty status of this work.
 */

#ifndef INCLUDE__LIBARCH__TAG_H
#define INCLUDE__LIBARCH__TAG_H


#include "libarch/project-tree.h"

typedef struct tag_method_
{
  struct arch_archive * arch;
  t_uchar * revision;
  t_uchar * changeset;
  t_uchar * reference_tree_root;
  t_uchar * tagged_tree_root;
  int reference_is_tmp;
  t_uchar * cooked_log;
  t_uchar * temp_dir;
  arch_project_tree_t * current_tree;
} tag_method_t;


extern tag_method_t * arch_tag (void * context, 
                      int chatter_fd,
                      struct arch_archive * arch,
                      t_uchar * revision,
                      struct arch_archive * from_arch,
                      t_uchar * from_revision,
                      t_uchar * raw_log);
extern void arch_tag_cacherev (tag_method_t *tag);
#endif  /* INCLUDE__LIBARCH__TAG_H */


/* tag: Tom Lord Sat Jan  5 15:26:10 2002 (tag.h)
 */
