/* local-cache.h:
 *
 ****************************************************************
 * Copyright (C) 2003 Tom Lord
 *
 * See the file "COPYING" for further information about
 * the copyright and warranty status of this work.
 */

#ifndef INCLUDE__LIBARCH__LOCAL_CACHE_H
#define INCLUDE__LIBARCH__LOCAL_CACHE_H


#include "libarch/archive.h"
#include "libarch/patch-id.h"
#include "libarch/project-tree.h"



/* automatically generated __STDC__ prototypes */
extern int arch_greedy_library_wants_revision (arch_patch_id * revision);
extern arch_project_tree_t * arch_find_local_tree_copy (int chatter_fd,
				       arch_project_tree_t * tree,
				       arch_project_tree_t * cache,
                                       t_uchar const * const archive,
                                       t_uchar const * const revision,
                                       t_uchar const * const hook);
extern t_uchar * arch_find_local_copy (int chatter_fd,
				       arch_project_tree_t * tree,
				       arch_project_tree_t * cache,
                                       t_uchar const * const archive,
                                       t_uchar const * const revision,
                                       t_uchar const * const hook);
extern arch_project_tree_t * arch_find_or_make_local_tree_copy (int chatter_fd,
					       arch_project_tree_t * tree,
					       arch_project_tree_t * cache,
                                               struct arch_archive * arch,
                                               t_uchar * archive,
                                               t_uchar * revision);
extern t_uchar * arch_find_or_make_local_copy (int chatter_fd,
					       arch_project_tree_t * tree,
					       arch_project_tree_t * cache,
                                               struct arch_archive * arch,
                                               t_uchar * archive,
                                               t_uchar * revision);
extern t_uchar * arch_find_or_make_tmp_local_copy  (int chatter_fd,
                                                    t_uchar const * const tmp_dir,
						    arch_project_tree_t * tree,
						    arch_project_tree_t * cache,
                                                    struct arch_archive * arch,
                                                    t_uchar const * const archive,
                                                    t_uchar const * const revision);
#endif  /* INCLUDE__LIBARCH__LOCAL_CACHE_H */


/* tag: Tom Lord Sat Jan  5 15:26:10 2002 (local-cache.h)
 */
