/* baz.c
 *
 ****************************************************************
 * Copyright (C) 2003 Tom Lord, Stig Brautaset
 *
 * See the file "COPYING" for further information about
 * the copyright and warranty status of this work.
 */


#define NAME "baz"
#define	PACKAGE	"bazaar"

#include "config-options.h"
#include "po/gettext.h"
#include "hackerlab/bugs/panic.h"
#include "hackerlab/bugs/exception.h"
#include "hackerlab/char/str.h"
#include "hackerlab/char/str.h"
#include "hackerlab/vu/safe.h"
#include "hackerlab/mem/talloc.h"
#include "libarch/debug.h"
#include "commands/cmd.h"
#include "commands/cmds.h"
#include "commands/help.h"
/* This is temporary, the right way is for this to flush on exit
 * rbc 20050129
 */
#ifdef VALGRINDTUNE
#include "hackerlab/rx/dfa-cache.h"
#include "hackerlab/rx/nfa-cache.h"
#endif




static void
setup_msg_env(void)
{
  t_uchar * localedir;
  t_uchar const * statement_with_no_effect_catcher;

  localedir = str_alloc_cat (0, cfg__std__prefix, "/locale");

  setlocale (LC_ALL, "");
  /* statement_with_no_effect_catcher = bindtextdomain (PACKAGE, localedir); */
  statement_with_no_effect_catcher = textdomain (PACKAGE);

  lim_free (0, localedir);
}

int
main (int argc, char * argv[])
{
  struct exception * e;
  int answer = 1;

#ifdef LEAKCHECK
  talloc_enable_leak_report_full ();
#endif

  Try
    {
      int x;
      char * cmd;

      panic_should_throw (1);
      arch_debug_init();

      setup_msg_env();

      if (argc <= 0)
	  panic (NAME " invoked with argc <= 0 ?!?");

      if (argc == 1)
	{
usage_error:
	  safe_printfmt (2, _("usage: baz command ...\n"));
	  safe_printfmt (2, _("  (try 'baz -h')\n"));
	  exit (1);
	}

      cmd = argv[1];

      if (!str_cmp (cmd, "--help"))
	{
	  arch_call_cmd(arch_cmd_help, argv[0], 0);
	}


      if (!str_cmp (cmd, "-h") || !str_cmp (cmd, "-H"))
	{
	  safe_printfmt (1, "invoke baz commands\n");
	  safe_printfmt (1, "usage: " NAME " COMMAND [PARAMS ...]\n");
	  safe_printfmt (1, "\n");
	  safe_printfmt (1, "  -h, --help     Display a help message and exit.\n");
	  safe_printfmt (1, "  -H             Display a verbose help message and exit.\n");
	  safe_printfmt (1, "  -V, --version  Display a release identifier string\n");
	  safe_printfmt (1, "                 and exit.\n");
	  safe_printfmt (1, "\n");
	  safe_printfmt (1, "\n");
	  safe_printfmt (1, "To see a list of available subcommands, run:\n");
	  safe_printfmt (1, "\n");
	  safe_printfmt (1, "    " NAME " help\n");
	  safe_printfmt (1, "\n");
	  exit (0);
	}

      if (!str_cmp (cmd, "-V") || !str_cmp (cmd, "--version"))
	{
	  safe_printfmt (1, NAME " " cfg__std__package "\n");
	  safe_printfmt (1, "from Canonical Ltd. and other members of the arch community\n");

	  safe_printfmt (1, "\n");
	  safe_printfmt (1, "Copyright 2004,2005 Canonical Ltd.\n");
	  safe_printfmt (1, "Copyright 2003 Tom Lord.\n");
	  safe_printfmt (1, "Copyright 2003-2005 Various Contributors\n");
	  safe_printfmt (1, "\n");
	  safe_printfmt (1, "This is free software; see the source for copying conditions.\n");
	  safe_printfmt (1, "There is NO warranty; not even for MERCHANTABILITY or FITNESS FOR A\n");
	  safe_printfmt (1, "PARTICULAR PURPOSE.\n");
	  safe_printfmt (1, "\n");
	  safe_printfmt (1, "Report bugs to " cfg__tla_bug_mail ".\n");
	  safe_printfmt (1, "\n");
	  safe_printfmt (1, "%s", (cfg__std__release_id_string));
	  safe_printfmt (1, "\n");
	  exit (0);
	}

      if (cmd[0] == '-')
	  goto usage_error;

      for (x = 0; arch_commands[x].name; ++x)
	{
	  if (!str_cmp (cmd, arch_commands[x].name) && arch_commands[x].fn)
	    {
	      t_uchar * full_program_name = 0;

	      full_program_name = str_alloc_cat (0, NAME " ", arch_commands[x].name);
	      if (arch_commands[x].alias_of && arch_commands[x].deprecated)
		  debug (dbg_baz, 1, "%s is a deprecated alias for %s. Please use %s\n",
			 arch_commands[x].name, arch_commands[x].alias_of,
			 arch_commands[x].alias_of);

	      answer = arch_commands[x].fn (full_program_name, argc - 1, argv + 1);

	      lim_free (0, full_program_name);

#ifdef VALGRINDTUNE
	      rx_flush_dfa_cache();
	      rx_flush_nfa_cache();
#endif
	      goto done;
	    }
	}

      /* not NAME because that breaks the po process. TODO: extract the name as a separate translation */
      safe_printfmt (2, _("baz: unrecognized command (%s)\n"), cmd);
      safe_printfmt (2, _("  (try ' baz help')\n"));
done:
      /* XXX push this try into a function - it should be anyway */
      answer = answer;
    }
  Catch (e)
    {
      /* disable exception throwing if further errors occur */
      panic_should_throw (0);
      safe_printfmt (2, _("baz: uncaught exception: %d:(%s)\n"), e->code, e->msg);
      safe_printfmt (2, _("  please report this as a bug to bazaar@lists.canonical.com\n"));
      talloc_free (e);
      exit (2);
    }
  exit (answer);
}





/* tag: Tom Lord Tue Jun 10 17:07:03 2003 (tla.c)
 */
