/* awn-terminal.c generated by valac, the Vala compiler
 * generated from awn-terminal.vala, do not modify */

/*
 * Copyright (C) 2009 Michal Hruby <michal.mhr@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301  USA.
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <config.h>
#include <stdlib.h>
#include <string.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>
#include <libawn/libawn.h>
#include <libdesktop-agnostic/config.h>
#include <gtk/gtk.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <vte/vte.h>
#include <glib/gi18n-lib.h>
#include <eggaccelerators.h>
#include <gdk-pixbuf/gdk-pixdata.h>
#include <keybinder.h>
#include <glib/gi18n.h>
#include <dbus/dbus.h>


#define TYPE_TERMINAL_DBUS (terminal_dbus_get_type ())
#define TERMINAL_DBUS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TERMINAL_DBUS, TerminalDBus))
#define IS_TERMINAL_DBUS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TERMINAL_DBUS))
#define TERMINAL_DBUS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_TERMINAL_DBUS, TerminalDBusIface))

typedef struct _TerminalDBus TerminalDBus;
typedef struct _TerminalDBusIface TerminalDBusIface;
typedef struct _TerminalDBusDBusProxy TerminalDBusDBusProxy;
typedef DBusGProxyClass TerminalDBusDBusProxyClass;

#define TYPE_AWN_TERMINAL_APPLET (awn_terminal_applet_get_type ())
#define AWN_TERMINAL_APPLET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AWN_TERMINAL_APPLET, AwnTerminalApplet))
#define AWN_TERMINAL_APPLET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AWN_TERMINAL_APPLET, AwnTerminalAppletClass))
#define IS_AWN_TERMINAL_APPLET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AWN_TERMINAL_APPLET))
#define IS_AWN_TERMINAL_APPLET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AWN_TERMINAL_APPLET))
#define AWN_TERMINAL_APPLET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AWN_TERMINAL_APPLET, AwnTerminalAppletClass))

typedef struct _AwnTerminalApplet AwnTerminalApplet;
typedef struct _AwnTerminalAppletClass AwnTerminalAppletClass;
typedef struct _AwnTerminalAppletPrivate AwnTerminalAppletPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _dbus_g_connection_unref0(var) ((var == NULL) ? NULL : (var = (dbus_g_connection_unref (var), NULL)))
typedef struct _DBusObjectVTable _DBusObjectVTable;

struct _TerminalDBusIface {
	GTypeInterface parent_iface;
	void (*toggle) (TerminalDBus* self, guint32 time_, GError** error);
};

struct _TerminalDBusDBusProxy {
	DBusGProxy parent_instance;
	gboolean disposed;
};

struct _AwnTerminalApplet {
	AwnAppletSimple parent_instance;
	AwnTerminalAppletPrivate * priv;
};

struct _AwnTerminalAppletClass {
	AwnAppletSimpleClass parent_class;
};

struct _AwnTerminalAppletPrivate {
	DesktopAgnosticConfigClient* config;
	GtkMenu* menu;
	AwnDialog* dialog;
	GtkNotebook* notebook;
	GtkFileChooserButton* chooser;
	GtkImage* preview_image;
	GtkWindow* prefs_window;
	GtkListStore* model;
	gint number_of_tabs;
	float _bg_opacity;
	char* _background_image;
	char* _keybinding;
	char* _terminal_command;
	GTimeVal last_inactive_time;
};

struct _DBusObjectVTable {
	void (*register_object) (DBusConnection*, const char*, void*);
};


static gpointer awn_terminal_applet_parent_class = NULL;
static TerminalDBusIface* awn_terminal_applet_terminal_dbus_parent_iface = NULL;

#define not_used APPLETSDIR
GType terminal_dbus_get_type (void);
void terminal_dbus_toggle (TerminalDBus* self, guint32 time_, GError** error);
void terminal_dbus_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _terminal_dbus_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult terminal_dbus_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_terminal_dbus_introspect (TerminalDBus* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_terminal_dbus_property_get_all (TerminalDBus* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_terminal_dbus_toggle (TerminalDBus* self, DBusConnection* connection, DBusMessage* message);
GType terminal_dbus_dbus_proxy_get_type (void);
TerminalDBus* terminal_dbus_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
DBusHandlerResult terminal_dbus_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data);
enum  {
	TERMINAL_DBUS_DBUS_PROXY_DUMMY_PROPERTY
};
static void terminal_dbus_dbus_proxy_toggle (TerminalDBus* self, guint32 time_, GError** error);
static void terminal_dbus_dbus_proxy_terminal_dbus__interface_init (TerminalDBusIface* iface);
static void terminal_dbus_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void terminal_dbus_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType awn_terminal_applet_get_type (void);
#define AWN_TERMINAL_APPLET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_AWN_TERMINAL_APPLET, AwnTerminalAppletPrivate))
enum  {
	AWN_TERMINAL_APPLET_DUMMY_PROPERTY,
	AWN_TERMINAL_APPLET_BG_OPACITY,
	AWN_TERMINAL_APPLET_HIDE_ON_UNFOCUS,
	AWN_TERMINAL_APPLET_BACKGROUND_IMAGE,
	AWN_TERMINAL_APPLET_KEYBINDING,
	AWN_TERMINAL_APPLET_TERMINAL_COMMAND
};
AwnTerminalApplet* awn_terminal_applet_new (const char* canonical_name, const char* uid, gint panel_id);
AwnTerminalApplet* awn_terminal_applet_construct (GType object_type, const char* canonical_name, const char* uid, gint panel_id);
static void awn_terminal_applet_clicked_cb (AwnTerminalApplet* self);
static void _awn_terminal_applet_clicked_cb_awn_icon_clicked (AwnIcon* _sender, gpointer self);
static void awn_terminal_applet_middle_clicked_cb (AwnTerminalApplet* self);
static void _awn_terminal_applet_middle_clicked_cb_awn_icon_middle_clicked (AwnIcon* _sender, gpointer self);
static void awn_terminal_applet_on_context_menu_popup (AwnTerminalApplet* self, GdkEventButton* evt);
static void _awn_terminal_applet_on_context_menu_popup_awn_icon_context_menu_popup (AwnIcon* _sender, GdkEventButton* event, gpointer self);
static void awn_terminal_applet_create_new_tab (AwnTerminalApplet* self);
static void _lambda10_ (GObject* obj, GParamSpec* pspec, AwnTerminalApplet* self);
static void __lambda10__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void awn_terminal_applet_real_constructed (GObject* base);
static void awn_terminal_applet_global_keypress (AwnTerminalApplet* self, const char* keystring);
static void awn_terminal_applet_real_toggle (TerminalDBus* base, guint32 time_, GError** error);
static void awn_terminal_applet_exited_cb (AwnTerminalApplet* self, VteTerminal* terminal);
static gboolean awn_terminal_applet_key_press_cb (AwnTerminalApplet* self, GdkEventKey* event, VteTerminal* terminal);
static void awn_terminal_applet_on_prefs_activate (AwnTerminalApplet* self);
static void _awn_terminal_applet_on_prefs_activate_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static gboolean _lambda0_ (GtkWidget* w, GdkEvent* e, AwnTerminalApplet* self);
static gboolean __lambda0__gtk_widget_delete_event (GtkWidget* _sender, GdkEvent* event, gpointer self);
gboolean awn_terminal_applet_get_hide_on_unfocus (AwnTerminalApplet* self);
void awn_terminal_applet_set_hide_on_unfocus (AwnTerminalApplet* self, gboolean value);
static void _lambda1_ (GtkToggleButton* w, AwnTerminalApplet* self);
static void __lambda1__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
void awn_terminal_applet_set_keybinding (AwnTerminalApplet* self, const char* value);
static void _lambda2_ (GtkCellRendererAccel* a, const char* path, guint accel_key, GdkModifierType accel_mods, guint keycode, AwnTerminalApplet* self);
static void __lambda2__gtk_cell_renderer_accel_accel_edited (GtkCellRendererAccel* _sender, const char* path_string, guint accel_key, GdkModifierType accel_mods, guint hardware_keycode, gpointer self);
static void _lambda3_ (GtkCellRendererAccel* a, const char* path, AwnTerminalApplet* self);
static void __lambda3__gtk_cell_renderer_accel_accel_cleared (GtkCellRendererAccel* _sender, const char* path_string, gpointer self);
const char* awn_terminal_applet_get_background_image (AwnTerminalApplet* self);
void awn_terminal_applet_set_background_image (AwnTerminalApplet* self, const char* value);
static void _lambda4_ (GtkFileChooserButton* w, AwnTerminalApplet* self);
static void __lambda4__gtk_file_chooser_button_file_set (GtkFileChooserButton* _sender, gpointer self);
static void _lambda5_ (GtkFileChooser* w, AwnTerminalApplet* self);
static void __lambda5__gtk_file_chooser_update_preview (GtkFileChooser* _sender, gpointer self);
static void _lambda6_ (GtkButton* b, AwnTerminalApplet* self);
static void __lambda6__gtk_button_clicked (GtkButton* _sender, gpointer self);
void awn_terminal_applet_set_bg_opacity (AwnTerminalApplet* self, float value);
static void _lambda7_ (GtkRange* w, AwnTerminalApplet* self);
static void __lambda7__gtk_range_value_changed (GtkRange* _sender, gpointer self);
const char* awn_terminal_applet_get_terminal_command (AwnTerminalApplet* self);
void awn_terminal_applet_set_terminal_command (AwnTerminalApplet* self, const char* value);
static gboolean _lambda8_ (GtkWidget* w, GdkEventFocus* e, AwnTerminalApplet* self);
static gboolean __lambda8__gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
static void _lambda9_ (GtkButton* w, AwnTerminalApplet* self);
static void __lambda9__gtk_button_clicked (GtkButton* _sender, gpointer self);
float awn_terminal_applet_get_bg_opacity (AwnTerminalApplet* self);
const char* awn_terminal_applet_get_keybinding (AwnTerminalApplet* self);
static void _awn_terminal_applet_global_keypress_awn_keybinder_bindkey_handler (const char* keystring, gpointer self);
static GObject * awn_terminal_applet_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
void awn_terminal_applet_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _awn_terminal_applet_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult awn_terminal_applet_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_awn_terminal_applet_introspect (AwnTerminalApplet* self, DBusConnection* connection, DBusMessage* message);
static void awn_terminal_applet_finalize (GObject* obj);
static void awn_terminal_applet_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void awn_terminal_applet_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static guint _dynamic_request_name0 (DBusGProxy* self, const char* param1, guint param2, GError** error);
AwnApplet* awn_applet_factory_initp (const char* canonical_name, const char* uid, gint panel_id);
static int _vala_strcmp0 (const char * str1, const char * str2);
static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object);
static void _vala_dbus_unregister_object (gpointer connection, GObject* object);

static const DBusObjectPathVTable _terminal_dbus_dbus_path_vtable = {_terminal_dbus_dbus_unregister, terminal_dbus_dbus_message};
static const _DBusObjectVTable _terminal_dbus_dbus_vtable = {terminal_dbus_dbus_register_object};
static const DBusObjectPathVTable _awn_terminal_applet_dbus_path_vtable = {_awn_terminal_applet_dbus_unregister, awn_terminal_applet_dbus_message};
static const _DBusObjectVTable _awn_terminal_applet_dbus_vtable = {awn_terminal_applet_dbus_register_object};


void terminal_dbus_toggle (TerminalDBus* self, guint32 time_, GError** error) {
	TERMINAL_DBUS_GET_INTERFACE (self)->toggle (self, time_, error);
}


void _terminal_dbus_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_terminal_dbus_introspect (TerminalDBus* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.awnproject.Applet.Terminal\">\n  <method name=\"Toggle\">\n    <arg name=\"time_\" type=\"u\" direction=\"in\"/>\n  </method>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_terminal_dbus_property_get_all (TerminalDBus* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter;
	char* interface_name;
	const char* _tmp0_;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp0_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp0_);
	if (strcmp (interface_name, "org.awnproject.Applet.Terminal") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_terminal_dbus_toggle (TerminalDBus* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint32 time_ = 0U;
	dbus_uint32_t _tmp1_;
	DBusMessage* reply;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	dbus_message_iter_get_basic (&iter, &_tmp1_);
	dbus_message_iter_next (&iter);
	time_ = _tmp1_;
	terminal_dbus_toggle (self, time_, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


DBusHandlerResult terminal_dbus_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_terminal_dbus_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		result = _dbus_terminal_dbus_property_get_all (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.awnproject.Applet.Terminal", "Toggle")) {
		result = _dbus_terminal_dbus_toggle (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


void terminal_dbus_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_terminal_dbus_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
}


static void terminal_dbus_base_init (TerminalDBusIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_type_set_qdata (TYPE_TERMINAL_DBUS, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_terminal_dbus_dbus_vtable));
	}
}


GType terminal_dbus_get_type (void) {
	static volatile gsize terminal_dbus_type_id__volatile = 0;
	if (g_once_init_enter (&terminal_dbus_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TerminalDBusIface), (GBaseInitFunc) terminal_dbus_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType terminal_dbus_type_id;
		terminal_dbus_type_id = g_type_register_static (G_TYPE_INTERFACE, "TerminalDBus", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (terminal_dbus_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (terminal_dbus_type_id, g_quark_from_string ("ValaDBusInterfaceProxyType"), &terminal_dbus_dbus_proxy_get_type);
		g_once_init_leave (&terminal_dbus_type_id__volatile, terminal_dbus_type_id);
	}
	return terminal_dbus_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (TerminalDBusDBusProxy, terminal_dbus_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_TERMINAL_DBUS, terminal_dbus_dbus_proxy_terminal_dbus__interface_init) );
TerminalDBus* terminal_dbus_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	TerminalDBus* self;
	self = g_object_new (terminal_dbus_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "org.awnproject.Applet.Terminal", NULL);
	return self;
}


static GObject* terminal_dbus_dbus_proxy_construct (GType gtype, guint n_properties, GObjectConstructParam* properties) {
	GObject* self;
	DBusGConnection *connection;
	char* path;
	char* filter;
	self = G_OBJECT_CLASS (terminal_dbus_dbus_proxy_parent_class)->constructor (gtype, n_properties, properties);
	g_object_get (self, "connection", &connection, NULL);
	g_object_get (self, "path", &path, NULL);
	dbus_connection_add_filter (dbus_g_connection_get_connection (connection), terminal_dbus_dbus_proxy_filter, self, NULL);
	filter = g_strdup_printf ("type='signal',path='%s'", path);
	dbus_bus_add_match (dbus_g_connection_get_connection (connection), filter, NULL);
	dbus_g_connection_unref (connection);
	g_free (path);
	g_free (filter);
	return self;
}


DBusHandlerResult terminal_dbus_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data) {
	if (dbus_message_has_path (message, dbus_g_proxy_get_path (user_data))) {
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}


static void terminal_dbus_dbus_proxy_dispose (GObject* self) {
	DBusGConnection *connection;
	if (((TerminalDBusDBusProxy*) self)->disposed) {
		return;
	}
	((TerminalDBusDBusProxy*) self)->disposed = TRUE;
	g_object_get (self, "connection", &connection, NULL);
	dbus_connection_remove_filter (dbus_g_connection_get_connection (connection), terminal_dbus_dbus_proxy_filter, self);
	G_OBJECT_CLASS (terminal_dbus_dbus_proxy_parent_class)->dispose (self);
}


static void terminal_dbus_dbus_proxy_class_init (TerminalDBusDBusProxyClass* klass) {
	G_OBJECT_CLASS (klass)->constructor = terminal_dbus_dbus_proxy_construct;
	G_OBJECT_CLASS (klass)->dispose = terminal_dbus_dbus_proxy_dispose;
	G_OBJECT_CLASS (klass)->get_property = terminal_dbus_dbus_proxy_get_property;
	G_OBJECT_CLASS (klass)->set_property = terminal_dbus_dbus_proxy_set_property;
}


static void terminal_dbus_dbus_proxy_init (TerminalDBusDBusProxy* self) {
}


static void terminal_dbus_dbus_proxy_toggle (TerminalDBus* self, guint32 time_, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp2_;
	if (((TerminalDBusDBusProxy*) self)->disposed) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "%s", "Connection is closed");
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.awnproject.Applet.Terminal", "Toggle");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp2_ = time_;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp2_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp3_;
			_edomain = DBUS_GERROR;
			_tmp3_ = _dbus_error.name + 27;
			if (strcmp (_tmp3_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp3_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp3_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp3_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp3_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp3_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp3_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp3_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp3_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp3_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp3_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp3_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp3_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp3_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp3_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp3_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp3_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp3_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp3_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp3_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp3_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp3_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp3_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp3_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp3_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp3_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp3_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp3_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp3_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp3_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp3_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp3_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp3_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, "%s", _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return;
	}
	if (strcmp (dbus_message_get_signature (_reply), "")) {
		g_set_error (error, DBUS_GERROR, DBUS_GERROR_INVALID_SIGNATURE, "Invalid signature, expected \"%s\", got \"%s\"", "", dbus_message_get_signature (_reply));
		dbus_message_unref (_reply);
		return;
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static void terminal_dbus_dbus_proxy_terminal_dbus__interface_init (TerminalDBusIface* iface) {
	iface->toggle = terminal_dbus_dbus_proxy_toggle;
}


static void terminal_dbus_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
}


static void terminal_dbus_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
}


AwnTerminalApplet* awn_terminal_applet_construct (GType object_type, const char* canonical_name, const char* uid, gint panel_id) {
	GParameter * __params;
	GParameter * __params_it;
	AwnTerminalApplet * self;
	g_return_val_if_fail (canonical_name != NULL, NULL);
	g_return_val_if_fail (uid != NULL, NULL);
	__params = g_new0 (GParameter, 3);
	__params_it = __params;
	__params_it->name = "canonical-name";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, canonical_name);
	__params_it++;
	__params_it->name = "uid";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, uid);
	__params_it++;
	__params_it->name = "panel-id";
	g_value_init (&__params_it->value, G_TYPE_INT);
	g_value_set_int (&__params_it->value, panel_id);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	g_object_set ((AwnApplet*) self, "display-name", "Terminal", NULL);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


AwnTerminalApplet* awn_terminal_applet_new (const char* canonical_name, const char* uid, gint panel_id) {
	return awn_terminal_applet_construct (TYPE_AWN_TERMINAL_APPLET, canonical_name, uid, panel_id);
}


static void _awn_terminal_applet_clicked_cb_awn_icon_clicked (AwnIcon* _sender, gpointer self) {
	awn_terminal_applet_clicked_cb (self);
}


static void _awn_terminal_applet_middle_clicked_cb_awn_icon_middle_clicked (AwnIcon* _sender, gpointer self) {
	awn_terminal_applet_middle_clicked_cb (self);
}


static void _awn_terminal_applet_on_context_menu_popup_awn_icon_context_menu_popup (AwnIcon* _sender, GdkEventButton* event, gpointer self) {
	awn_terminal_applet_on_context_menu_popup (self, event);
}


static void _lambda10_ (GObject* obj, GParamSpec* pspec, AwnTerminalApplet* self) {
	GObject* _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	if ((g_object_get ((GtkWindow*) (_tmp0_ = obj, AWN_IS_DIALOG (_tmp0_) ? ((AwnDialog*) _tmp0_) : NULL), "is-active", &_tmp1_, NULL), _tmp1_) == FALSE) {
		g_get_current_time (&self->priv->last_inactive_time);
	}
}


static void __lambda10__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda10_ (_sender, pspec, self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void awn_terminal_applet_real_constructed (GObject* base) {
	AwnTerminalApplet * self;
	GError * _inner_error_;
	AwnDialog* _tmp0_;
	GtkVBox* box;
	GtkNotebook* _tmp1_;
	DesktopAgnosticConfigClient* _tmp2_;
	DesktopAgnosticConfigClient* _tmp3_;
	self = (AwnTerminalApplet*) base;
	_inner_error_ = NULL;
	G_OBJECT_CLASS (awn_terminal_applet_parent_class)->constructed ((GObject*) AWN_APPLET_SIMPLE (self));
	awn_applet_simple_set_tooltip_text ((AwnAppletSimple*) self, "Awn Terminal");
	awn_applet_simple_set_icon_name ((AwnAppletSimple*) self, "terminal");
	g_signal_connect_object (awn_applet_simple_get_icon ((AwnAppletSimple*) self), "clicked", (GCallback) _awn_terminal_applet_clicked_cb_awn_icon_clicked, self, 0);
	g_signal_connect_object (awn_applet_simple_get_icon ((AwnAppletSimple*) self), "middle-clicked", (GCallback) _awn_terminal_applet_middle_clicked_cb_awn_icon_middle_clicked, self, 0);
	g_signal_connect_object (awn_applet_simple_get_icon ((AwnAppletSimple*) self), "context-menu-popup", (GCallback) _awn_terminal_applet_on_context_menu_popup_awn_icon_context_menu_popup, self, 0);
	self->priv->dialog = (_tmp0_ = g_object_ref_sink ((AwnDialog*) awn_dialog_new_for_widget ((GtkWidget*) self)), _g_object_unref0 (self->priv->dialog), _tmp0_);
	gtk_window_set_skip_taskbar_hint ((GtkWindow*) self->priv->dialog, FALSE);
	self->priv->number_of_tabs = 0;
	box = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (TRUE, 0));
	gtk_container_add ((GtkContainer*) self->priv->dialog, (GtkWidget*) box);
	self->priv->notebook = (_tmp1_ = g_object_ref_sink ((GtkNotebook*) gtk_notebook_new ()), _g_object_unref0 (self->priv->notebook), _tmp1_);
	gtk_notebook_set_tab_pos (self->priv->notebook, GTK_POS_TOP);
	gtk_notebook_set_scrollable (self->priv->notebook, TRUE);
	gtk_container_add ((GtkContainer*) box, (GtkWidget*) self->priv->notebook);
	awn_terminal_applet_create_new_tab (self);
	g_object_set (self->priv->dialog, "hide-on-unfocus", TRUE, NULL);
	g_object_set (self->priv->dialog, "hide-on-esc", FALSE, NULL);
	g_signal_connect_object ((GObject*) self->priv->dialog, "notify::is-active", (GCallback) __lambda10__g_object_notify, self, 0);
	_tmp2_ = awn_config_get_default_for_applet ((AwnApplet*) self, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (box);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	self->priv->config = (_tmp3_ = _g_object_ref0 (_tmp2_), _g_object_unref0 (self->priv->config), _tmp3_);
	{
		desktop_agnostic_config_client_bind (self->priv->config, DESKTOP_AGNOSTIC_CONFIG_GROUP_DEFAULT, "opacity", (GObject*) self, "bg-opacity", FALSE, DESKTOP_AGNOSTIC_CONFIG_BIND_METHOD_FALLBACK, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DESKTOP_AGNOSTIC_CONFIG_ERROR) {
				goto __catch0_desktop_agnostic_config_error;
			}
			_g_object_unref0 (box);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		desktop_agnostic_config_client_bind (self->priv->config, DESKTOP_AGNOSTIC_CONFIG_GROUP_DEFAULT, "hide_on_unfocus", (GObject*) self, "hide-on-unfocus", FALSE, DESKTOP_AGNOSTIC_CONFIG_BIND_METHOD_FALLBACK, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DESKTOP_AGNOSTIC_CONFIG_ERROR) {
				goto __catch0_desktop_agnostic_config_error;
			}
			_g_object_unref0 (box);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		desktop_agnostic_config_client_bind (self->priv->config, DESKTOP_AGNOSTIC_CONFIG_GROUP_DEFAULT, "global_hotkey", (GObject*) self, "keybinding", FALSE, DESKTOP_AGNOSTIC_CONFIG_BIND_METHOD_FALLBACK, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DESKTOP_AGNOSTIC_CONFIG_ERROR) {
				goto __catch0_desktop_agnostic_config_error;
			}
			_g_object_unref0 (box);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		desktop_agnostic_config_client_bind (self->priv->config, DESKTOP_AGNOSTIC_CONFIG_GROUP_DEFAULT, "bg_img", (GObject*) self, "background-image", FALSE, DESKTOP_AGNOSTIC_CONFIG_BIND_METHOD_FALLBACK, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DESKTOP_AGNOSTIC_CONFIG_ERROR) {
				goto __catch0_desktop_agnostic_config_error;
			}
			_g_object_unref0 (box);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		desktop_agnostic_config_client_bind (self->priv->config, DESKTOP_AGNOSTIC_CONFIG_GROUP_DEFAULT, "main_terminal", (GObject*) self, "terminal-command", FALSE, DESKTOP_AGNOSTIC_CONFIG_BIND_METHOD_FALLBACK, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DESKTOP_AGNOSTIC_CONFIG_ERROR) {
				goto __catch0_desktop_agnostic_config_error;
			}
			_g_object_unref0 (box);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally0;
	__catch0_desktop_agnostic_config_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
			g_critical ("awn-terminal.vala:191: Config Error: %s", err->message);
			_g_error_free0 (err);
		}
	}
	__finally0:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (box);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (box);
}


static void awn_terminal_applet_global_keypress (AwnTerminalApplet* self, const char* keystring) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (keystring != NULL);
	_inner_error_ = NULL;
	terminal_dbus_toggle ((TerminalDBus*) self, awn_keybinder_get_current_event_time (), &_inner_error_);
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void awn_terminal_applet_real_toggle (TerminalDBus* base, guint32 time_, GError** error) {
	AwnTerminalApplet * self;
	GtkWidgetFlags flags;
	gboolean should_hide;
	self = (AwnTerminalApplet*) base;
	flags = GTK_WIDGET_FLAGS ((GtkWidget*) self->priv->dialog) & GTK_VISIBLE;
	should_hide = flags != 0;
	if (should_hide) {
		gboolean _tmp0_;
		if ((g_object_get ((GtkWindow*) self->priv->dialog, "is-active", &_tmp0_, NULL), _tmp0_)) {
			should_hide = TRUE;
		} else {
			GTimeVal cur_time = {0};
			glong sec_diff;
			should_hide = FALSE;
			g_get_current_time (&cur_time);
			sec_diff = cur_time.tv_sec - self->priv->last_inactive_time.tv_sec;
			if (sec_diff <= 1) {
				glong usec_diff;
				usec_diff = ((sec_diff * 1000000) + cur_time.tv_usec) - self->priv->last_inactive_time.tv_usec;
				if (usec_diff <= 250000) {
					should_hide = TRUE;
				}
			}
		}
	}
	if (should_hide) {
		gtk_widget_hide ((GtkWidget*) self->priv->dialog);
	} else {
		gtk_widget_show_all ((GtkWidget*) self->priv->dialog);
		gtk_window_present_with_time ((GtkWindow*) self->priv->dialog, time_);
	}
}


static void awn_terminal_applet_create_new_tab (AwnTerminalApplet* self) {
	VteTerminal* terminal;
	char* _tmp0_;
	GtkLabel* _tmp1_;
	GtkLabel* label;
	g_return_if_fail (self != NULL);
	terminal = g_object_ref_sink ((VteTerminal*) vte_terminal_new ());
	vte_terminal_set_emulation (terminal, "xterm");
	vte_terminal_fork_command (terminal, NULL, NULL, NULL, "~/", FALSE, FALSE, FALSE);
	if (self->priv->_background_image != NULL) {
		vte_terminal_set_background_image_file (terminal, self->priv->_background_image);
	}
	self->priv->number_of_tabs++;
	label = (_tmp1_ = g_object_ref_sink ((GtkLabel*) gtk_label_new (_tmp0_ = g_strdup_printf ("Term #%d", self->priv->number_of_tabs))), _g_free0 (_tmp0_), _tmp1_);
	gtk_notebook_append_page (self->priv->notebook, (GtkWidget*) terminal, (GtkWidget*) label);
	if (gtk_notebook_get_n_pages (self->priv->notebook) > 1) {
		gtk_notebook_set_show_tabs (self->priv->notebook, TRUE);
		gtk_widget_show_all ((GtkWidget*) self->priv->dialog);
	} else {
		gtk_notebook_set_show_tabs (self->priv->notebook, FALSE);
	}
	g_signal_connect_swapped (terminal, "child-exited", (GCallback) awn_terminal_applet_exited_cb, self);
	g_signal_connect_swapped (terminal, "key-press-event", (GCallback) awn_terminal_applet_key_press_cb, self);
	_g_object_unref0 (terminal);
	_g_object_unref0 (label);
}


static void awn_terminal_applet_clicked_cb (AwnTerminalApplet* self) {
	GtkWidgetFlags flags;
	g_return_if_fail (self != NULL);
	flags = GTK_WIDGET_FLAGS ((GtkWidget*) self->priv->dialog) & GTK_VISIBLE;
	if (flags != 0) {
		gtk_widget_hide ((GtkWidget*) self->priv->dialog);
	} else {
		gtk_widget_show_all ((GtkWidget*) self->priv->dialog);
	}
}


static void awn_terminal_applet_middle_clicked_cb (AwnTerminalApplet* self) {
	GError * _inner_error_;
	char* terminal;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	terminal = g_strdup (self->priv->_terminal_command);
	{
		gboolean _tmp0_ = FALSE;
		if (terminal == NULL) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = strlen (terminal) == 0;
		}
		if (_tmp0_) {
			char* _tmp1_;
			terminal = (_tmp1_ = g_strdup ("gnome-terminal"), _g_free0 (terminal), _tmp1_);
		}
		gdk_spawn_command_line_on_screen (gtk_window_get_screen ((GtkWindow*) self), terminal, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
		{
			g_warning ("awn-terminal.vala:299: Unable to run '%s'!", terminal);
		}
	}
	__finally1:
	if (_inner_error_ != NULL) {
		_g_free0 (terminal);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (terminal);
}


static gboolean awn_terminal_applet_key_press_cb (AwnTerminalApplet* self, GdkEventKey* event, VteTerminal* terminal) {
	gboolean result = FALSE;
	GdkModifierType mods;
	GdkModifierType is_ctrl;
	GdkModifierType is_shift;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (terminal != NULL, FALSE);
	mods = (GdkModifierType) (*event).state;
	is_ctrl = mods & GDK_CONTROL_MASK;
	is_shift = mods & GDK_SHIFT_MASK;
	if (is_ctrl != 0) {
		_tmp0_ = is_shift != 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		const char* key;
		key = gdk_keyval_name (gdk_keyval_to_lower ((*event).keyval));
		if (_vala_strcmp0 (key, "c") == 0) {
			vte_terminal_copy_clipboard (terminal);
		} else {
			if (_vala_strcmp0 (key, "v") == 0) {
				vte_terminal_paste_clipboard (terminal);
			} else {
				if (_vala_strcmp0 (key, "t") == 0) {
					awn_terminal_applet_create_new_tab (self);
					gtk_notebook_set_current_page (self->priv->notebook, gtk_notebook_get_n_pages (self->priv->notebook) - 1);
				}
			}
		}
		result = TRUE;
		return result;
	} else {
		if (is_ctrl != 0) {
			const char* key;
			key = gdk_keyval_name (gdk_keyval_to_lower ((*event).keyval));
			if (_vala_strcmp0 (key, "Page_Up") == 0) {
				gint page;
				page = gtk_notebook_get_current_page (self->priv->notebook) - 1;
				page = page % gtk_notebook_get_n_pages (self->priv->notebook);
				gtk_notebook_set_current_page (self->priv->notebook, page);
				result = TRUE;
				return result;
			} else {
				if (_vala_strcmp0 (key, "Page_Down") == 0) {
					gint page;
					page = gtk_notebook_get_current_page (self->priv->notebook) + 1;
					page = page % gtk_notebook_get_n_pages (self->priv->notebook);
					gtk_notebook_set_current_page (self->priv->notebook, page);
					result = TRUE;
					return result;
				}
			}
		}
	}
	result = FALSE;
	return result;
}


static void awn_terminal_applet_exited_cb (AwnTerminalApplet* self, VteTerminal* terminal) {
	gint pages;
	g_return_if_fail (self != NULL);
	g_return_if_fail (terminal != NULL);
	pages = gtk_notebook_get_n_pages (self->priv->notebook);
	if (pages > 1) {
		gint page;
		page = gtk_notebook_get_current_page (self->priv->notebook);
		gtk_notebook_remove_page (self->priv->notebook, page);
		if (pages == 2) {
			gtk_notebook_set_show_tabs (self->priv->notebook, FALSE);
		}
		gtk_widget_show_all ((GtkWidget*) self->priv->dialog);
	} else {
		vte_terminal_reset (terminal, TRUE, TRUE);
		vte_terminal_fork_command (terminal, NULL, NULL, NULL, "~/", FALSE, FALSE, FALSE);
		gtk_widget_hide ((GtkWidget*) self->priv->dialog);
	}
}


static void _awn_terminal_applet_on_prefs_activate_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	awn_terminal_applet_on_prefs_activate (self);
}


static void awn_terminal_applet_on_context_menu_popup (AwnTerminalApplet* self, GdkEventButton* evt) {
	g_return_if_fail (self != NULL);
	if (self->priv->menu == NULL) {
		GtkImageMenuItem* prefs_item;
		GtkWidget* about_item;
		GtkMenu* _tmp1_;
		GtkWidget* _tmp0_;
		GtkImageMenuItem* _tmp2_;
		GtkWidget* _tmp3_;
		GtkWidget* _tmp4_;
		prefs_item = NULL;
		about_item = NULL;
		self->priv->menu = (_tmp1_ = _g_object_ref0 ((_tmp0_ = awn_applet_create_default_menu ((AwnApplet*) self), GTK_IS_MENU (_tmp0_) ? ((GtkMenu*) _tmp0_) : NULL)), _g_object_unref0 (self->priv->menu), _tmp1_);
		prefs_item = (_tmp2_ = g_object_ref_sink ((GtkImageMenuItem*) gtk_image_menu_item_new_from_stock (GTK_STOCK_PREFERENCES, NULL)), _g_object_unref0 (prefs_item), _tmp2_);
		g_signal_connect_object ((GtkMenuItem*) prefs_item, "activate", (GCallback) _awn_terminal_applet_on_prefs_activate_gtk_menu_item_activate, self, 0);
		gtk_widget_show ((GtkWidget*) prefs_item);
		gtk_menu_shell_append ((GtkMenuShell*) self->priv->menu, (GtkWidget*) ((GtkMenuItem*) prefs_item));
		about_item = (_tmp3_ = _g_object_ref0 (awn_applet_create_about_item_simple ((AwnApplet*) self, "Copyright © 2009 Michal Hruby" "<michal.mhr@gmail.com>", AWN_APPLET_LICENSE_GPLV2, VERSION)), _g_object_unref0 (about_item), _tmp3_);
		gtk_widget_show (about_item);
		gtk_menu_shell_append ((GtkMenuShell*) self->priv->menu, (GtkWidget*) (_tmp4_ = about_item, GTK_IS_MENU_ITEM (_tmp4_) ? ((GtkMenuItem*) _tmp4_) : NULL));
		_g_object_unref0 (prefs_item);
		_g_object_unref0 (about_item);
	}
	gtk_menu_set_screen (self->priv->menu, NULL);
	gtk_menu_popup (self->priv->menu, NULL, NULL, NULL, NULL, (*evt).button, (*evt).time);
}


static gboolean _lambda0_ (GtkWidget* w, GdkEvent* e, AwnTerminalApplet* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (w != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	gtk_widget_hide (w);
	result = TRUE;
	return result;
}


static gboolean __lambda0__gtk_widget_delete_event (GtkWidget* _sender, GdkEvent* event, gpointer self) {
	return _lambda0_ (_sender, event, self);
}


static void _lambda1_ (GtkToggleButton* w, AwnTerminalApplet* self) {
	g_return_if_fail (w != NULL);
	awn_terminal_applet_set_hide_on_unfocus (self, gtk_toggle_button_get_active (w));
}


static void __lambda1__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	_lambda1_ (_sender, self);
}


static void _lambda2_ (GtkCellRendererAccel* a, const char* path, guint accel_key, GdkModifierType accel_mods, guint keycode, AwnTerminalApplet* self) {
	guint key = 0U;
	EggVirtualModifierType virt_mods = 0;
	char* _tmp0_;
	g_return_if_fail (a != NULL);
	g_return_if_fail (path != NULL);
	egg_keymap_virtualize_modifiers (gdk_keymap_get_default (), accel_mods, &virt_mods);
	awn_terminal_applet_set_keybinding (self, _tmp0_ = egg_virtual_accelerator_name (accel_key, virt_mods));
	_g_free0 (_tmp0_);
}


static void __lambda2__gtk_cell_renderer_accel_accel_edited (GtkCellRendererAccel* _sender, const char* path_string, guint accel_key, GdkModifierType accel_mods, guint hardware_keycode, gpointer self) {
	_lambda2_ (_sender, path_string, accel_key, accel_mods, hardware_keycode, self);
}


static void _lambda3_ (GtkCellRendererAccel* a, const char* path, AwnTerminalApplet* self) {
	g_return_if_fail (a != NULL);
	g_return_if_fail (path != NULL);
	awn_terminal_applet_set_keybinding (self, "");
}


static void __lambda3__gtk_cell_renderer_accel_accel_cleared (GtkCellRendererAccel* _sender, const char* path_string, gpointer self) {
	_lambda3_ (_sender, path_string, self);
}


static void _lambda4_ (GtkFileChooserButton* w, AwnTerminalApplet* self) {
	char* _tmp0_;
	g_return_if_fail (w != NULL);
	awn_terminal_applet_set_background_image (self, _tmp0_ = gtk_file_chooser_get_filename ((GtkFileChooser*) w));
	_g_free0 (_tmp0_);
}


static void __lambda4__gtk_file_chooser_button_file_set (GtkFileChooserButton* _sender, gpointer self) {
	_lambda4_ (_sender, self);
}


static void _lambda5_ (GtkFileChooser* w, AwnTerminalApplet* self) {
	GError * _inner_error_;
	char* filename;
	g_return_if_fail (w != NULL);
	_inner_error_ = NULL;
	filename = gtk_file_chooser_get_preview_filename (w);
	{
		GdkPixbuf* pixbuf;
		pixbuf = gdk_pixbuf_new_from_file_at_size (filename, 128, 128, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch2_g_error;
		}
		gtk_image_set_from_pixbuf (self->priv->preview_image, pixbuf);
		gtk_file_chooser_set_preview_widget_active (w, TRUE);
		_g_object_unref0 (pixbuf);
	}
	goto __finally2;
	__catch2_g_error:
	{
		g_clear_error (&_inner_error_);
		_inner_error_ = NULL;
		{
			gtk_file_chooser_set_preview_widget_active (w, FALSE);
		}
	}
	__finally2:
	if (_inner_error_ != NULL) {
		_g_free0 (filename);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (filename);
}


static void __lambda5__gtk_file_chooser_update_preview (GtkFileChooser* _sender, gpointer self) {
	_lambda5_ (_sender, self);
}


static void _lambda6_ (GtkButton* b, AwnTerminalApplet* self) {
	g_return_if_fail (b != NULL);
	gtk_file_chooser_set_filename ((GtkFileChooser*) self->priv->chooser, "");
	awn_terminal_applet_set_background_image (self, "");
}


static void __lambda6__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda6_ (_sender, self);
}


static void _lambda7_ (GtkRange* w, AwnTerminalApplet* self) {
	g_return_if_fail (w != NULL);
	awn_terminal_applet_set_bg_opacity (self, (float) gtk_range_get_value (w));
}


static void __lambda7__gtk_range_value_changed (GtkRange* _sender, gpointer self) {
	_lambda7_ (_sender, self);
}


static gboolean _lambda8_ (GtkWidget* w, GdkEventFocus* e, AwnTerminalApplet* self) {
	gboolean result = FALSE;
	GtkWidget* _tmp0_;
	g_return_val_if_fail (w != NULL, FALSE);
	awn_terminal_applet_set_terminal_command (self, gtk_entry_get_text ((_tmp0_ = w, GTK_IS_ENTRY (_tmp0_) ? ((GtkEntry*) _tmp0_) : NULL)));
	result = FALSE;
	return result;
}


static gboolean __lambda8__gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	return _lambda8_ (_sender, event, self);
}


static void _lambda9_ (GtkButton* w, AwnTerminalApplet* self) {
	g_return_if_fail (w != NULL);
	gtk_widget_hide ((GtkWidget*) self->priv->prefs_window);
}


static void __lambda9__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda9_ (_sender, self);
}


static void awn_terminal_applet_on_prefs_activate (AwnTerminalApplet* self) {
	GtkWindow* _tmp0_;
	GtkBox* box;
	GtkWidget* widget;
	char* _tmp2_;
	GtkWidget* _tmp1_;
	GtkWidget* _tmp3_;
	GtkAlignment* align;
	GtkBox* box2;
	GtkWidget* _tmp4_;
	GtkWidget* _tmp5_;
	GtkWidget* _tmp6_;
	GtkCellRenderer* ren;
	GtkTreeViewColumn* col;
	GtkTreeView* treeview;
	GtkListStore* _tmp7_;
	GtkCellRenderer* _tmp8_;
	GtkTreeViewColumn* _tmp9_;
	GtkCellRenderer* _tmp10_;
	GtkCellRenderer* _tmp11_;
	GtkCellRenderer* _tmp12_;
	GtkCellRenderer* _tmp13_;
	GtkCellRenderer* _tmp14_;
	GtkTreeViewColumn* _tmp15_;
	GtkTreeIter iter = {0};
	GtkBox* section_box;
	GtkWidget* _tmp16_;
	char* _tmp18_;
	GtkWidget* _tmp17_;
	GtkWidget* _tmp19_;
	GtkAlignment* _tmp20_;
	GtkBox* _tmp21_;
	GtkImage* _tmp22_;
	GtkFileChooserButton* _tmp23_;
	GtkWidget* button;
	GtkWidget* _tmp24_;
	GtkBox* _tmp25_;
	GtkWidget* _tmp26_;
	char* _tmp28_;
	GtkWidget* _tmp27_;
	GtkWidget* _tmp29_;
	GtkAlignment* _tmp30_;
	GtkWidget* _tmp31_;
	GtkWidget* _tmp32_;
	GtkWidget* _tmp33_;
	GtkBox* _tmp34_;
	GtkWidget* _tmp35_;
	char* _tmp37_;
	GtkWidget* _tmp36_;
	GtkWidget* _tmp38_;
	GtkAlignment* _tmp39_;
	GtkWidget* _tmp40_;
	GtkWidget* _tmp41_;
	GtkWidget* _tmp42_;
	GtkBox* _tmp43_;
	GtkBox* _tmp44_;
	GtkWidget* _tmp45_;
	GtkWidget* _tmp46_;
	g_return_if_fail (self != NULL);
	if (self->priv->prefs_window != NULL) {
		gtk_widget_show_all ((GtkWidget*) self->priv->prefs_window);
		return;
	}
	self->priv->prefs_window = (_tmp0_ = g_object_ref_sink ((GtkWindow*) gtk_window_new (GTK_WINDOW_TOPLEVEL)), _g_object_unref0 (self->priv->prefs_window), _tmp0_);
	gtk_window_set_title (self->priv->prefs_window, _ ("Preferences"));
	gtk_window_set_default_icon_name ("terminal");
	gtk_container_set_border_width ((GtkContainer*) self->priv->prefs_window, (guint) 6);
	g_signal_connect_object ((GtkWidget*) self->priv->prefs_window, "delete-event", (GCallback) __lambda0__gtk_widget_delete_event, self, 0);
	box = (GtkBox*) g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 6));
	gtk_container_add ((GtkContainer*) self->priv->prefs_window, (GtkWidget*) box);
	widget = (GtkWidget*) g_object_ref_sink ((GtkLabel*) gtk_label_new (""));
	gtk_label_set_markup ((_tmp1_ = widget, GTK_IS_LABEL (_tmp1_) ? ((GtkLabel*) _tmp1_) : NULL), _tmp2_ = g_strdup_printf ("<b>%s</b>", _ ("Behavior")));
	_g_free0 (_tmp2_);
	gtk_misc_set_alignment ((GtkMisc*) (_tmp3_ = widget, GTK_IS_LABEL (_tmp3_) ? ((GtkLabel*) _tmp3_) : NULL), 0.0f, 0.5f);
	gtk_box_pack_start (box, widget, FALSE, FALSE, (guint) 0);
	align = g_object_ref_sink ((GtkAlignment*) gtk_alignment_new (0.5f, 0.5f, 1.0f, 0.0f));
	gtk_alignment_set_padding (align, (guint) 0, (guint) 0, (guint) 10, (guint) 0);
	gtk_box_pack_start (box, (GtkWidget*) align, FALSE, FALSE, (guint) 0);
	box2 = (GtkBox*) g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 6));
	gtk_container_add ((GtkContainer*) align, (GtkWidget*) box2);
	widget = (_tmp4_ = (GtkWidget*) g_object_ref_sink ((GtkCheckButton*) gtk_check_button_new_with_label (_ ("Hide when focus is lost"))), _g_object_unref0 (widget), _tmp4_);
	gtk_toggle_button_set_active ((GtkToggleButton*) (_tmp5_ = widget, GTK_IS_CHECK_BUTTON (_tmp5_) ? ((GtkCheckButton*) _tmp5_) : NULL), awn_terminal_applet_get_hide_on_unfocus (self));
	g_signal_connect_object ((GtkToggleButton*) (_tmp6_ = widget, GTK_IS_CHECK_BUTTON (_tmp6_) ? ((GtkCheckButton*) _tmp6_) : NULL), "toggled", (GCallback) __lambda1__gtk_toggle_button_toggled, self, 0);
	gtk_box_pack_start (box2, widget, FALSE, FALSE, (guint) 0);
	ren = NULL;
	col = NULL;
	treeview = g_object_ref_sink ((GtkTreeView*) gtk_tree_view_new ());
	gtk_box_pack_start (box2, (GtkWidget*) treeview, FALSE, FALSE, (guint) 0);
	self->priv->model = (_tmp7_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_STRING, NULL), _g_object_unref0 (self->priv->model), _tmp7_);
	gtk_tree_view_set_model (treeview, (GtkTreeModel*) self->priv->model);
	ren = (_tmp8_ = (GtkCellRenderer*) g_object_ref_sink ((GtkCellRendererText*) gtk_cell_renderer_text_new ()), _g_object_unref0 (ren), _tmp8_);
	col = (_tmp9_ = g_object_ref_sink (gtk_tree_view_column_new_with_attributes (_ ("Action"), ren, "text", 0, NULL)), _g_object_unref0 (col), _tmp9_);
	gtk_tree_view_append_column (treeview, col);
	ren = (_tmp10_ = (GtkCellRenderer*) g_object_ref_sink ((GtkCellRendererAccel*) gtk_cell_renderer_accel_new ()), _g_object_unref0 (ren), _tmp10_);
	g_object_set ((GtkCellRendererText*) (_tmp11_ = ren, GTK_IS_CELL_RENDERER_ACCEL (_tmp11_) ? ((GtkCellRendererAccel*) _tmp11_) : NULL), "editable", TRUE, NULL);
	g_object_set ((_tmp12_ = ren, GTK_IS_CELL_RENDERER_ACCEL (_tmp12_) ? ((GtkCellRendererAccel*) _tmp12_) : NULL), "accel-mode", GTK_CELL_RENDERER_ACCEL_MODE_OTHER, NULL);
	g_signal_connect_object ((_tmp13_ = ren, GTK_IS_CELL_RENDERER_ACCEL (_tmp13_) ? ((GtkCellRendererAccel*) _tmp13_) : NULL), "accel-edited", (GCallback) __lambda2__gtk_cell_renderer_accel_accel_edited, self, 0);
	g_signal_connect_object ((_tmp14_ = ren, GTK_IS_CELL_RENDERER_ACCEL (_tmp14_) ? ((GtkCellRendererAccel*) _tmp14_) : NULL), "accel-cleared", (GCallback) __lambda3__gtk_cell_renderer_accel_accel_cleared, self, 0);
	col = (_tmp15_ = g_object_ref_sink (gtk_tree_view_column_new_with_attributes (_ ("Shortcut"), ren, "text", 1, NULL)), _g_object_unref0 (col), _tmp15_);
	gtk_tree_view_append_column (treeview, col);
	gtk_list_store_append (self->priv->model, &iter);
	gtk_list_store_set (self->priv->model, &iter, 0, _ ("Activate"), -1);
	awn_terminal_applet_set_keybinding (self, self->priv->_keybinding);
	section_box = (GtkBox*) g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 0));
	gtk_box_pack_start (box, (GtkWidget*) section_box, FALSE, FALSE, (guint) 0);
	widget = (_tmp16_ = (GtkWidget*) g_object_ref_sink ((GtkLabel*) gtk_label_new ("")), _g_object_unref0 (widget), _tmp16_);
	gtk_label_set_markup ((_tmp17_ = widget, GTK_IS_LABEL (_tmp17_) ? ((GtkLabel*) _tmp17_) : NULL), _tmp18_ = g_strdup_printf ("<b>%s</b>", _ ("Background image")));
	_g_free0 (_tmp18_);
	gtk_misc_set_alignment ((GtkMisc*) (_tmp19_ = widget, GTK_IS_LABEL (_tmp19_) ? ((GtkLabel*) _tmp19_) : NULL), 0.0f, 0.5f);
	gtk_box_pack_start (section_box, widget, FALSE, FALSE, (guint) 0);
	align = (_tmp20_ = g_object_ref_sink ((GtkAlignment*) gtk_alignment_new (0.5f, 0.5f, 1.0f, 0.0f)), _g_object_unref0 (align), _tmp20_);
	gtk_alignment_set_padding (align, (guint) 0, (guint) 0, (guint) 10, (guint) 0);
	gtk_box_pack_start (section_box, (GtkWidget*) align, FALSE, FALSE, (guint) 0);
	box2 = (_tmp21_ = (GtkBox*) g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 3)), _g_object_unref0 (box2), _tmp21_);
	gtk_container_add ((GtkContainer*) align, (GtkWidget*) box2);
	self->priv->preview_image = (_tmp22_ = g_object_ref_sink ((GtkImage*) gtk_image_new ()), _g_object_unref0 (self->priv->preview_image), _tmp22_);
	self->priv->chooser = (_tmp23_ = g_object_ref_sink ((GtkFileChooserButton*) gtk_file_chooser_button_new (_ ("Select a file"), GTK_FILE_CHOOSER_ACTION_OPEN)), _g_object_unref0 (self->priv->chooser), _tmp23_);
	gtk_file_chooser_set_filename ((GtkFileChooser*) self->priv->chooser, awn_terminal_applet_get_background_image (self));
	gtk_file_chooser_set_preview_widget ((GtkFileChooser*) self->priv->chooser, (GtkWidget*) self->priv->preview_image);
	gtk_widget_set_size_request ((GtkWidget*) self->priv->chooser, 200, -1);
	g_signal_connect_object (self->priv->chooser, "file-set", (GCallback) __lambda4__gtk_file_chooser_button_file_set, self, 0);
	g_signal_connect_object ((GtkFileChooser*) self->priv->chooser, "update-preview", (GCallback) __lambda5__gtk_file_chooser_update_preview, self, 0);
	gtk_box_pack_start (box2, (GtkWidget*) self->priv->chooser, TRUE, TRUE, (guint) 0);
	button = (GtkWidget*) g_object_ref_sink ((GtkButton*) gtk_button_new_from_stock (GTK_STOCK_CLEAR));
	g_signal_connect_object ((_tmp24_ = button, GTK_IS_BUTTON (_tmp24_) ? ((GtkButton*) _tmp24_) : NULL), "clicked", (GCallback) __lambda6__gtk_button_clicked, self, 0);
	gtk_box_pack_start (box2, button, FALSE, FALSE, (guint) 0);
	section_box = (_tmp25_ = (GtkBox*) g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 0)), _g_object_unref0 (section_box), _tmp25_);
	gtk_box_pack_start (box, (GtkWidget*) section_box, FALSE, FALSE, (guint) 0);
	widget = (_tmp26_ = (GtkWidget*) g_object_ref_sink ((GtkLabel*) gtk_label_new ("")), _g_object_unref0 (widget), _tmp26_);
	gtk_label_set_markup ((_tmp27_ = widget, GTK_IS_LABEL (_tmp27_) ? ((GtkLabel*) _tmp27_) : NULL), _tmp28_ = g_strdup_printf ("<b>%s</b>", _ ("Terminal opacity")));
	_g_free0 (_tmp28_);
	gtk_misc_set_alignment ((GtkMisc*) (_tmp29_ = widget, GTK_IS_LABEL (_tmp29_) ? ((GtkLabel*) _tmp29_) : NULL), 0.0f, 0.5f);
	gtk_box_pack_start (section_box, widget, FALSE, FALSE, (guint) 3);
	align = (_tmp30_ = g_object_ref_sink ((GtkAlignment*) gtk_alignment_new (0.5f, 0.5f, 1.0f, 0.0f)), _g_object_unref0 (align), _tmp30_);
	gtk_alignment_set_padding (align, (guint) 0, (guint) 0, (guint) 10, (guint) 0);
	gtk_box_pack_start (section_box, (GtkWidget*) align, FALSE, FALSE, (guint) 0);
	widget = (_tmp31_ = (GtkWidget*) g_object_ref_sink ((GtkHScale*) gtk_hscale_new_with_range ((double) 0.1f, (double) 1.0f, (double) 0.1f)), _g_object_unref0 (widget), _tmp31_);
	gtk_range_set_value ((_tmp32_ = widget, GTK_IS_RANGE (_tmp32_) ? ((GtkRange*) _tmp32_) : NULL), (double) self->priv->_bg_opacity);
	g_signal_connect_object ((GtkRange*) (_tmp33_ = widget, GTK_IS_SCALE (_tmp33_) ? ((GtkScale*) _tmp33_) : NULL), "value-changed", (GCallback) __lambda7__gtk_range_value_changed, self, 0);
	gtk_container_add ((GtkContainer*) align, widget);
	section_box = (_tmp34_ = (GtkBox*) g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 0)), _g_object_unref0 (section_box), _tmp34_);
	gtk_box_pack_start (box, (GtkWidget*) section_box, FALSE, FALSE, (guint) 0);
	widget = (_tmp35_ = (GtkWidget*) g_object_ref_sink ((GtkLabel*) gtk_label_new ("")), _g_object_unref0 (widget), _tmp35_);
	gtk_label_set_markup ((_tmp36_ = widget, GTK_IS_LABEL (_tmp36_) ? ((GtkLabel*) _tmp36_) : NULL), _tmp37_ = g_strdup_printf ("<b>%s</b>", _ ("External Terminal")));
	_g_free0 (_tmp37_);
	gtk_misc_set_alignment ((GtkMisc*) (_tmp38_ = widget, GTK_IS_LABEL (_tmp38_) ? ((GtkLabel*) _tmp38_) : NULL), 0.0f, 0.5f);
	gtk_box_pack_start (section_box, widget, FALSE, FALSE, (guint) 3);
	align = (_tmp39_ = g_object_ref_sink ((GtkAlignment*) gtk_alignment_new (0.5f, 0.5f, 1.0f, 0.0f)), _g_object_unref0 (align), _tmp39_);
	gtk_alignment_set_padding (align, (guint) 0, (guint) 0, (guint) 10, (guint) 0);
	gtk_box_pack_start (section_box, (GtkWidget*) align, FALSE, FALSE, (guint) 0);
	widget = (_tmp40_ = (GtkWidget*) g_object_ref_sink ((GtkEntry*) gtk_entry_new ()), _g_object_unref0 (widget), _tmp40_);
	gtk_entry_set_text ((_tmp41_ = widget, GTK_IS_ENTRY (_tmp41_) ? ((GtkEntry*) _tmp41_) : NULL), awn_terminal_applet_get_terminal_command (self));
	g_signal_connect_object ((GtkWidget*) (_tmp42_ = widget, GTK_IS_ENTRY (_tmp42_) ? ((GtkEntry*) _tmp42_) : NULL), "focus-out-event", (GCallback) __lambda8__gtk_widget_focus_out_event, self, 0);
	gtk_container_add ((GtkContainer*) align, widget);
	box2 = (_tmp43_ = (GtkBox*) g_object_ref_sink ((GtkHButtonBox*) gtk_hbutton_box_new ()), _g_object_unref0 (box2), _tmp43_);
	gtk_button_box_set_layout ((_tmp44_ = box2, GTK_IS_BUTTON_BOX (_tmp44_) ? ((GtkButtonBox*) _tmp44_) : NULL), GTK_BUTTONBOX_END);
	gtk_box_pack_end (box, (GtkWidget*) box2, FALSE, FALSE, (guint) 0);
	widget = (_tmp45_ = (GtkWidget*) g_object_ref_sink ((GtkButton*) gtk_button_new_from_stock (GTK_STOCK_CLOSE)), _g_object_unref0 (widget), _tmp45_);
	gtk_box_pack_start (box2, widget, FALSE, FALSE, (guint) 0);
	g_signal_connect_object ((_tmp46_ = widget, GTK_IS_BUTTON (_tmp46_) ? ((GtkButton*) _tmp46_) : NULL), "clicked", (GCallback) __lambda9__gtk_button_clicked, self, 0);
	gtk_widget_show_all ((GtkWidget*) self->priv->prefs_window);
	_g_object_unref0 (box);
	_g_object_unref0 (widget);
	_g_object_unref0 (align);
	_g_object_unref0 (box2);
	_g_object_unref0 (ren);
	_g_object_unref0 (col);
	_g_object_unref0 (treeview);
	_g_object_unref0 (section_box);
	_g_object_unref0 (button);
}


float awn_terminal_applet_get_bg_opacity (AwnTerminalApplet* self) {
	float result;
	g_return_val_if_fail (self != NULL, 0.0F);
	result = self->priv->_bg_opacity;
	return result;
}


void awn_terminal_applet_set_bg_opacity (AwnTerminalApplet* self, float value) {
	g_return_if_fail (self != NULL);
	self->priv->_bg_opacity = value;
	gtk_window_set_opacity ((GtkWindow*) self->priv->dialog, (double) value);
	g_object_notify ((GObject *) self, "bg-opacity");
}


gboolean awn_terminal_applet_get_hide_on_unfocus (AwnTerminalApplet* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	result = (g_object_get (self->priv->dialog, "hide-on-unfocus", &_tmp0_, NULL), _tmp0_);
	return result;
}


void awn_terminal_applet_set_hide_on_unfocus (AwnTerminalApplet* self, gboolean value) {
	g_return_if_fail (self != NULL);
	g_object_set (self->priv->dialog, "hide-on-unfocus", value, NULL);
	g_object_notify ((GObject *) self, "hide-on-unfocus");
}


const char* awn_terminal_applet_get_background_image (AwnTerminalApplet* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_background_image;
	return result;
}


void awn_terminal_applet_set_background_image (AwnTerminalApplet* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_background_image = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_background_image), _tmp0_);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				GtkWidget* _tmp2_;
				VteTerminal* term;
				if (!_tmp1_) {
					i++;
				}
				_tmp1_ = FALSE;
				if (!(i < gtk_notebook_get_n_pages (self->priv->notebook))) {
					break;
				}
				term = _g_object_ref0 ((_tmp2_ = gtk_notebook_get_nth_page (self->priv->notebook, i), VTE_IS_TERMINAL (_tmp2_) ? ((VteTerminal*) _tmp2_) : NULL));
				vte_terminal_set_background_image_file (term, value);
				_g_object_unref0 (term);
			}
		}
	}
	g_object_notify ((GObject *) self, "background-image");
}


const char* awn_terminal_applet_get_keybinding (AwnTerminalApplet* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_keybinding;
	return result;
}


static void _awn_terminal_applet_global_keypress_awn_keybinder_bindkey_handler (const char* keystring, gpointer self) {
	awn_terminal_applet_global_keypress (self, keystring);
}


void awn_terminal_applet_set_keybinding (AwnTerminalApplet* self, const char* value) {
	gboolean _tmp0_ = FALSE;
	char* _tmp1_;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	g_debug ("awn-terminal.vala:80: keybinding: %s", value);
	if (self->priv->_keybinding != NULL) {
		_tmp0_ = strlen (self->priv->_keybinding) > 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		awn_keybinder_unbind (self->priv->_keybinding, _awn_terminal_applet_global_keypress_awn_keybinder_bindkey_handler, self);
	}
	self->priv->_keybinding = (_tmp1_ = g_strdup (value), _g_free0 (self->priv->_keybinding), _tmp1_);
	if (self->priv->_keybinding != NULL) {
		_tmp2_ = strlen (self->priv->_keybinding) > 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		awn_keybinder_bind (self->priv->_keybinding, _awn_terminal_applet_global_keypress_awn_keybinder_bindkey_handler, self);
	}
	if (self->priv->model != NULL) {
		GtkTreeIter iter = {0};
		if (gtk_tree_model_get_iter_first ((GtkTreeModel*) self->priv->model, &iter)) {
			const char* _tmp3_;
			gboolean _tmp4_ = FALSE;
			_tmp3_ = NULL;
			if (self->priv->_keybinding != NULL) {
				_tmp4_ = strlen (self->priv->_keybinding) > 0;
			} else {
				_tmp4_ = FALSE;
			}
			if (_tmp4_) {
				_tmp3_ = self->priv->_keybinding;
			} else {
				_tmp3_ = _ ("Disabled");
			}
			gtk_list_store_set (self->priv->model, &iter, 1, _tmp3_, -1);
		}
	}
	g_object_notify ((GObject *) self, "keybinding");
}


const char* awn_terminal_applet_get_terminal_command (AwnTerminalApplet* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_terminal_command;
	return result;
}


void awn_terminal_applet_set_terminal_command (AwnTerminalApplet* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_terminal_command = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_terminal_command), _tmp0_);
	g_object_notify ((GObject *) self, "terminal-command");
}


static GObject * awn_terminal_applet_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	AwnTerminalApplet * self;
	parent_class = G_OBJECT_CLASS (awn_terminal_applet_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = AWN_TERMINAL_APPLET (obj);
	{
		GTimeVal _tmp4_ = {0};
		awn_keybinder_init ();
		self->priv->last_inactive_time = (g_get_current_time (&_tmp4_), _tmp4_);
	}
	return obj;
}


void _awn_terminal_applet_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_awn_terminal_applet_introspect (AwnTerminalApplet* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.awnproject.Applet.Terminal\">\n  <method name=\"Toggle\">\n    <arg name=\"time_\" type=\"u\" direction=\"in\"/>\n  </method>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


DBusHandlerResult awn_terminal_applet_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_awn_terminal_applet_introspect (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else if (terminal_dbus_dbus_message (connection, message, object) == DBUS_HANDLER_RESULT_HANDLED) {
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


void awn_terminal_applet_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_awn_terminal_applet_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
	terminal_dbus_dbus_register_object (connection, path, object);
}


static void awn_terminal_applet_class_init (AwnTerminalAppletClass * klass) {
	awn_terminal_applet_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (AwnTerminalAppletPrivate));
	G_OBJECT_CLASS (klass)->constructed = awn_terminal_applet_real_constructed;
	G_OBJECT_CLASS (klass)->get_property = awn_terminal_applet_get_property;
	G_OBJECT_CLASS (klass)->set_property = awn_terminal_applet_set_property;
	G_OBJECT_CLASS (klass)->constructor = awn_terminal_applet_constructor;
	G_OBJECT_CLASS (klass)->finalize = awn_terminal_applet_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), AWN_TERMINAL_APPLET_BG_OPACITY, g_param_spec_float ("bg-opacity", "bg-opacity", "bg-opacity", -G_MAXFLOAT, G_MAXFLOAT, 0.0F, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AWN_TERMINAL_APPLET_HIDE_ON_UNFOCUS, g_param_spec_boolean ("hide-on-unfocus", "hide-on-unfocus", "hide-on-unfocus", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AWN_TERMINAL_APPLET_BACKGROUND_IMAGE, g_param_spec_string ("background-image", "background-image", "background-image", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AWN_TERMINAL_APPLET_KEYBINDING, g_param_spec_string ("keybinding", "keybinding", "keybinding", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), AWN_TERMINAL_APPLET_TERMINAL_COMMAND, g_param_spec_string ("terminal-command", "terminal-command", "terminal-command", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_type_set_qdata (TYPE_AWN_TERMINAL_APPLET, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_awn_terminal_applet_dbus_vtable));
}


static void awn_terminal_applet_terminal_dbus_interface_init (TerminalDBusIface * iface) {
	awn_terminal_applet_terminal_dbus_parent_iface = g_type_interface_peek_parent (iface);
	iface->toggle = awn_terminal_applet_real_toggle;
}


static void awn_terminal_applet_instance_init (AwnTerminalApplet * self) {
	self->priv = AWN_TERMINAL_APPLET_GET_PRIVATE (self);
	self->priv->model = NULL;
	self->priv->_background_image = NULL;
	self->priv->_keybinding = NULL;
	self->priv->_terminal_command = NULL;
}


static void awn_terminal_applet_finalize (GObject* obj) {
	AwnTerminalApplet * self;
	self = AWN_TERMINAL_APPLET (obj);
	_g_object_unref0 (self->priv->config);
	_g_object_unref0 (self->priv->menu);
	_g_object_unref0 (self->priv->dialog);
	_g_object_unref0 (self->priv->notebook);
	_g_object_unref0 (self->priv->chooser);
	_g_object_unref0 (self->priv->preview_image);
	_g_object_unref0 (self->priv->prefs_window);
	_g_object_unref0 (self->priv->model);
	_g_free0 (self->priv->_background_image);
	_g_free0 (self->priv->_keybinding);
	_g_free0 (self->priv->_terminal_command);
	G_OBJECT_CLASS (awn_terminal_applet_parent_class)->finalize (obj);
}


GType awn_terminal_applet_get_type (void) {
	static volatile gsize awn_terminal_applet_type_id__volatile = 0;
	if (g_once_init_enter (&awn_terminal_applet_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AwnTerminalAppletClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) awn_terminal_applet_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AwnTerminalApplet), 0, (GInstanceInitFunc) awn_terminal_applet_instance_init, NULL };
		static const GInterfaceInfo terminal_dbus_info = { (GInterfaceInitFunc) awn_terminal_applet_terminal_dbus_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType awn_terminal_applet_type_id;
		awn_terminal_applet_type_id = g_type_register_static (AWN_TYPE_APPLET_SIMPLE, "AwnTerminalApplet", &g_define_type_info, 0);
		g_type_add_interface_static (awn_terminal_applet_type_id, TYPE_TERMINAL_DBUS, &terminal_dbus_info);
		g_once_init_leave (&awn_terminal_applet_type_id__volatile, awn_terminal_applet_type_id);
	}
	return awn_terminal_applet_type_id__volatile;
}


static void awn_terminal_applet_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	AwnTerminalApplet * self;
	self = AWN_TERMINAL_APPLET (object);
	switch (property_id) {
		case AWN_TERMINAL_APPLET_BG_OPACITY:
		g_value_set_float (value, awn_terminal_applet_get_bg_opacity (self));
		break;
		case AWN_TERMINAL_APPLET_HIDE_ON_UNFOCUS:
		g_value_set_boolean (value, awn_terminal_applet_get_hide_on_unfocus (self));
		break;
		case AWN_TERMINAL_APPLET_BACKGROUND_IMAGE:
		g_value_set_string (value, awn_terminal_applet_get_background_image (self));
		break;
		case AWN_TERMINAL_APPLET_KEYBINDING:
		g_value_set_string (value, awn_terminal_applet_get_keybinding (self));
		break;
		case AWN_TERMINAL_APPLET_TERMINAL_COMMAND:
		g_value_set_string (value, awn_terminal_applet_get_terminal_command (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void awn_terminal_applet_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	AwnTerminalApplet * self;
	self = AWN_TERMINAL_APPLET (object);
	switch (property_id) {
		case AWN_TERMINAL_APPLET_BG_OPACITY:
		awn_terminal_applet_set_bg_opacity (self, g_value_get_float (value));
		break;
		case AWN_TERMINAL_APPLET_HIDE_ON_UNFOCUS:
		awn_terminal_applet_set_hide_on_unfocus (self, g_value_get_boolean (value));
		break;
		case AWN_TERMINAL_APPLET_BACKGROUND_IMAGE:
		awn_terminal_applet_set_background_image (self, g_value_get_string (value));
		break;
		case AWN_TERMINAL_APPLET_KEYBINDING:
		awn_terminal_applet_set_keybinding (self, g_value_get_string (value));
		break;
		case AWN_TERMINAL_APPLET_TERMINAL_COMMAND:
		awn_terminal_applet_set_terminal_command (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static guint _dynamic_request_name0 (DBusGProxy* self, const char* param1, guint param2, GError** error) {
	guint result;
	dbus_g_proxy_call (self, "RequestName", error, G_TYPE_STRING, param1, G_TYPE_UINT, param2, G_TYPE_INVALID, G_TYPE_UINT, &result, G_TYPE_INVALID);
	if (*error) {
		return 0U;
	}
	return result;
}


AwnApplet* awn_applet_factory_initp (const char* canonical_name, const char* uid, gint panel_id) {
	AwnApplet* result = NULL;
	GError * _inner_error_;
	DBusGConnection* conn;
	DBusGProxy* bus;
	guint _result_;
	AwnTerminalApplet* applet;
	g_return_val_if_fail (canonical_name != NULL, NULL);
	g_return_val_if_fail (uid != NULL, NULL);
	_inner_error_ = NULL;
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	textdomain (GETTEXT_PACKAGE);
	conn = dbus_g_bus_get (DBUS_BUS_SESSION, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	bus = dbus_g_proxy_new_for_name (conn, "org.freedesktop.DBus", "/org/freedesktop/DBus", "org.freedesktop.DBus");
	_result_ = _dynamic_request_name0 (bus, "org.awnproject.Applet.Terminal", (guint) 0, &_inner_error_);
	if (_inner_error_ != NULL) {
		_dbus_g_connection_unref0 (conn);
		_g_object_unref0 (bus);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	if (_result_ != DBUS_REQUEST_NAME_REPLY_PRIMARY_OWNER) {
		g_warning ("awn-terminal.vala:620: Coudln't get ownership of org.awnproject.Applet" \
".Terminal!");
	}
	applet = g_object_ref_sink (awn_terminal_applet_new (canonical_name, uid, panel_id));
	_vala_dbus_register_object (dbus_g_connection_get_connection (conn), "/org/awnproject/Applet/Terminal", (GObject*) applet);
	result = (AwnApplet*) applet;
	_dbus_g_connection_unref0 (conn);
	_g_object_unref0 (bus);
	return result;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}


static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	const _DBusObjectVTable * vtable;
	vtable = g_type_get_qdata (G_TYPE_FROM_INSTANCE (object), g_quark_from_static_string ("DBusObjectVTable"));
	if (vtable) {
		vtable->register_object (connection, path, object);
	} else {
		g_warning ("Object does not implement any D-Bus interface");
	}
}


static void _vala_dbus_unregister_object (gpointer connection, GObject* object) {
	char* path;
	path = g_object_steal_data ((GObject*) object, "dbus_object_path");
	dbus_connection_unregister_object_path (connection, path);
	g_free (path);
}




