/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */
 
#include <stdio.h>
#include <string.h>
#include <qstring.h>
#include <qvaluelist.h>
#include <metaquality.h>
#include <metaline.h>
#include <metaobject.h>
#include <miscfunctions.h>

// #define DEBUG_META_OBJECT

#ifdef IDSTRING
#undef IDSTRING
#endif

#define IDSTRING "Metaobject:"

#define fold			MIMEfold
#define unfold		MIMEunfold


QString &MetaObject::getPrivateLine(QString &source)
{
#ifdef DEBUG_META_OBJECT
		printf(IDSTRING"getLine\n");
#endif
	int i;
	i=source.find('\n');
	if(i==0)
		i=source.find('\n', 1);
	if(i==-1)
		i=source.length();
	static QString qs;
	qs=source.left(i);
	source.remove(0,i+1);
	return qs;
}


void MetaObject::parse(QString &qs)
{
	children.setAutoDelete(TRUE);
	lines.setAutoDelete(TRUE);
	
	QString curline;
	QString mainTitle;
	QString title;
	replaceCRLF(qs);
	curline=getPrivateLine(qs);
	MetaLine *ml;
	ml=new MetaLine(curline);
	if((ml->getName()).find("BEGIN", 0, false)!=-1)
	{
		mainTitle="End:"+ml->getContent();
		objectName=ml->getContent();
		while(curline.contains(mainTitle, false)==0 && curline.length()>0)
		{
			delete ml;
			curline=getPrivateLine(qs);
#ifdef DEBUG_META_OBJECT
				printf(IDSTRING"parse: line1: {%s}\n", (const char *)curline);
#endif
			ml=new MetaLine(curline);
#ifdef DEBUG_META_OBJECT
				printf(IDSTRING"parse: line1: [%s] [%s]\n", (const char *)ml->getName(),
					(const char *)ml->getContent());
#endif
			// test if i have another block
			if((ml->getName()).find("BEGIN", 0, false)!=-1)
			{
				title="END:"+ml->getContent();
#ifdef DEBUG_META_OBJECT
					printf(IDSTRING"parse:     2: [%s]\n", (const char *)title);
#endif
				QString block=curline;
				while(curline.contains(title, false)==0)
				{
					delete ml;
					curline=getPrivateLine(qs);
					ml=new MetaLine(curline);
#ifdef DEBUG_META_OBJECT
						printf(IDSTRING"parse: line2: %s\n", (const char *)curline);
#endif
					block+="\n"+curline;
				}
				block+="\n";
#ifdef DEBUG_META_OBJECT
				printf(IDSTRING"parse: new block:\n%s\n---\n", (const char *)block);
				printf(IDSTRING"parse: new block append\n");
				printf(IDSTRING"parse: new block parse done\n");
#endif
				children.append(new MetaObject(block, this));
#ifdef DEBUG_META_OBJECT
				printf(IDSTRING"parse: new block append done\n");
#endif
			}
			else
			{
#ifdef DEBUG_META_OBJECT
				printf(IDSTRING"parse: new line append\n");
#endif
				if(!curline.isEmpty())
					lines.append(new MetaLine(curline));
#ifdef DEBUG_META_OBJECT
				printf(IDSTRING"parse: new line append done\n");
#endif
			}
		}
	}
	else
	{
		printf(IDSTRING"parse: ERROR: Invalid structure\n");
		lines.clear();
		text="";
		children.clear();
		objectName="UnknownObject";
	}
	delete ml;
}

void MetaObject::appendLine(QString line)
{
	// if the line is empty, nothing happens
	if(line.stripWhiteSpace().isEmpty())
		return;
	lines.insert(0,new MetaLine(line));
}


MetaObject::MetaObject()
{
	objectName="";
}

MetaObject::MetaObject(QString qs, MetaObject *dp)
{
	directParent=dp;
	unfold(qs);
	parse(qs);
}

MetaObject::MetaObject(MetaObject &mo)
{
	lines=mo.getLines();
	children=mo.getChildren();
	objectName=mo.getObjectName();
	directParent=mo.getDirectParent();
}

MetaObject &MetaObject::operator=(MetaObject &mo)
{
	lines=mo.getLines();
	children=mo.getChildren();
	objectName=mo.getObjectName();
	return *this;
}

MetaObject::~MetaObject()
{
	// deleting the childrens...
	unsigned it;
	#ifdef DEBUG_META_OBJECT
		printf("Deleting children: [");
	#endif
	for(it=0; it<children.count();it++)
	{
		#ifdef DEBUG_META_OBJECT
			printf(".");
		#endif
		children.remove((unsigned)0);
	}
	#ifdef DEBUG_META_OBJECT
		printf("]\n");
	#endif
	// deleting the lines ...
	#ifdef DEBUG_META_OBJECT
		printf("Deleting lines: [");
	#endif
  for(it=0; it<lines.count();it++)
  {
		#ifdef DEBUG_META_OBJECT
  	  printf(".");
		#endif
    lines.remove((unsigned)0);
  }
	#ifdef DEBUG_META_OBJECT
		printf("]\n");
	#endif
}

MetaLine &MetaObject::operator[](QString qs)
{
	unsigned it;
	for(it=0;it<lines.count();it++)
	{
		if(lines.at(it)->getName().find(qs,0,false)==0)
			return *(lines.at(it));
	}
	return *(lines.at(0));
}

MetaLine &MetaObject::getLine(int idx)
{
	if((unsigned)idx>lines.count() || idx<0)
		return *(lines.at(0));
	return *(lines.at(idx));
}

MetaObject *MetaObject::operator[](int index)
{
	return (children.at(index));
}

QValueList<int> MetaObject::query(QString name, 
				QString includedQuality, QString excludedQuality)
{
	QValueList<int> result;
	bool test;
	unsigned it;
	for(it=0;it<lines.count();it++)
	{
		if(lines.at(it)->getName().find(name,0,false)==0)
		{
			test=lines.at(it)->checkQualities(includedQuality, excludedQuality);
			if(test) result.append(it);
		}
	}
	return result;
}

int MetaObject::extendedQuery(QString name, 
				QString includedQuality, QString excludedQuality, 
				QString includedContent, QString excludedContent,
				intList *results)
{
	bool test;
	if(results==0)
		return -1;
	results->setAutoDelete(true);
	unsigned it;
	unsigned counter=0;
	for(it=0;it<lines.count();it++)
	{
		if(lines.at(it)->getName().find(name,0,false)==0)
		{
			test=lines.at(it)->checkQualities(includedQuality, excludedQuality);
			if(test && !includedContent.isEmpty() &&
				 (lines.at(it)->getContent().find(includedContent,0,false)==-1)) 
				test=FALSE;
			if( test && !excludedContent.isEmpty() &&
				 (lines.at(it)->getContent().find(excludedContent,0,false)!=-1)) 
				test=FALSE;
			if(test){
				int *match;
				match=new int;
				*match=it;
				results->append(match);
				counter++;
			}
		}
	}
	return counter;
}
void MetaObject::appendLineQuality(QString name, QString quality)
{
	unsigned it;
	for(it=0;it<lines.count();it++)
	{
		if(lines.at(it)->getName().find(name,0,false)==0)
		{
			lines.at(it)->addQualities(quality);
			return;
		}
	}
	return;
}
void MetaObject::insertLineContent(QString name, QString content, int pos)
{
	unsigned it;
	for(it=0;it<lines.count();it++)
	{
		if(lines.at(it)->getName().find(name,0,false)==0)
		{
			if(pos==-1)
				lines.at(it)->setContent(lines.at(it)->getContent()+content);
			else
				lines.at(it)->setContent(
						lines.at(it)->getContent().insert(pos,content));
			return;
		}
	}
	return;
}
void MetaObject::replaceLineQuality(QString name, QString quality)
{
	unsigned it;
	for(it=0;it<lines.count();it++)
	{
		if(lines.at(it)->getName().find(name,0,false)==0)
		{
			lines.at(it)->replaceQualities(quality);
			return;
		}
	}
	return;
}

void MetaObject::replaceLine(int lineno, QString lineContent)
{
	if(lineno!=-1 && (unsigned)lineno<lines.count())
		lines.remove(lineno);
	else
		lineno=0;
	lines.insert(lineno,new MetaLine(lineContent));
}


void MetaObject::replaceLineContent(QString name, QString content)
{
	unsigned it;
	for(it=0;it<lines.count();it++)
	{
		if(lines.at(it)->getName().find(name,0,false)==0)
		{
			lines.at(it)->setContent(content);
			return;
		}
	}
	return;
}
bool MetaObject::eraseLine(QString name)
{
	unsigned it;
	for(it=0;it<lines.count();it++)
	{
		if(lines.at(it)->getName().find(name,0,false)==0)
		{
			lines.remove(it);
			return TRUE;
		}
	}
	return FALSE;
}
QString MetaObject::recompose()
{
	text="BEGIN:"+objectName+"\n";
	// now adding the lines...
	for(unsigned i=0;i<lines.count()-1;i++)
		text+=lines.at(i)->recompose()+"\n";
	// and adding the nested objects
	for(unsigned i=0;i<children.count();i++)
		text+=children.at(i)->recompose()+"\n";
	
	text+="END:"+objectName;
	fold(text);
	return text;
}

void MetaObject::deleteNestedObject(int idx)
{
	if (idx>children.count() || idx < 0)
		return;
	children.remove(idx);
}

void MetaObject::replaceCRLF(QString &source)
{
	if(source==QString::null) return;
	for(unsigned i=0;i<source.length();)
	{
		i=source.find("\r\n",i);
		if(i<source.length())
			source.replace(i,2,"\n");
	}
}




