/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

#include <khtml_part.h>
#include <kconfig.h>
#include <kcursor.h>
#include <kstddirs.h>

#include <mailer.h>
#include <mailview.h>
#include <mainwindow.h>
#include <maillabel.h>
#include <pixmaps.h>
#include <indexmailitem.h>
#include <miscfunctions.h>
#include <texthtml.h>
#include <clientvfs.h>
#include <conversions.h>
#include <videotoolbox.h>
#include <clientnotifier.h>
#include <contentswidget.h>

extern KConfig* GlobalConfig;
extern MainWindow *MWindow;
extern TextHtmlConvertor *textHtmlConverter;

#ifdef IDSTRING
#undef IDSTRING
#endif

#define IDSTRING "MailView: "

//#define DEBUG_MAILVIEW

MailView::MailView(QWidget *parent, bool vert, const char *name):QWidget(parent, name)
{
  attvert=vert;
	view=0;
  label=0;
	showatt=false;
	ShowFlag=0;
	forceUpdate=false;
	
#ifdef DEBUG_MAILVIEW
	printf(IDSTRING"init: Enter\n");
#endif
	mailpopup=new QPopupMenu;
	mailpopup->insertItem("Send mail to this address", 1);
	mailpopup->insertItem(QPixmap(reply_xpm), "Reply to this address", 2);
	mailpopup->insertItem("Add to Address Book", 3);
	mailpopup->insertItem("Search in Address Book", 4);
	mailpopup->insertItem("Send link to ...", 5);
	mailpopup->insertSeparator();
	mailpopup->insertItem(QPixmap(copy_xpm), "Copy link", 6);
	
	linkpopup=new QPopupMenu;
	linkpopup->insertItem(QPixmap(open_xpm), "Open link", 1);
	linkpopup->insertItem("Add to bookmarks", 2);
	linkpopup->insertItem("Send link to ...", 3);
	linkpopup->insertSeparator();
	linkpopup->insertItem(QPixmap(copy_xpm), "Copy link", 4);
	
	genericpopup=new QPopupMenu;
	genericpopup->insertItem(QIconSet(QPixmap(copy_xpm)), "Copy", this, SLOT(copyText()), 0, 1);
	genericpopup->insertSeparator();
	genericpopup->insertItem("Send selection to ...", 2);
	genericpopup->insertSeparator();
	genericpopup->insertItem("View frame source", 2);
	genericpopup->insertItem("View message source", 3);
	genericpopup->insertItem("View message header", 4);
	genericpopup->insertSeparator();
	genericpopup->insertItem("Properties", 5);
	
  split=new QSplitter(this);
  if(!attvert) split->setOrientation(QSplitter::Vertical);

	view=new KHTMLPart(split, "Aethera Main");
	view->autoloadImages(true);

	attpane=new AttachmentPane(split);

  label=new MailLabel(this);
		
	l=new QVBoxLayout(this);
  l->addWidget(label);
	l->addWidget(split);
	
	connect(ClientNotifier::thisInstance(), SIGNAL(deleteVInstance(QString)), this, SLOT(objectDeleted(QString)));
	connect(ClientNotifier::thisInstance(), SIGNAL(updateVInstance(QString)), this, SLOT(objectChanged(QString)));
	
	view->show();
	label->show();
	split->show();
	attpane->hide();
	
	l->activate();
	showDefaultPage();
}

void MailView::setAddress(QString addr)
{
	// debug
//	printf("entering MailView:setAddress(%s)\n", (const char *)addr);
	
	if(addr.isEmpty())
	{
		showDefaultPage();
		return;
	}
	
	// avoid repeated repaints, they can be fairly slow
	if(addr==address && forceUpdate==false)
	  return;
	else
	{
	  // get the object
		address=addr;
  	MailObject *item=(MailObject *)ClientVFS::thisInstance()->objectRef(address);
  	if( forceUpdate )
  	  item->sync();
  	
  	// build the mail label
		label->setAddress(address);
		delete attpane;
	  attpane=new AttachmentPane(split);
		attpane->setAddress(address);
		forceUpdate=false;
	
		// build the mail view
  	// find out if user preffers plain text or html	
  	GlobalConfig->setGroup("Read Options");
    bool prefferHTML=(GlobalConfig->readEntry("Preffer HTML")=="Yes")?true:false;
  	
  	if(item)
  	{
  		QString text;
  		bool htmlSource;
  		
  		if(prefferHTML && item->hasHTML())
  		{
  			text=item->html();
  			htmlSource=true;
  		}
  		else
  		{
  			text=item->text();
  			htmlSource=false;
  		}
  		
  		// process text
  		if(prefferHTML && htmlSource)
  		{
  			// we got HTML text
  			textHtmlConverter->html2html(text);
  		}
  		else
  		{
  			// we got plain text
  			textHtmlConverter->text2html(text);
  		}

  		KURL url("magellan://"+address);
  		view->begin(url);
  		view->write((const char *)text);
  		view->end();
  	}
	}
}

void MailView::togglePane()
{
  if(attpane)
  {
    showatt=!showatt;
    if(showatt)
      attpane->show();
    else
      attpane->hide();
  }
}

void MailView::hideAttachmentPane()
{
	showatt=false;
	attpane->hide();
}

void MailView::objectDeleted(QString path)
{
	// debug
	// printf("mailview: [objectDeleted] on path %s (mine is %s)\n",
	//		(const char *)ClientVFS::thisInstance()->reverseMap(path),
	//		(const char *)address);
	
	if(path.contains('.')) path=path.left(path.findRev('.'));
	
	if(address==ClientVFS::thisInstance()->reverseMap(path))
		setAddress(QString::null);
}

void MailView::objectChanged(QString path)
{
	// debug
	// printf("mailview: [objectChanged] on path %s (mine is %s)\n",
	//		(const char *)ClientVFS::thisInstance()->reverseMap(path),
	//		(const char *)address);
	
	if(path.contains('.')) path=path.left(path.findRev('.'));
	
	if(address==ClientVFS::thisInstance()->reverseMap(path))
	{
		forceUpdate=true;
		setAddress(address);
	}
	
	// change the view
  ContentsWidget::ref()->updateCurrentView();
}

MailView::~MailView()
{
#ifdef DEBUG_MAILVIEW
	printf(IDSTRING"~MailView: Enter\n");
#endif
	delete(view);
	delete(l);
  delete(label);
  delete(split);
  if(attpane)
    delete(attpane);
#ifdef DEBUG_MAILVIEW
	printf(IDSTRING"~MailView: Exit\n");
#endif
}
	
// This slot is called when the user right-clicks inside the mail window. It is used to display a popup menu

// void MailView::showPopup(KHTMLWidget *v, QString url, const QPoint &point)
// {
// 	if(url.isEmpty())
// 	{
// 		if(v->isTextSelected())
// 		{
// 			genericpopup->setItemEnabled(1, TRUE);
// 			genericpopup->setItemEnabled(2, TRUE);
// 		}
// 		else
// 		{
// 			genericpopup->setItemEnabled(1, FALSE);
// 			genericpopup->setItemEnabled(2, FALSE);
// 		}
// 		genericpopup->exec(QCursor::pos());
// 	}
// 	else
// 	{
// 		QString qurl=url;
// 		qurl.truncate(7);
// 		if(qurl=="mailto:")
// 			mailpopup->exec(QCursor::pos());
// 		else
// 			linkpopup->exec(QCursor::pos());
// 	}
// }	

// This slot is connected to SIGNAL(imageRequest()) from the HTMLView. It changes all URL references to
// images, that have by default "magellan://mail" as first 15 characters, or "magellan://nothing" etc. into real URLs.

// void MailView::imgReq(QString url)
// {
// 	printf(IDSTRING"imgReq: enter\n");
// 	DwString local(url);
// 	if(local.find("magellan://mail")!=local.npos)
// 	{
//     printf(IDSTRING"imgReq: mail.\n");
// 		local.erase(0, 15);
// //		view->slotImageLoaded(url, local.c_str());
//     return;
// 	}
// 	if(local.find("magellan://nothing")!=local.npos)
// 	{
//     printf(IDSTRING"imgReq: nothing.\n");
// 		local.erase(0, 18);
// //		view->slotImageLoaded(url, local.c_str());
//     return;
// 	}
//   if(local.find("file:/")!=local.npos)
//   {
//     printf("imgReq: file\n");
//     local.erase(0, 6);
// //    view->slotImageLoaded(url, local.c_str());
//     return;
//   }
//   printf("imgReq: default\n");
// //  view->slotImageLoaded(url, local.c_str());
// }

// This slot is connected to SIGNAL(onURL()) from all the html views. It is responsible for all the messages
// shown in the status bar when the user moves the mouse over a hyperlink, e-mail address or attachment.

// void MailView::onURL(KHTMLWidget *v, QString url)
// {
// 	QString u=url, txt;
// 	if(url.isEmpty())
// 	{
// 		MWindow->statusBar()->message("Ready");
// 		setCursor(KCursor::arrowCursor());
// 		return;
// 	}
// 	setCursor(KCursor::handCursor());
//
// 	u.truncate(7);
// 	u.lower();
// 	if(u=="mailto:")
// 	{
// 		GlobalConfig->setGroup("Read Options");
// 		u=url;
// 		u.remove(0, 7);
// 		mailAction=GlobalConfig->readEntry("Email default action");
// 		if(mailAction!="add"&&mailAction!="new"&&mailAction!="reply")
// 		{
// 			mailAction="new";
// 			GlobalConfig->writeEntry("Email default action", mailAction);
// 		}
// 		if(mailAction=="add")
// 		{
// 			txt="Add ";
// 			txt+=u;
// 			txt+=" to the Address Book";
// 		}
// 		if(mailAction=="reply")
// 		{
// 			txt="Reply this message to ";
// 			txt+=u;
// 		}
// 		if(mailAction=="new")
// 		{
// 			txt="Send mail to ";
// 			txt+=u;
// 		}
// 	}
// 	else
// 	{
// 		txt="Open ";
// 		txt+=url;
// 	}
//   MWindow->statusBar()->message((const char *)txt);
// }

// void MailView::setIndex(IndexClass *index)
// {
//   printf("MailView: setting index %p..\n", index);
//
// 	if(index==0)
//   {
//     showDefaultPage();
//     return;
//   }
//
// 	Index=index;
// 	Index->restoreMail();
//   label->setIndex(Index);
//
// 	if(label->getAttachmentButton())
// 		connect(label->getAttachmentButton(), SIGNAL(clicked()), this, SLOT(togglePane()));
//
// 	GlobalConfig->setGroup("Read Options");
//   bool flag=(GlobalConfig->readEntry("Preffer HTML")=="Yes")?true:false;
//
//   // get text
//   DwString htmlBody=(const char *)Index->text(flag);
// #ifdef DEBUG_MAILVIEW
//   printf("text:\n%s\n", htmlBody.c_str());
// #endif
//
//   // process text
//   if(flag && Index->hasHTMLText())
//   {
//     // we got a html text
//     textHtmlConverter->html2html(&htmlBody);
//   }
//   else
//   {
//     // we got a plain text
//     textHtmlConverter->text2html(&htmlBody);
//   }
//
// #ifdef DEBUG_MAILVIEW
//   printf("text processing done.\n");
// #endif
//
// //  view->begin("file:/tmp");
// //  view->write(htmlBody.c_str());
// //  view->end();
//
// /*   if(attpane)
//   {
//     attpane->hide();
// #ifdef DEBUG_MAILVIEW
//     printf(IDSTRING"Destroying the attachment pane previously created.\n");
// #endif
//     delete attpane;
// #ifdef DEBUG_MAILVIEW
//     printf(IDSTRING"Done.\n");
// #endif
//     attpane=0;
//   }
//   showatt=false;
//
//   if(Index->hasAttachments)
//   {
// #ifdef DEBUG_MAILVIEW
//     printf(IDSTRING"Mail has attachments, creating a new attachment pane..\n");
// #endif
//     attpane=new AttachmentPane(split);
//     attpane->setIndex(Index);
//     attpane->hide();
//   }
//
//   delete enc;
//   delete type;
//   if(htmlBody)
//     delete htmlBody;
//  */
// #ifdef DEBUG_MAILVIEW
//   printf(IDSTRING"Exiting MailView::setIndex()...\n");
// #endif
// }

void MailView::showDefaultPage()
{
/*
#ifdef DEBUG_MAILVIEW
  printf("MailView: showing the default page..\n");
#endif	
  label->showDefault();
	QString defaultText="\
<html>\
<head>\
<title>Untitled Document</title>\
<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">\
</head>\
<body marginwidth=0 marginheight=0 background=\"file://"DATADIR"html/images/bg2.png\">\
<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" height=\"100%\">\
  <tr>\
    <td colspan=\"2\" height=\"50\"><img src=\"file://"DATADIR"html/images/bar2.png\" width=\"500\"\
height=\"50\"></td>\
  </tr>\
  <tr>\
    <td width=\"50\">&nbsp;</td>\
    <td width=\"100%\" valign=\"middle\" align=\"center\">\
      <h2><font face=\"Arial, Helvetica, sans-serif\">Nothing to display.</font></h2>\
    </td>\
  </tr>\
</table>\
</body>\
</html>";

//	KURL defaultUrl("file:/"DATADIR"html/");

	view->begin(defaultUrl);
	view->write((const char *)defaultText);
	view->end();
*/
	view->begin();
	view->end();
}

void MailView::copyText()
{
//  QClipboard *cb=QApplication::clipboard();
//  QString text;
//  view->getSelectedText(text);
//  cb->setText(text);
}






