/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * $Id: composerwidget.cpp,v 1.2 2001/05/18 04:07:06 alex Exp $
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <qlineedit.h>
#include <qwidget.h>
#include <qlayout.h>
#include <qsplitter.h>

#include <kconfig.h>

#include <composerwidget.h>
#include <addresslistclass.h>
#include <elineedit.h>
#include <qsplitter.h>
#include <composerattpane.h>
#include <lineedit.h>
#include <composerwindow.h>

extern KConfig *GlobalConfig;

ComposerWidget::ComposerWidget(ComposerWindow *parent, const char *name):QWidget(parent, name)
{
	layout=new QVBoxLayout(this, 0, -1, "ComposerWidget::layout");
	
	// edit fields
	toField=new AddressFieldEdit(this, "toField");
	ccField=new AddressFieldEdit(this, "ccField");
	bccField=new AddressFieldEdit(this, "bccField");
	subjectField=new GenericFieldEdit(this, "subjectField");
	
	toField->setLabel("To:");
	ccField->setLabel("Cc:");
	bccField->setLabel("Bcc:");
	subjectField->setLabelText("Subject:");
	
	// main area
	attachmentSplitter=new QSplitter(QSplitter::Vertical, this, "attachmentSplitter");
	editor=new ComposerEditor(attachmentSplitter, "editor");
	attachmentPane=new ComposerAttachmentPane(parent, attachmentSplitter, "attachmentPane");
	
	// add widgets in the layout
	layout->addWidget(toField);
	layout->addWidget(ccField);
	layout->addWidget(bccField);
	layout->addWidget(subjectField);
	layout->addWidget(attachmentSplitter);
	
	toField->show();
	ccField->show();
	
	// check if the bcc field is enabled
	GlobalConfig->setGroup("Composer");
	if(GlobalConfig->readEntry("Bcc")=="Yes")
		bccField->show();
	else
		bccField->hide();
	
	subjectField->show();
	editor->show();
	attachmentPane->hide();
	attachmentSplitter->show();
	
	// connect the edit fields to the signature update slot
	connect(toField, SIGNAL(addressChanged()), this, SLOT(updateSignature()));
	connect(ccField, SIGNAL(addressChanged()), this, SLOT(updateSignature()));
	connect(bccField, SIGNAL(addressChanged()), this, SLOT(updateSignature()));
	connect(subjectField, SIGNAL(textChanged(const QString &)), this, SLOT(updateSignature()));
}

ComposerWidget::~ComposerWidget()
{
	delete editor;
	delete attachmentPane;
	delete attachmentSplitter;
}

AddressListClass *ComposerWidget::toAddresses()
{
	return toField->addressList();
}

AddressListClass *ComposerWidget::ccAddresses()
{
	return ccField->addressList();
}

AddressListClass *ComposerWidget::bccAddresses()
{
	return bccField->addressList();
}

void ComposerWidget::setToAddresses(AddressListClass addr)
{
	toField->setAddressList(addr);
}

void ComposerWidget::setCcAddresses(AddressListClass addr)
{
	ccField->setAddressList(addr);
}

void ComposerWidget::setBccAddresses(AddressListClass addr)
{
	bccField->setAddressList(addr);
}

QString ComposerWidget::text()
{
	return editor->text();
}

void ComposerWidget::setText(QString txt)
{
	editor->setText(txt);
}

QString ComposerWidget::subject()
{
	return subjectField->getText();
}

void ComposerWidget::setSubject(QString txt)
{
	subjectField->setText(txt);
}

void ComposerWidget::updateAttachmentPane()
{
}

void ComposerWidget::updateSignature()
{
}

void ComposerWidget::updateBccField()
{
}
