/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

#include <kiconloader.h>
#include <kconfig.h>
#include <qmessagebox.h>
#include <qpopupmenu.h>

#include <pixmaps.h>
#include <cardlistview.h>
#include <cardlistviewitem.h>
#include <cardview.h>
#include <templateview.h>
#include <vfolder.h>
#include <vobject.h>
#include <contactobj.h>
#include <carddialog.h>

#include <miscfunctions.h>

#define IDSTRING "CardListView: "

extern KConfig *GlobalConfig;

QStringList CardListView::columnTitles=QStringList();
QValueList<int> CardListView::columnSizes;
QPopupMenu *CardListView::genericMenu=0, *CardListView::itemMenu=0;

CardListView::CardListView(VFolder *folder, CardView *parent, const char *name)
  : QListView(parent, name), TemplateView(folder), DataHandlerImpl()
{
	GlobalConfig->setGroup("Contacts");
	QStringList fields=enhancedSplit(GlobalConfig->readEntry("View columns"),';');
	QStringList temp;
	
	for(unsigned int i=0;i<fields.count();i++)
	{
		temp=enhancedSplit(fields[i],':');
		addColumn(temp[0]);
		setColumnWidthMode(i, Manual);
#ifdef DEBUG_CARDLISTVIEW
		printf(IDSTRING"Adding column : \"%s\"\n",(const char *)temp[0]);
#endif
	}
	show();
	setSelectionMode(Extended);
	if(columnTitles.count()==0)
		for(unsigned int i=0;i<fields.count();i++)
		{
			temp=enhancedSplit(fields[i],':');
			columnTitles.append(temp[1]);
			columnSizes.append(getSize(temp[1]));
		}
	refreshSum(columnTitles);
	
	QList<VObject> contactList=folder->objectList();
	for(unsigned int i=0;i<contactList.count();i++)
	{
  	if( folder->isSimpleObject(contactList.at(i)->name()) )
  	{
#ifdef DEBUG_CARDLISTVIEW
  		printf(IDSTRING"Adding item %d\n", i);
#endif
  		ContactObject *co;
  		co=(ContactObject *)(contactList.at(i));
  		items.append(new CardListViewItem(co, this, &columnTitles));
  		insertItem(items.at(items.count()-1));
  	}
	}
	
	// building the menus.
	if(!genericMenu)
	{
  	genericMenu=new QPopupMenu();

  	genericMenu->insertItem(QIconSet(BarIcon("Contacts")), "New contact", this, SLOT(slotNewObject()));
  	genericMenu->insertSeparator();
  	genericMenu->insertItem(QIconSet(QPixmap(paste_xpm)), "Paste");
  	genericMenu->insertSeparator();
  	genericMenu->insertItem("Select all");
	}
	if(!itemMenu)
	{
  	itemMenu=new QPopupMenu();

  	itemMenu->insertItem(QIconSet(BarIcon("edit")), "Edit", this, SLOT(slotOpenSelection()));
  	itemMenu->insertItem(QIconSet(BarIcon("Contacts")), "New contact", this, SLOT(slotNewObject()));
  	itemMenu->insertSeparator();
  	itemMenu->insertItem(QIconSet(QPixmap(cut_xpm)), "Cut");
  	itemMenu->insertItem(QIconSet(QPixmap(copy_xpm)), "Copy");
  	itemMenu->insertItem(QIconSet(QPixmap(paste_xpm)), "Paste");
  	itemMenu->insertSeparator();
  	itemMenu->insertItem(QIconSet(QPixmap(delete_xpm)), "Delete");
  	itemMenu->insertSeparator();
  	itemMenu->insertItem(QIconSet(QPixmap(send_xpm)), "Mail to ...");
	}
	update();
	connect(this,SIGNAL(rightButtonClicked(QListViewItem *, const QPoint &,int )),
		this, SLOT(itemRightClicked(QListViewItem *, const QPoint &, int )));
	connect(this,SIGNAL(doubleClicked(QListViewItem *)),
		this, SLOT(itemDoubleClicked(QListViewItem *)));
}

void CardListView::refreshSum(QStringList &)
{
	QStringList temp;
	sum=0;
	for (int i=0;i<columns();i++)
	{
		sum+=columnSizes[i];
	}
	if (!sum)
		sum=1;
#ifdef DEBUG_CARDLISTVIEW
	printf(IDSTRING"Computed: %d\n", sum);
#endif
	for (int i=0;i<columns();i++)
	{
#ifdef DEBUG_CARDLISTVIEW
		printf(IDSTRING" %d, Column size: %d, Real size: %d\n", width(), columnSizes[i],
				parentWidget()->parentWidget()->width()*columnSizes[i]/sum);
#endif
		setColumnWidth(i,width()*columnSizes[i]/sum);
	}
}

int CardListView::getSize(QString field)
{
	if(field.find("fn",0,false)!=-1) return FN_SIZE;
	if(field.find("name",0,false)!=-1) return FN_SIZE;
	if(field.find("work address",0,false)!=-1) return FN_SIZE;
	if(field.find("home address",0,false)!=-1) return FN_SIZE;
	if(field.find("phone",0,false)!=-1) return PHONE_SIZE;
	if(field.find("mobile",0,false)!=-1) return PHONE_SIZE;
	if(field.find("fax",0,false)!=-1) return PHONE_SIZE;
	if(field.find("cell",0,false)!=-1) return PHONE_SIZE;
	if(field.find("voice",0,false)!=-1) return PHONE_SIZE;
	if(field.find("email",0,false)!=-1) return EMAIL_SIZE;
	if(field.find("url",0,false)!=-1) return URL_SIZE;
	if(field.find("title",0,false)!=-1) return TITLE_SIZE;
	if(field.find("role",0,false)!=-1) return ROLE_SIZE;
	if(field.find("org",0,false)!=-1) return ORG_SIZE;
	if(field.find("class",0,false)!=-1) return CLASS_SIZE;
	return 0;
}

void CardListView::viewportResizeEvent(QResizeEvent *re)
{
	int wPaint=re->size().width(); // - ((verticalScrollBar()->isVisible())? (verticalScrollBar()->width()):0);
#ifdef DEBUG_CARDLISTVIEW
	printf(IDSTRING"Resize: Width %d aka %d (%d)\n",
			re->size().width(),
			wPaint,
			(verticalScrollBar()->isVisible())? (verticalScrollBar()->width()):0);
#endif
	for(unsigned int i=0;i<columnTitles.count();i++)
	{
		setColumnWidth(i,columnSizes[i]*wPaint/sum);
	}
	for(unsigned int i=0;i<items.count();i++)
		repaintItem(items.at(i));
	repaint();
	viewport()->resize(re->size());
}

CardListView::~CardListView()
{
}

void CardListView::update()
{
	repaint();
	for(unsigned int i=0;i<items.count();i++)
		repaintItem(items.at(i));
}

void CardListView::itemRightClicked(QListViewItem *item, const QPoint &p, int column)
{
	if(!item)
	{
		mousePoint=p;
		currentItem=0;
		genericMenu->move(p);
		genericMenu->show();
	}
	else
	{
		mousePoint=p;
		CardListViewItem *realItem=static_cast<CardListViewItem *>(item);
		currentItem=realItem;
		itemMenu->move(p);
		itemMenu->show();
	}
	printf(IDSTRING"Column: %d\n", column);
}

void CardListView::itemDoubleClicked(QListViewItem *item)
{
	if (!item)
		return;
	CardListViewItem *realItem=static_cast<CardListViewItem *>(item);
	CardDialog *vcd=new CardDialog(realItem->card(), this);
	vcd->show();
	printf(IDSTRING"itemDoubleClicked: %p\n", realItem);
}

CardListViewItem *CardListView::childAt(int x, int y)
{
	return static_cast<CardListViewItem *>(itemAt(QPoint(x,y)));
}


void CardListView::newObject()
{
	// try to create a new object
	QString id=BrokerInterface::thisInstance()->createObject(getVItem()->path());
	ContactObject *item=ClientVFS::thisInstance()->template _new<ContactObject>(getVItem()->path()+"/"+id);

	// check for failures
	if (!item)
	{
		QMessageBox::information(0, "Creation failed",
			QString("Could not create a new object in this folder.\nReason: ")+
			BrokerInterface::thisInstance()->lastError(), 1);
	}

	CardDialog *vcd = new CardDialog(item, this);
	vcd->show();

	items.append(new CardListViewItem(item, this, &columnTitles));
	insertItem(items.at(items.count()-1));
}

void CardListView::openSelection()
{
	if(!currentItem)
	{
		printf(IDSTRING"Invalid current item\n");
		return;
	}
	
	CardDialog *vcd;
	vcd=new CardDialog(currentItem->card(), this);
	vcd->show();
	//printf(IDSTRING"Todo: openContact()\n");
}

void CardListView::slotNewObject()
{
	newObject();
}

void CardListView::slotOpenSelection()
{
	openSelection();
}


