/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */
 
#include <phonesclass.h>
#include <qfile.h>
#include <qtextstream.h>
#include <qmessagebox.h>
 
PhonesClass *PhonesClass::instPhones=0;

PhonesClass::PhonesClass(QString filename)
{
	if(filename!=QString::null)
		load(filename);
}

QString PhonesClass::country(QString prefix)
{
	if(prefix.find("+")==-1)
		prefix=QString("+") + prefix;
	int idx=_prefixes.findIndex(prefix);
	if(idx==-1)
		return QString::null;
	return _countries[idx];
}

QString PhonesClass::prefix(QString country)
{
	int idx=_countries.findIndex(country);
	if(idx==-1)
		return QString::null;
	return _prefixes[idx];
}

bool PhonesClass::isCountry(QString country)
{
	return _countries.findIndex(country)!=-1;
}

bool PhonesClass::isPrefix(QString prefix)
{
	return _prefixes.findIndex(prefix)!=-1;
}

QStringList &PhonesClass::countries()
{
	return _countries;
}

QStringList &PhonesClass::prefixes()
{
	return _prefixes;
}

PhonesClass *PhonesClass::thisInstance(QString fname)
{
	if(!instPhones)
		instPhones = new PhonesClass(fname);
	return instPhones;
}

void PhonesClass::load(QString name)
{
	QFile f(name);
	QString line;
	printf("Loading: <%s>\n", (const char *)name);
	if ( f.open(IO_ReadOnly) )
	{
		QTextStream t( &f );
		while ( !t.eof() ) 
		{ 
			line=t.readLine();
			if(((const char *)line)[0]!=';')
				add(line);
		}
		f.close();
	}
	else
	{
		QMessageBox::warning(0,"Loading countries/phones...", QString("Could not find the file ")+name+
			".\nFailed loading countries/phones (database is empty).", QMessageBox::Ignore, 0);
	}
}

void PhonesClass::save(QString name)
{
	QFile f(name);
	if ( f.open(IO_WriteOnly) )
	{
		QTextStream t( &f );
		QString s;
		for(int i=0;i<countries().count();i++)
			t << prefixes()[i] << "," << countries()[i] << endl;
		f.close();
	}
	else
	{
		QMessageBox::warning(0,"Saving countries/phones...", QString("Could not open the file ")+name+
			".\nFailed saving countries/phones (old database).", QMessageBox::Ignore, 0);
	}
}

void PhonesClass::add(QString line)
{
	QStringList l=QStringList::split(",",line);
#ifdef DEBUG_PHONES
	printf("[%s] [%s]\n", (const char *)l[0], (const char *)l[1]);
#endif
	_countries.append(l[0].simplifyWhiteSpace());
	QString extra;
	if(l[1].find("+")==-1) extra="+";
	else extra="";
	_prefixes.append(extra+l[1].stripWhiteSpace());
}
