/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

#ifndef __CollectionManager__
#define __CollectionManager__

#include <qstring.h>
#include <qdict.h>
#include <datacollection.h>
#include <localmailfolder.h>

class CollectionManager
{
  public:
    CollectionManager();
    virtual ~CollectionManager();

    // data
    QDict<DataCollection> collectionDict;
    QDict<MailFolder> mailDict;
    QDict<MailFolder> remoteMailDict;

    // init methods
    /** Add the local and remote mail folders.*/
    void addMailFolders();
    /** Add the local mail folders.*/
    void addLocalMailFolders();
    /** Add the remote mail folders.*/
    void addRemoteMailFolders();
		void addSysMailFolders();
    void addSysContacts();
    void addSysGroups();
    void addSysNotes();
		void addBlockFolders();
		void addFileFolders();
		
    //void addJournals();
    //void addScheduler();
    //void addTasks();
    //void addToDos();
    //void addScripts();

    // object set methods
    QString reparentObject(QString &url, QString &dest_folder);
    QString reparentObjectCollection(QString &src_folder, QString &dest_folder);
    QStringList reparentObjectSet(QStringList &list, QString &dest_folder);

    // folder handling methods
    /** The client wants a new folder.*/
    QString createFolder(QStringList paramList);
    /** Create the server support for a new folder.*/
		QString createFolderStructure(QString baseName);
		/** The server wants a new folder.*/
		void createFolder(QString parent, QString folderPath, QString type, QString viewType);
		QString createBlockStructure(QString baseName);
		
		/** The server wants to delete a folder.*/
		void deleteFolder(QString parent, QString folderPath, QString type, QString viewType);
		/** Remove a folder.*/
		bool removeFolder(const QString &name);
		/** Remove a local mail folder.*/
		bool removeLocalMailFolder(const QString &name);
		/** Remove a remote mail folder and its local mirror.*/
		bool removeRemoteMailFolder(const QString &name);
		bool removeFileFolder(const QString &name);
		bool removeBlockDevice(const QString &name);
};

#endif





