/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

/*
 *		This file contains the class for importing outlook express files
 *	into Magellan. The API is quite simple: give it the file and you can 
 *	get all the messages at once or one message at a time if you want.
 */
#ifndef OUTLOOK_EXPRESS_H
	#define OUTLOOK_EXPRESS_H

#include <stdio.h>

#include <qstring.h>
#include <qvaluelist.h>
#include <qstringlist.h>

/**
 *		OutlookMessageHeader contains 5 fields as they are in the 
 *	.mbx file (inbox... or whatever). I have not bothered to seek 
 *	the meaning for all the fields. Only the fields which are helpful
 *	for message importing are considered here.
 */
class OutlookMessageHeader{
public:
	/*
	 *	Unknown field (some unknown information regarding the mail)
	 */
	unsigned char Unknown[4]; // 2 unsigned shorts probably
	/*
	 *	Message Number
	 */
	unsigned int MessageNumber;
	/*
	 *	Where I can find the next item's text
	 */
	unsigned int NextMessageText;
	/*
	 *	Next item begins @ this offset from the current position
	 */
	unsigned int NextItemOffset;
	/*
	 *	The start of the message is at this position from the file beginning
	 */
	long selfOffset;			
};

/*
 *	This is the class for reading messages out of the outlook express 
 * mailbox.
 */
class OutlookExpressImport
{
	QValueList<OutlookMessageHeader> messageHeaderList;
	FILE *f;
public:
	/*
	 *	Constructor.
	 *	@param filename the input file name.
	 */
	OutlookExpressImport(QString filename=QString::null);
	/*
	 *	Destructor
	 */
	~OutlookExpressImport();
	/*
	 *	Opens the file and reads the indexes out of it. It is a
	 * politically correct function: if a file is already open, it
	 * closes that file before opening the new one.
	 *	@param filename the input file name.
	 */
	void setFile(QString filename=QString::null);
	/*
	 *	Method for extracting one message out of the file. 
	 *	@param messageNo the message you want to be extracted
	 *	*WARNING* the first message has the index 1 not 0!
	 *	@return a QString containing the message.
	 */
	QString getMessage(int messageNo);
	/*
	 *	Method for getting all the messages out of the mailbox file
	 *	@return a QStringList containing all the messages.
	 */
	QStringList	getAllMessages();
	/*
	 *	Method for getting the size of the message about to be extracted. 
	 *	@param messageNo the message you want to be extracted
	 *	*WARNING* the first message has the index 1 not 0!
	 *	@return the message's size.
	 * 	Note: this is a cute and useful thing if you want to filter the maximum
	 * size allowed for an imported message without reading the message from the
	 * file.
	 */
	unsigned getMessageSize(int messageNo);
	/*
	 *	Method for getting the number of messages in the mailbox. 
	 */
	int getNumberOfMessages() { return 	messageHeaderList.count(); }
private:
	void readIndexes();
	bool checkHeader();
};

#endif








