/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

//#include <ctype.h>
#include <htmlprocessing.h>
#include <mimelib/mimepp.h>
#include <texthtml.h>
#include <metaformatcontrol.h>
#include <textprocessor.h>

#include <qdict.h>
#include <kconfig.h>

#define IDSTRING "TextHtmlConvertor: "

extern KConfig *GlobalConfig;


TextHtmlConvertor::TextHtmlConvertor()
{
	startPagesDict.setAutoDelete(true);
	endPagesDict.setAutoDelete(true);
	cssDict.setAutoDelete(true);
	beginHTMLDict.setAutoDelete(true);
	endHTMLDict.setAutoDelete(true);
	init();
}
void TextHtmlConvertor::init()
{
	GlobalConfig->setGroup("HTML Parser");
	seeText=(GlobalConfig->readEntry("Text olny")=="Yes");
	addressDetection=(GlobalConfig->readEntry("Web address detection","No")=="Yes");
	if(!GlobalConfig->hasKey("Max parsing size"))
		maxTextLength=8192;
	else
		maxTextLength=GlobalConfig->readNumEntry("Max parsing size");
	readReply();
	readWrote();
	readPages();
	readReplacements();
}

void TextHtmlConvertor::readReply()
{
#ifdef DEBUG_THC
	printf(IDSTRING"Reading reply tags...\n");
#endif
	GlobalConfig->setGroup("HTML Parser");
	replyBeginTag=GlobalConfig->readEntry("Reply begin tag");
	replyEndTag=GlobalConfig->readEntry("Reply end tag");
	replyMiddleTag=GlobalConfig->readEntry("Reply middle tag");
	replyTabulator=GlobalConfig->readEntry("Reply tabulator");
	replyDuplicateTabulator=(GlobalConfig->readEntry("Reply duplicate tabulator")=="Yes");
#ifdef DEBUG_THC
	printf("replyBeginTag : %s\n",(const char *)replyBeginTag);
	printf("replyEndTag : %s\n",(const char *)replyEndTag);
	printf("replyMiddleTag : %s\n",(const char *)replyMiddleTag);
	printf("replyTabulator : %s\n",(const char *)replyTabulator);
	printf("replyDuplicateTabulator : %d\n",replyDuplicateTabulator);
#endif
}

void TextHtmlConvertor::readWrote()
{
#ifdef DEBUG_THC
	printf(IDSTRING"Reading \"wrote:\" tags...\n");
#endif
	GlobalConfig->setGroup("HTML Parser");
	wroteBeginTag=GlobalConfig->readEntry("Wrote begin tag");
	wroteEndTag=GlobalConfig->readEntry("Wrote end tag");
}

void TextHtmlConvertor::readPages()
{
#ifdef DEBUG_THC
	printf(IDSTRING"Reading pages...\n");
#endif
	GlobalConfig->setGroup("HTML Parser");
	// set default page...
	QStrList templatePagesList;
	GlobalConfig->readListEntry("Template pages list", templatePagesList);
	// clear the old stuff
	startPagesDict.clear();
	endPagesDict.clear();
	if(templatePagesList.find("default")==-1)
	{
		startPagesDict.insert("default", new QString("<html><head>"
			"<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">"
			"<style type=\"text/css\"><!-- CSS --></style>"
			"</head>"
			"<body bgcolor=\"white\"><table width=\"100%\"><tr><td>"));
		endPagesDict.insert("default", new QString("</td></tr></table></body></html>"));
	}
	for(QStrListIterator it(templatePagesList); it.current(); ++it)
	{
		QString name=QString("Template page ")+(*it);
		if(GlobalConfig->hasGroup(name))
		{
			GlobalConfig->setGroup(name);
			startPagesDict.insert(name, new QString(GlobalConfig->readEntry("Begin HTML")));
			endPagesDict.insert(name, new QString(GlobalConfig->readEntry("End HTML")));
		}
	}
}

void TextHtmlConvertor::readReplacements()
{
#ifdef DEBUG_THC
	printf(IDSTRING"Reading replacements tags...\n");
#endif
	GlobalConfig->setGroup("HTML Parser");
	GlobalConfig->readListEntry("Active rules", activeRules);
	printf("ACTIVE RULES: %d\n",activeRules.count());
	for(QStrListIterator it(activeRules); it.current(); ++it)
	{
		QString name=QString("HTML Rule ")+(*it);
#ifdef DEBUG_THC
		printf("Gathering information for rule: [%s]\n",(const char *)name);
#endif
		if(GlobalConfig->hasGroup(name))
		{
			GlobalConfig->setGroup(name);
			beginHTMLDict.insert((*it), new QString(GlobalConfig->readEntry("Begin HTML")));
			endHTMLDict.insert((*it), new QString(GlobalConfig->readEntry("End HTML")));
		}
	}
}

void TextHtmlConvertor::updateReply(QString &buffer)
{
	QString chunk;
	int pos=0;
	while((pos=buffer.find("<reply",pos))!=-1)
	{
		int mark=pos;
		int p1=buffer.find(">",pos+6);
		int level=buffer.mid(pos+7, p1-pos-7).toInt();
		chunk=replyBeginTag;
		for(int i=0;i<level;i++)
			chunk +=replyTabulator;
		chunk += replyMiddleTag;
		pos=p1+1;
		p1=buffer.find("</reply>");
		chunk += buffer.mid(pos, p1-pos) + replyEndTag;
#ifdef DEBUG_THC
		printf("Reply : %d\n",level);
#endif
		pos=p1;
		buffer.replace(mark, pos+8-mark, chunk);
	}
}

void TextHtmlConvertor::updateGeneric(QString &buffer, QString tag, QString r1, QString r2)
{
	int pos=0;
	QString btag=QString("<")+tag+">";
	QString etag=QString("</")+tag+">";
#ifdef DEBUG_THC
	printf("Finding: %s and %s\n", (const char *)btag, (const char *)etag);
#endif
	while((pos=buffer.find(btag,pos))!=-1)
	{
		buffer.replace(pos, btag.length(), r1);
		pos=buffer.find(etag,pos+r1.length());
		if(pos!=-1)
			buffer.replace(pos, etag.length(), r2);
	}
}

void TextHtmlConvertor::updateWrote(QString &buffer)
{
	updateGeneric(buffer, "wrote", wroteBeginTag, wroteEndTag);
}

void TextHtmlConvertor::updateCustom(QString &buffer)
{
#ifdef DEBUG_THC
	printf(" Updating custom...\n");
	for(QStrListIterator it(activeRules); it.current(); ++it)
		printf("Active rules: [%s]\n", (const char *)(*it));
	printf("%d-----\n", activeRules.count());
#endif
	QString *b, *e;
	for(QStrListIterator it(activeRules); it.current(); ++it)
	{
		b=beginHTMLDict[(*it)];
		e=endHTMLDict[(*it)];
#ifdef DEBUG_THC
		printf(" Updating <%s> %p %p\n", (const char *)(*it), b, e);
#endif
		if(b && e)
			updateGeneric(buffer, (*it), *b, *e);
	}
}


void TextHtmlConvertor::text2html(QCString &str, QString tmpl)
{
  QString temp=str;
  text2html(temp,tmpl);
  str=temp;
}

void TextHtmlConvertor::text2html(QString &str, QString tmpl)
{
	QString name=(startPagesDict[tmpl]==0)?QString("default"):tmpl;
	/*
	 *	text.length()<=maxTextLength is a dumb hack for skipping html conversion
	 *	of the text for large messages.
	 */
	if(str.length()<=maxTextLength)
	{
		// first replace html tags...
		HtmlProcessor::thisInstance()->replaceHTMLTags(str);
		// metaformat what's left
		str=TextProcessor::metaFormat(str, *(MetaFormatControl::ref()));
	}

	
	if(str.length()<=maxTextLength)
	{
		// update the formatting
		if(MetaFormatControl::ref()->enableReplyTags || MetaFormatControl::ref()->enableBlockReplyTags)
			updateReply(str);
		if(MetaFormatControl::ref()->enableWroteSequence)
			updateWrote(str);
		if(MetaFormatControl::ref()->enableAnySequence)
			updateCustom(str);
	}
	str=str.simplifyWhiteSpace();
	// make the links
	if(addressDetection)
	{
		HtmlProcessor::thisInstance()->replaceURLs("http://",str);
		HtmlProcessor::thisInstance()->replaceURLs("ftp://",str);
		HtmlProcessor::thisInstance()->replaceURLs("ftp",str,"ftp://");
		HtmlProcessor::thisInstance()->replaceURLs("www",str,"http://");
		HtmlProcessor::thisInstance()->replaceURLs("mailto:", str, "", true);
		HtmlProcessor::thisInstance()->replaceEmails(str);
	}

	// do a preformatted?
	if(seeText || str.length()>maxTextLength)
		str.prepend("<pre>").append("</pre>");
	// put in the html tags
	str.prepend(*startPagesDict[name]).append(*endPagesDict[name]);
}

void TextHtmlConvertor::html2text(QCString &str)
{
  QString temp=str;
  html2text(temp);
  str=temp;
}

void TextHtmlConvertor::html2text(QString &str)
{
	HtmlProcessor::thisInstance()->eliminateComments(str);
	HtmlProcessor::thisInstance()->correctHTML(str);
	for(int i=0;i!=-1;)
	{
		i=str.find("<p>",i,false);
		if(i!=-1) str.replace(i,3,"\n\t");
	}
	for(int i=0;i!=-1;)
	{
		i=str.find("<br>",i,false);
		if(i!=-1) str.replace(i,4,"\n");
	}
	HtmlProcessor::thisInstance()->removeTags(str);
	HtmlProcessor::thisInstance()->removeHTMLTags(str);
}

void TextHtmlConvertor::html2html(QCString &str)
{
  QString temp=str;
  html2html(temp);
  str=temp;
}

void TextHtmlConvertor::html2html(QString &str)
{
	if(addressDetection && str.length()<=maxTextLength)
	{
		HtmlProcessor::thisInstance()->replaceURLs("http://",str);
		HtmlProcessor::thisInstance()->replaceURLs("ftp://",str);
		HtmlProcessor::thisInstance()->replaceURLs("ftp",str,"ftp://");
		HtmlProcessor::thisInstance()->replaceURLs("www",str,"http://");
		HtmlProcessor::thisInstance()->replaceURLs("mailto:",str);
		HtmlProcessor::thisInstance()->replaceEmails(str);
	}
}
