/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <kstddirs.h>

#include <qstringlist.h>
#include <qlineedit.h>
#include <qcombobox.h>
#include <qlabel.h>
#include <qwidget.h>
#include <qpixmap.h>

#include <stdio.h>

#include <prefixdialogbase.h>
#include <prefixdialog.h>
#include <phonesclass.h>

#define IDSTRING "PrefixDialog: "

PrefixDialog::PrefixDialog(QWidget *parent, const char *name) :
	PrefixDialogBase(parent, name, true)
{
	_number=_prefix=_area=QString::null;
	_fullNo=QString::null;
	sourcePhone=0;
	setCountries(PhonesClass::thisInstance(locate("appdata","idc-prefix.list"))->countries());
}

void PrefixDialog::setNumber(QString *item)
{
	_number=item->stripWhiteSpace();
	_fullNo=_number;
	sourcePhone=item;
	numberEdit->setText(_number);
}

void PrefixDialog::setArea(QString item)
{
	_area=item.stripWhiteSpace();
}

void PrefixDialog::setType(QPixmap item)
{
	typeLabel->setPixmap(item);
}

void PrefixDialog::setCountries(QStringList items)
{
	countriesBox->insertStringList(items);
}

void PrefixDialog::setCountry(QString item)
{
	_prefix=PhonesClass::thisInstance()->prefix(item);
	if(_prefix==QString::null)
		_prefix="";
	setNumber();
}

void PrefixDialog::areaChanged(const QString &item)
{
	_area=item.stripWhiteSpace();
	setNumber();
}

void PrefixDialog::cancelClicked()
{
	close();
}

void PrefixDialog::countrySelected(const QString &item)
{
	_prefix=PhonesClass::thisInstance()->prefix(item);
	QStringList ixes=QStringList::split("-",_prefix);
	if(ixes.count()==2)
	{
		_prefix=ixes[0];
		_area=ixes[1];
		prefixLabel->setText(ixes[0]);
		areaEdit->setText(ixes[1]+areaEdit->text());
	}
	else
	{
		prefixLabel->setText(_prefix);
	}
	setNumber();
}

void PrefixDialog::setNumber()
{
	if(_number.isEmpty())
		phoneNumberLabel->setText("Invalid phone number");
	else
		phoneNumberLabel->setText(buildNumbers());
}

void PrefixDialog::numberChanged(const QString &item)
{
	_number=item.stripWhiteSpace();
	setNumber();
}

void PrefixDialog::okClicked()
{
	_fullNo=buildNumbers();
	close();
	(*sourcePhone) = _fullNo;
}

QString PrefixDialog::buildNumbers()
{
	return QString(((!_prefix.isEmpty())?QString(_prefix+" "):QString("")) +
		((!_area.isEmpty())?QString("("+_area+") "):QString("")) + _number);
}

