/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

#ifndef __Has_CardDialogWidgetBase__
#define __Has_CardDialogWidgetBase__

#include <carddialogwidgetbase.h>

#include <businesswidget.h>
#include <personalwidget.h>
#include <summarywidgetbase.h>
#include <otherwidget.h>


#include <ebutton.h>
#include <contactobj.h>
#include <cardtileview.h>
#include <cardclasses.h>
#include <ataddressbook.h>
#include <templateview.h>

class CardPixmaps
{
	public:
		CardPixmaps();
		QPixmap &other(int);
		QPixmap &personal(int);
		QPixmap &summary(int);
		QPixmap &work(int);
		static CardPixmaps *thisInstance();
	private:
		QPixmap _other[3], _personal[3], _summary[3], _work[3];
		static CardPixmaps *cPixmaps;
		
};

class CardDialogWidget : public CardDialogWidgetBase, public TemplateView
{
	Q_OBJECT
	public:
		CardDialogWidget(ContactObject *contact, QWidget *parent=0, const char *name=0);
		void initGUI();
		void initFrames();
		ContactObject *card();
		void setSaved(bool *);
		void setCard(ContactObject *);
		void update() {};
	public slots:
		void buttonClicked(int);
		// All the slots for real actions
		void clearCard();
		void closeCard();
		void groupCard();
		void helpCard();
		void nextCard();
		void prevCard();
		void printCard();
		void saveCard();
		void saveCloseCard();
		void sendCard();
	protected slots:
    virtual void moveEvent(QMoveEvent *);
		void changed();
	signals:
		void newHeight(int);
	private:
		ContactObject *_card;
		EButton *other;
		EButton *personal;
		EButton *summary;
		EButton *work;
		
		bool uiChanged;
		BusinessWidget *_business;
		PersonalWidget *_personal;
		SummaryWidgetBase *_summary;
		OtherWidget *_other;
		
		CardOtherElements otherE;
		CardPersonalElements personalE;
		CardBusinessElements businessE;
		CardListEmails emailsE;
		QStringList urlE;
		QString titlesE, contentsE; // for "other"
	private:
		CardListPhones *setPhones(QStringList types, QStringList numbers, QString where);
		void setupSummary();
		void save();
};

#endif

