/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 */

/**
 * Changed by Eugen C. for speeding reasons.
 */

#include <vfolder.h>
#include <qstring.h>
#include <templateview.h>
#include <vobject.h>
#include <clientvfs.h>
#include <vreference.h>

VFolder::VFolder(QString _path):VReference()
{
	folderPath=_path;
	objectsDict.setAutoDelete(false);
	objectsList.setAutoDelete(false);
	folderCache=0;
}

VFolder::~VFolder()
{
	objectsList.setAutoDelete(true);
	objectsList.clear();
	objectsDict.setAutoDelete(true);
	objectsDict.clear();
}

QString VFolder::name()
{
	int k=folderPath.findRev("/");
	if(k>-1)
		return folderPath.mid(k+1);
	return QString::null;
}

QString VFolder::url()
{
	return folderType+":/"+folderPath;
}

QString VFolder::type()
{
	return folderType;
}

QString VFolder::viewType()
{
	return folderViewType;
}

QString VFolder::mimeType()
{
	return folderMimeType;
}

QString VFolder::binding()
{
	return folderBinding;
}

QString VFolder::path()
{
	return folderPath;
}

QString VFolder::serverPath()
{
	return folderSPath;
}

void VFolder::setBinding(QString t)
{
	folderBinding=t;
}

void VFolder::setServerPath(QString t)
{
	folderSPath=t;
}

void VFolder::setType(QString t)
{
	folderType=t;
}

void VFolder::setViewType(QString t)
{
	folderViewType=t;
}

void VFolder::setMimeType(QString t)
{
	folderMimeType=t;
}

QList<VObject>& VFolder::objectList()
{
	return objectsList;
}

QDict<VObject>& VFolder::objectDict()
{
  return objectsDict;
}

bool VFolder::isSimpleObject(const QString objectName) const
{
  return (!objectName.contains("attr") && !objectName.contains("cache"));
}

bool VFolder::addObject(VObject *obj)
{
	if( !objectsDict.find(obj->name()) )
	{
  	objectsDict.insert(obj->name(), obj);
  	objectsList.append(obj);

  	if(obj->name()=="dir.cache")
  		folderCache=(VCacheObject *)obj;

  	return true;
	}
	else
	  return false;
}

bool VFolder::addObject(QString id)
{
	if( !objectsDict.find(id) )
	{
  	VObject *obj=ClientVFS::thisInstance()->template _new<VObject>(folderPath+"/"+id);
  	return obj?true:false;
	}
	else
	  return false;
}

bool VFolder::removeObject(VObject *obj)
{
	if((VCacheObject *)obj==folderCache) folderCache=0;
	if( objectsDict.remove(obj->name()) &&
	    objectsList.removeRef(obj) )
	{
	  delete obj;
	  return true;
	}
	else
	  return false;
}

bool VFolder::removeObjectRef(VObject *obj)
{
	if((VCacheObject *)obj==folderCache) folderCache=0;
	if( objectsDict.remove(obj->name()) &&
	    objectsList.removeRef(obj) )
	  return true;
	else
	  return false;
}

bool VFolder::removeObject(QString id)
{
  VObject *obj=objectsDict.find(id);
	if( !obj )
	  return false;
	else
	  return removeObject(obj);
}

VCacheObject *VFolder::entryCacheBlock()
{
	return folderCache;
}

QString VFolder::flags()
{
	return folderFlags;
}

void VFolder::setFlags(const QString &newFlags)
{
	folderFlags=newFlags;
}



