/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#ifndef __NoteObject__
#define __NoteObject__

#include <clientvfs.h>
#include <qstring.h>
#include <qfont.h>
#include <qsize.h>
#include <qpoint.h>
#include <qdatetime.h>
#include <vobject.h>
#include <vobjectfactory.h>
#include <qvariant.h>
#include <queryprocessor.h>

// the note object class

class NoteObject : public VObject
{
	// always include ClientVFS as a friend class, since we use the _new or _ref ClientVFS template methods
	// to create any kind of VObjects
	friend class ClientVFS;
	protected:
		// the contructor is always protected or private
		NoteObject(QString _path);
		NoteObject(QString _path, QByteArray &_data);
	public:
		// the destructor
		~NoteObject();
	
		// get and set methods for internal properties; we'll save the object every time we change a property
		void setText(QString);
		QString text();
		void setFont(QFont);
		QFont font();
		void setPosition(QPoint);
		QPoint position();
		void setSize(QSize);
		QSize size();
		void setColor(QString);
		QString color(); // we get to choose between "yellow", "red", "blue" and "green"
		void setTime(QDateTime);
		QDateTime time();
		void setCategory(QString);
		QString category();
		int onDisplay();
		void setOnDisplay(int);
		
		// object marshalling methods (overloaded from VObject, so that save() and sync() work)
		QByteArray _stream();
		void _narrow(const QByteArray &);
		
		// query handling
		virtual bool getProperty(const QString &query, Any &property);
		virtual bool setProperty(const QString &query, Any &property);
		virtual QueryProcessor::QueryType queryType(const QString &query);
	private:
		// internal data
		int _onDisplay;
		QSize _size;
		QPoint _position;
		QString _text;
		QFont _font;
		QString _color;
		QDateTime _time;
		QString _category;
		QByteArray _extraData; // future fields
};

// the note object factory

class NoteObjectFactory : public VObjectFactory
{
	public:
		NoteObject *_new(QString _path, QByteArray &_data);
		NoteObject *_new(QString _path);
};

#endif
