/*
 * This file is part of Magellan <http://www.kAlliance.org/Magellan>
 *
 * Copyright (c) 1998-2000 Teodor Mihai <teddy@ireland.com>
 * Copyright (c) 1998-2000 Laur Ivan <laur.ivan@ul.ie>
 * Copyright (c) 1999-2000 Virgil Palanciuc <vv@ulise.cs.pub.ro>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 * Also requires the KDE libraries, available at no cost at
 * http://www.kde.org/
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell 
 * copies of the Software, and to permit persons to whom the Software is 
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in 
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE 
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS 
 * IN THE SOFTWARE.
 */

#include <contactobj.h>
#include <clientvfs.h>
#include <qstring.h>
#include <qsize.h>
#include <qpoint.h>
#include <qfont.h>
#include <vobject.h>
#include <kconfig.h>
#include <qdatastream.h>
#include <qcstring.h>
#include <vobjectfactory.h>
#include <queryprocessor.h>
#include <qvariant.h>
#include <metaobject.h>
#include <miscfunctions.h>

/*
	#define MORE_SECURE
*/

#define IDSTRING "ContactObject: "

// #define DEBUG_CO

extern KConfig *GlobalConfig;

// implementation for the contact object

ContactObject::ContactObject(QString _path) : VObject(_path)
{
#ifdef DEBUG_CO
	printf(IDSTRING"constructor: syncing object...\n");
#endif	
	// restore the object properties from the server
  sync();
	
#ifdef DEBUG_CO
	printf(IDSTRING"contructor: done\n");
#endif
}

ContactObject::ContactObject(QString _path, QByteArray &_data) : VObject(_path)
{
#ifdef DEBUG_CO
	printf(IDSTRING"constructor: syncing object...\n");
#endif	
	// restore the object properties from the server
	if( !_data || !_data.size() )
	  sync();
	else
	  _narrow(_data);
	
#ifdef DEBUG_CO
	printf(IDSTRING"contructor: done\n");
#endif
}

ContactObject::~ContactObject()
{
	// nothing here
}

/***************************************************************************/
/*  Methods for setting/getting the stuff off the object                   */
/***************************************************************************/

unsigned long ContactObject::convertPhoneType(QString type)
{
	unsigned long result=ContactObject::Work | ContactObject::Normal | ContactObject::Voice;
	if(type.find("home",0,false)!=-1) 	result|=ContactObject::Home;
	if(type.find("pref",0,false)!=-1) 	result|=ContactObject::Pref;
	if(type.find("msg",0,false)!=-1) 		result|=ContactObject::Msg;
	if(type.find("fax",0,false)!=-1) 		result|=ContactObject::Fax;
	if(type.find("cell",0,false)!=-1) 	result|=ContactObject::Cell;
	if(type.find("pager",0,false)!=-1) 	result|=ContactObject::Pager;
	if(type.find("bbs",0,false)!=-1) 		result|=ContactObject::Bbs;
	if(type.find("modem",0,false)!=-1) 	result|=ContactObject::Modem;
	if(type.find("car",0,false)!=-1) 		result|=ContactObject::Car;
	if(type.find("isdn",0,false)!=-1) 	result|=ContactObject::Isdn;
	if(type.find("pcs",0,false)!=-1) 		result|=ContactObject::Pcs;
	if(type.find("video",0,false)!=-1) 	result|=ContactObject::Video;
	return result;
}

void ContactObject::setCategory(QString newCategory)
{
	_category=newCategory;
}

QString ContactObject::category()
{
	return _category;
}

void ContactObject::setFn(QString newFn)
{
	_fn=newFn;
#ifdef MORE_SECURE
	save();
#endif
}
QString ContactObject::fn()
{
	return _fn;
}
void ContactObject::setN(QStringList newN)
{
	_n=newN;
#ifdef MORE_SECURE
	save();
#endif
}
QStringList ContactObject::n()
{
	return _n;
}
void ContactObject::setHomeAdr(QStringList newHomeAdr)
{
	_homeAdr=newHomeAdr;
#ifdef MORE_SECURE
	save();
#endif
}
QStringList ContactObject::homeAdr()
{
	return _homeAdr;
}
void ContactObject::setPhone(QStringList newPhone)
{
#ifdef DEBUG_CO
	printf("------------------- %d phones\n", newPhone.count());
#endif
	_phone=newPhone;
#ifdef MORE_SECURE
	save();
#endif
}
QStringList ContactObject::phone()
{
	return _phone;
}
void ContactObject::setPhoneType(QStringList newPhoneType)
{
	_phoneType=newPhoneType;
#ifdef MORE_SECURE
	save();
#endif
}
QStringList ContactObject::phoneType()
{
	return _phoneType;
}
void ContactObject::setWorkAdr(QStringList newWorkAdr)
{
	_workAdr=newWorkAdr;
#ifdef MORE_SECURE
	save();
#endif
}
QStringList ContactObject::workAdr()
{
	return _workAdr;
}
void ContactObject::setEmails(QStringList newEmails)
{
	_emails=newEmails;
#ifdef MORE_SECURE
	save();
#endif
}
QStringList ContactObject::emails()
{
	return _emails;
}
void ContactObject::setDefaultEmail(int newDefaultMail)
{
	_defaultEmail=newDefaultMail;
#ifdef MORE_SECURE
	save();
#endif
}
int ContactObject::defaultEmail()
{
	return _defaultEmail;
}
void ContactObject::setNotes(QString newNotes)
{
	_notes=newNotes;
#ifdef MORE_SECURE
	save();
#endif
}
QString ContactObject::notes()
{
	return _notes;
}
void ContactObject::setURLs(QStringList newURLs)
{
	_URLs=newURLs;
#ifdef MORE_SECURE
	save();
#endif
}
QStringList ContactObject::URLs()
{
	return _URLs;
}
void ContactObject::setNick(QString newNick)
{
	_nick=newNick;
#ifdef MORE_SECURE
	save();
#endif
}
QString ContactObject::nick()
{
	return _nick;
}

void ContactObject::setSecurity(int newSecurity)
{
	_security=newSecurity;
}
int ContactObject::security()
{
	return _security;
}
void ContactObject::setBday(QString newBdate)
{
	_bday=newBdate;
#ifdef MORE_SECURE
	save();
#endif
}
QString ContactObject::bday()
{
	return _bday;
}
void ContactObject::setOrg(QString newOrg)
{
	_org=newOrg;
#ifdef MORE_SECURE
	save();
#endif
}
QString ContactObject::org()
{
	return _org;
}
void ContactObject::setTitle(QString newTitle)
{
	_title=newTitle;
#ifdef MORE_SECURE
	save();
#endif
}
QString ContactObject::title()
{
	return _title;
}
void ContactObject::setRole(QString newPos)
{
	_role=newPos;
#ifdef MORE_SECURE
	save();
#endif
}
QString ContactObject::role()
{
	return _role;
}
void ContactObject::setCategories(QString newPos)
{
	_categories=newPos;
#ifdef MORE_SECURE
	save();
#endif
}
QString ContactObject::categories()
{
	return _categories;
}
void ContactObject::setClassCard(QString newPos)
{
	_classCard=newPos;
#ifdef MORE_SECURE
	save();
#endif
}
QString ContactObject::classCard()
{
	return _classCard;
}

/* This method is for importing vcards version 2.x */

void ContactObject::setVcard2(QString import)
{
#ifdef DEBUG_CO
	printf(IDSTRING"Entering the importing function...\n");
#endif
	MetaObject mObj(import);
#ifdef DEBUG_CO
	printf(IDSTRING"Done the metaobject\n");
#endif
	if(mObj.query("FN").count()!=0)
		_fn=mObj["FN"].getContent();
#ifdef DEBUG_CO
	printf(IDSTRING"Done the _fn\n");
#endif
	QStringList tempList;
	QString tempString;
	QValueList<int> matches;
	bool oneAddress=false;
	/**
	 * getting all the emails...
	 */
	matches=mObj.query("EMAIL","internet");
	tempList.clear();
	for(int i=0;i<matches.count();i++)
		tempList.append(mObj.getLines().at(matches[i])->getContent());
	_emails=tempList;
#ifdef DEBUG_CO
	printf(IDSTRING"Done the _emails\n");
#endif
	matches=mObj.query("EMAIL","internet;pref");
	_defaultEmail=0;
	if(matches.count())
	{
		tempString=mObj.getLines().at(matches[0])->getContent();
		for(int i=0;i<_emails.count();i++)
			if(_emails[i]==tempString)
			{
				_defaultEmail=i;
				i=_emails.count();
			}
	}
#ifdef DEBUG_CO
	printf(IDSTRING"Done the _defaultEmail\n");
#endif
	/**
	 *	getting the name...
	 */
	if(mObj.query("N").count()!=0)
		tempList=split(mObj["N"].getContent(),';');
#ifdef DEBUG_CO
	printf(IDSTRING"Done the _n split %d\n", tempList.count());
#endif
	// NAME
	if(tempList.count()>0) _n.append(tempList[0]);
	else _n.append("");
	// FAMILY NAME
	if(tempList.count()>1) _n.append(tempList[1]);
	else _n.append("");
	// ADDITIONAL NAMES (INITIAL)
	if(tempList.count()>2) _n.append(tempList[2]);
	else _n.append("");
	// HONOR PREFIXES
	if(tempList.count()>3) _n.append(tempList[3]);
	else _n.append("");
	// HONOR SUFFIXES
	if(tempList.count()>4) _n.append(tempList[4]);
	else _n.append("");
#ifdef DEBUG_CO
	printf(IDSTRING"Done the _n\n");
#endif
	/**
	 *	getting the title...
	 */
	if(mObj.query("title").count()!=0)
		_title=mObj["title"].getContent();
#ifdef DEBUG_CO
	printf(IDSTRING"Done the _title\n");
#endif
	/**
	 *	getting the URLs...
	 */
	matches=mObj.query("url");
	_URLs.clear();
	for(int i=0;i<matches.count();i++)
		_URLs.append(mObj.getLines().at(matches[i])->getContent());
#ifdef DEBUG_CO
	printf(IDSTRING"Done the _URLs\n");
#endif
	/**
	 *	getting the class...
	 */
	tempString="";
	if(mObj.query("class").count()!=0)
		tempString=mObj["class"].getContent();
	if(	(tempString.find("private",0,false)==-1) && 
			(tempString.find("public",0,false)==-1) &&
			(tempString.find("confidential",0,false)==-1))
		tempString="PRIVATE";
	 _classCard=tempString;
#ifdef DEBUG_CO
	printf(IDSTRING"Done the _class\n");
#endif
	/**
	 * getting the note
	 */
	_notes=QString::null;
	if(mObj.query("note").count()!=0)
		_notes=mObj["note"].getContent();
#ifdef DEBUG_CO
	printf(IDSTRING"Done the _notes\n");
#endif
	/**
	 * getting the categories
	 */
	_categories=QString::null;
	if(mObj.query("categories").count()!=0)
		_categories=mObj["cetegories"].getContent();
#ifdef DEBUG_CO
	printf(IDSTRING"Done the _categories\n");
#endif
	/**
	 * getting the org
	 */
	_org=QString::null;
	if(mObj.query("org").count()!=0)
		_org=mObj["org"].getContent();
#ifdef DEBUG_CO
	printf(IDSTRING"Done the _org\n");
#endif
	/**
	 * getting the role
	 */
	_role=QString::null;
	if(mObj.query("role").count()!=0)
		_role=mObj["role"].getContent();
	printf(IDSTRING"Done the _role\n");
	/**
	 * getting the nick
	 */
	_nick=QString::null;
	if(mObj.query("nickname").count()!=0)
		_nick=mObj["nickname"].getContent();
#ifdef DEBUG_CO
	printf(IDSTRING"Done the _nick\n");
#endif
	/**
	 * getting the bday
	 */
	_bday=QString::null;
	if(mObj.query("bday").count()!=0)
		_bday=mObj["bday"].getContent();
#ifdef DEBUG_CO
	printf(IDSTRING"Done the _bday\n");
#endif
	/**
	 * getting the home address
	 */
	matches=mObj.query("adr","home");
	printf(IDSTRING"Mathces for home address: %d\n", matches.count());
	if(!matches.count())
	{
		matches=mObj.query("adr");
		oneAddress=true;
#ifdef DEBUG_CO
		printf(IDSTRING"One address................\n");
#endif
	}
#ifdef DEBUG_CO
	printf(IDSTRING"Done the _adrHome search\n");
#endif
	if(matches.count())
	{
		// doing the address...
		tempList=split(mObj.getLines().at(matches[0])->getContent(),';');
		switch(tempList.count())
		{
			case 7:
				_homeAdr=tempList;
				break;
			case 1:
				_homeAdr.clear();
				_homeAdr.append("");
				_homeAdr.append("");
				_homeAdr.append(tempList[0]);
				_homeAdr.append("");
				_homeAdr.append("");
				_homeAdr.append("");
				_homeAdr.append("");
				break;
			default:
				_homeAdr=tempList;
				for(int i=0;i<7-tempList.count();i++)
					_homeAdr.append("");
		}
	}
	else
		printf("ContactObject: No address associated with this card (home)\n");
#ifdef DEBUG_CO
	printf(IDSTRING"Done the _adrHome\n");
#endif
	/**
	 * getting the work address
	 */
	matches=mObj.query("adr","work");
	if(!matches.count())
	{
		matches=mObj.query("adr");
		oneAddress=true;
	}
#ifdef DEBUG_CO
	printf(IDSTRING"Done the _adrWork search\n");
#endif
	if(matches.count() && oneAddress)
		_workAdr=_homeAdr;
	if(matches.count() && !oneAddress)
	{
		// doing the address...
		tempList=split(mObj.getLines().at(matches[0])->getContent(),';');
		switch(tempList.count())
		{
			case 7:
				_workAdr=tempList;
				break;
			case 1:
				_workAdr.clear();
				_workAdr.append("");
				_workAdr.append("");
				_workAdr.append(tempList[0]);
				_workAdr.append("");
				_workAdr.append("");
				_workAdr.append("");
				_workAdr.append("");
				break;
			default:
				_workAdr=tempList;
				for(int i=0;i<7-tempList.count();i++)
					_workAdr.append("");
		}
	}
	else
		printf("ContactObject: No address associated with this card (work)\n");
#ifdef DEBUG_CO
	printf(IDSTRING"Done the _adrWork\n");
#endif
	/**
	 *	getting the home phone & type
	 */
	_phone.clear();
	_phoneType.clear();
	matches=mObj.query("tel");
	for(int i=0;i<matches.count();i++)
	{
		_phone.append(mObj.getLines().at(matches[i])->getContent());
		if(mObj.getLines().at(matches[i])->getQuality())
		{
			QString result=mObj.getLines().at(matches[i])->getQuality()->recompose();
			_phoneType.append(join(split(result,';'),","));
		}
		else
			_phoneType.append("HOME,WORK,VOICE");
	}
#ifdef DEBUG_CO
	printf(IDSTRING"Done the _phones\n");
#endif
#ifdef MORE_SECURE
	save();
#endif
}

QString ContactObject::vcard2()
{
	QString result="BEGIN:VCARD\n";
	result.append("VERSION:2.1\n");
	result.append(QString("FN:")+fn()+"\n");
	result.append(QString("N:")+join(n(),";")+"\n");
	result.append(QString("ADR:HOME;")+join(homeAdr(),";")+"\n");
	result.append(QString("ADR:WORK;")+join(workAdr(),";")+"\n");
	if(!notes().isEmpty()) result.append(QString("NOTE:")+notes()+"\n");
	if(!nick().isEmpty()) result.append(QString("NICKNAME:")+nick()+"\n");
	if(!bday().isEmpty()) result.append(QString("BDAY:")+bday()+"\n");
	if(!org().isEmpty()) result.append(QString("ORG:")+org()+"\n");
	if(!title().isEmpty()) result.append(QString("TITLE:")+title()+"\n");
	if(!role().isEmpty()) result.append(QString("ROLE:")+role()+"\n");
	if(!classCard().isEmpty()) result.append(QString("CLASS:")+classCard()+"\n");
	if(!categories().isEmpty()) result.append(QString("CATEGORIES:")+categories()+"\n");
	//default email...
	if(emails().count()!=0)
	{
		result.append(QString("EMAIL:PREF;INTERNET")+emails()[defaultEmail()]+"\n");
	}
	// the other emails
	for(int i=0;i<emails().count();i++)
		if(i!=defaultEmail()) result.append(QString("EMAIL:TYPE=PREF")+emails()[i]+"\n");
	// now the fones...
	for(int i=0;i<phone().count();i++)
	{
		result.append(QString("TEL:")+join(split(phoneType()[i],','),";")+";"+phone()[i]+"\n");
	}
	result.append("END:VCARD");
	return result;
}

void ContactObject::setVcard3(QString import)
{
#ifdef DEBUG_CO
	printf(IDSTRING"Entering the importing function...\n");
#endif
	MetaObject mObj(import);
#ifdef DEBUG_CO
	printf(IDSTRING"Done the metaobject\n");
#endif
	if(mObj.query("FN").count()!=0)
		_fn=mObj["FN"].getContent();
	printf(IDSTRING"Done the _fn\n");
	QStringList tempList;
	QString tempString;
	QValueList<int> matches;
	bool oneAddress=false;
	/**
	 * getting all the emails...
	 */
	matches=mObj.query("EMAIL","TYPE=internet");
	tempList.clear();
	for(int i=0;i<matches.count();i++)
		tempList.append(mObj.getLines().at(matches[i])->getContent());
	_emails=tempList;
#ifdef DEBUG_CO
	printf(IDSTRING"Done the _emails\n");
#endif
	matches=mObj.query("EMAIL","TYPE=internet,pref");
	_defaultEmail=0;
	if(matches.count())
	{
		tempString=mObj.getLines().at(matches[0])->getContent();
		for(int i=0;i<_emails.count();i++)
			if(_emails[i]==tempString)
			{
				_defaultEmail=i;
				i=_emails.count();
			}
	}
#ifdef DEBUG_CO
	printf(IDSTRING"Done the _defaultEmail\n");
#endif
	/**
	 *	getting the name...
	 */
	if(mObj.query("N").count()!=0)
		tempList=split(mObj["N"].getContent(),';');
#ifdef DEBUG_CO
	printf(IDSTRING"Done the _n split %d\n", tempList.count());
#endif
	// NAME
	if(tempList.count()>0) _n.append(tempList[0]);
	else _n.append("");
	// FAMILY NAME
	if(tempList.count()>1) _n.append(tempList[1]);
	else _n.append("");
	// ADDITIONAL NAMES (INITIAL)
	if(tempList.count()>2) _n.append(tempList[2]);
	else _n.append("");
	// HONOR PREFIXES
	if(tempList.count()>3) _n.append(tempList[3]);
	else _n.append("");
	// HONOR SUFFIXES
	if(tempList.count()>4) _n.append(tempList[4]);
	else _n.append("");
#ifdef DEBUG_CO
	printf(IDSTRING"Done the _n\n");
#endif
	/**
	 *	getting the title...
	 */
	if(mObj.query("title").count()!=0)
		_title=mObj["title"].getContent();
#ifdef DEBUG_CO
	printf(IDSTRING"Done the _title\n");
#endif
	/**
	 *	getting the URLs...
	 */
	matches=mObj.query("url");
	_URLs.clear();
	for(int i=0;i<matches.count();i++)
		_URLs.append(mObj.getLines().at(matches[i])->getContent());
#ifdef DEBUG_CO
	printf(IDSTRING"Done the _URLs\n");
#endif
	/**
	 *	getting the class...
	 */
	tempString="";
	if(mObj.query("class").count()!=0)
		tempString=mObj["class"].getContent();
	if(	(tempString.find("private",0,false)==-1) && 
			(tempString.find("public",0,false)==-1) &&
			(tempString.find("confidential",0,false)==-1))
		tempString="PRIVATE";
	 _classCard=tempString;
#ifdef DEBUG_CO
	printf(IDSTRING"Done the _class\n");
#endif
	/**
	 * getting the note
	 */
	_notes=QString::null;
	if(mObj.query("note").count()!=0)
		_notes=mObj["note"].getContent();
#ifdef DEBUG_CO
	printf(IDSTRING"Done the _notes\n");
#endif
	/**
	 * getting the categories
	 */
	_categories=QString::null;
	if(mObj.query("categories").count()!=0)
		_categories=mObj["cetegories"].getContent();
#ifdef DEBUG_CO
	printf(IDSTRING"Done the _categories\n");
#endif
	/**
	 * getting the org
	 */
	_org=QString::null;
	if(mObj.query("org").count()!=0)
		_org=mObj["org"].getContent();
#ifdef DEBUG_CO
	printf(IDSTRING"Done the _org\n");
#endif
	/**
	 * getting the role
	 */
	_role=QString::null;
	if(mObj.query("role").count()!=0)
		_role=mObj["role"].getContent();
#ifdef DEBUG_CO
	printf(IDSTRING"Done the _role\n");
#endif
	/**
	 * getting the nick
	 */
	_nick=QString::null;
	if(mObj.query("nickname").count()!=0)
		_nick=mObj["nickname"].getContent();
#ifdef DEBUG_CO
	printf(IDSTRING"Done the _nick\n");
#endif
	/**
	 * getting the bday
	 */
	_bday=QString::null;
	if(mObj.query("bday").count()!=0)
		_bday=mObj["bday"].getContent();
#ifdef DEBUG_CO
	printf(IDSTRING"Done the _bday\n");
#endif
	/**
	 * getting the home address
	 */
	matches=mObj.query("adr","TYPE=home");
#ifdef DEBUG_CO
	printf(IDSTRING"Mathces for home address: %d\n", matches.count());
#endif
	if(!matches.count())
	{
		matches=mObj.query("adr");
		oneAddress=true;
#ifdef DEBUG_CO
		printf(IDSTRING"One address................\n");
#endif
	}
#ifdef DEBUG_CO
	printf(IDSTRING"Done the _adrHome search\n");
#endif
	if(matches.count())
	{
		// doing the address...
		tempList=split(mObj.getLines().at(matches[0])->getContent(),';');
		switch(tempList.count())
		{
			case 7:
				_homeAdr=tempList;
				break;
			case 1:
				_homeAdr.clear();
				_homeAdr.append("");
				_homeAdr.append("");
				_homeAdr.append(tempList[0]);
				_homeAdr.append("");
				_homeAdr.append("");
				_homeAdr.append("");
				_homeAdr.append("");
				break;
			default:
				_homeAdr=tempList;
				for(int i=0;i<7-tempList.count();i++)
					_homeAdr.append("");
		}
	}
	else
		printf("ContactObject: No address associated with this card (home)\n");
#ifdef DEBUG_CO
	printf(IDSTRING"Done the _adrHome\n");
#endif
	/**
	 * getting the work address
	 */
	matches=mObj.query("adr","TYPE=work");
	if(!matches.count())
	{
		matches=mObj.query("adr");
		oneAddress=true;
	}
#ifdef DEBUG_CO
	printf(IDSTRING"Done the _adrWork search\n");
#endif
	if(matches.count() && oneAddress)
		_workAdr=_homeAdr;
	if(matches.count() && !oneAddress)
	{
		// doing the address...
		tempList=split(mObj.getLines().at(matches[0])->getContent(),';');
		switch(tempList.count())
		{
			case 7:
				_workAdr=tempList;
				break;
			case 1:
				_workAdr.clear();
				_workAdr.append("");
				_workAdr.append("");
				_workAdr.append(tempList[0]);
				_workAdr.append("");
				_workAdr.append("");
				_workAdr.append("");
				_workAdr.append("");
				break;
			default:
				_workAdr=tempList;
				for(int i=0;i<7-tempList.count();i++)
					_workAdr.append("");
		}
	}
	else
		printf("ContactObject: No address associated with this card (work)\n");
#ifdef DEBUG_CO
	printf(IDSTRING"Done the _adrWork\n");
#endif
	/**
	 *	getting the home phone & type
	 */
	_phone.clear();
#ifdef DEBUG_CO
	printf(IDSTRING"clearing phones done.\n");
#endif
	_phoneType.clear();
#ifdef DEBUG_CO
	printf(IDSTRING"clearing phoneTypes done.\n");
#endif
	matches=mObj.query("tel");
#ifdef DEBUG_CO
	printf(IDSTRING"Query done. (%d)\n", matches.count());
#endif
	for(int i=0;i<matches.count();i++)
	{
		_phone.append(mObj.getLines().at(matches[i])->getContent());
		if(mObj.getLines().at(matches[i])->getQuality())
		{
			QString result=mObj.getLines().at(matches[i])->getQuality()->recompose();
			_phoneType.append(join(split(result,';'),","));
		}
		else
			_phoneType.append("HOME,WORK,VOICE");
	}
#ifdef DEBUG_CO
	printf(IDSTRING"Done the _phones\n");
#endif
#ifdef MORE_SECURE
	save();
#endif
}
QString ContactObject::vcard3()
{
	QString result="BEGIN:VCARD\n";
	result.append("VERSION:3.0\n");
	result.append(QString("FN:")+fn()+"\n");
	result.append(QString("N:")+join(n(),";")+"\n");
	result.append(QString("ADR:TYPE=HOME;")+join(homeAdr(),";")+"\n");
	result.append(QString("ADR:TYPE=WORK;")+join(workAdr(),";")+"\n");
	if(!notes().isEmpty()) result.append(QString("NOTE:")+notes()+"\n");
	if(!nick().isEmpty()) result.append(QString("NICKNAME:")+nick()+"\n");
	if(!bday().isEmpty()) result.append(QString("BDAY:")+bday()+"\n");
	if(!org().isEmpty()) result.append(QString("ORG:")+org()+"\n");
	if(!title().isEmpty()) result.append(QString("TITLE:")+title()+"\n");
	if(!role().isEmpty()) result.append(QString("ROLE:")+role()+"\n");
	if(!classCard().isEmpty()) result.append(QString("CLASS:")+classCard()+"\n");
	if(!categories().isEmpty()) result.append(QString("CATEGORIES:")+categories()+"\n");
	//default email...
	if(emails().count()!=0)
	{
		result.append(QString("EMAIL:TYPE=PREF,INTERNET")+emails()[defaultEmail()]+"\n");
	}
	// the other emails
	for(int i=0;i<emails().count();i++)
		if(i!=defaultEmail()) result.append(QString("EMAIL:TYPE=PREF")+emails()[i]+"\n");
	// now the fones...
	for(int i=0;i<phone().count();i++)
	{
		result.append(QString("TEL:TYPE=")+phoneType()[i]+";"+phone()[i]+"\n");
	}
	result.append("END:VCARD");
	return result;
}

QStringList ContactObject::relatedObjectList()
{
	return _relatedObjectList;
}

void ContactObject::setRelatedObjectList(const QStringList &newRelatedObjectList)
{
	_relatedObjectList=newRelatedObjectList;
}

QByteArray ContactObject::_stream()
{
	QByteArray tdata;
	QDataStream tstream(tdata, IO_WriteOnly);
	
	/*
	 * stream the object properties
	 */
	tstream<<_fn<<_n
					<<_homeAdr<<_workAdr<<_phone<<_phoneType
					<<_emails<<_defaultEmail
					<<_notes<<_URLs<<_nick<<_security
					<<_bday<<_org<<_title<<_role<<_classCard<<_categories<<_category
					<<_relatedObjectList<<_extraData;
	
	// return the byte array
	return tdata;
}

void ContactObject::_narrow(const QByteArray &tdata)
{
	// check if the stream actually contains any data
	if(tdata.size())
	{
		QDataStream tstream(tdata, IO_ReadOnly);

		// unstream the object properties
		tstream>>_fn>>_n
					>>_homeAdr>>_workAdr>>_phone>>_phoneType
					>>_emails>>_defaultEmail
					>>_notes>>_URLs>>_nick>>_security
					>>_bday>>_org>>_title>>_role>>_classCard>>_categories>>_category
					>>_relatedObjectList>>_extraData;

		printf(IDSTRING"Object read : %d\n",tdata.size());
	}
	else
	{
		_fn="";
		_n=QStringList();
		_homeAdr=QStringList();
		_workAdr=QStringList();
		_phone=QStringList();
		_phoneType=QStringList();
		_emails=QStringList();
		_defaultEmail=-1;
		_security=Private;
		_notes="";
		_URLs=QStringList();
		_nick ="";
		_bday = _org = _title = _role = _classCard = _categories = _category = "";
		printf(IDSTRING"Empty object!\n");
	}
}

bool ContactObject::getProperty(const QString &query, Any &property)
{
	if(query=="fn")
	{
		property=Any(_fn);
		return true;
	}
	if(query=="n")
	{
		property=Any(_n);
		return true;
	}
	if(query=="homeAddr")
	{
		property=Any(_homeAdr);
		return true;
	}
	if(query=="phone")
	{
		property=Any(_phone);
		return true;
	}
	if(query=="phoneType")
	{
		property=Any(_phoneType);
		return true;
	}
	if(query=="workAddr")
	{
		property=Any(_workAdr);
		return true;
	}
	if(query=="emails")
	{
		property=Any(_emails);
		return true;
	}
	if(query=="defaultEmail")
	{
		property=Any(_defaultEmail);
		return true;
	}
	if(query=="notes")
	{
		property=Any(_notes);
		return true;
	}
	if(query=="url")
	{
		property=Any(_URLs);
		return true;
	}
	if(query=="nick")
	{
		property=Any(_nick);
		return true;
	}
	if(query=="security")
	{
		property=Any(_security);
		return true;
	}
	if(query=="bdate")
	{
		property=Any(_bday);
		return true;
	}
	if(query=="org")
	{
		property=Any(_org);
		return true;
	}
	if(query=="title")
	{
		property=Any(_title);
		return true;
	}
	if(query=="role")
	{
		property=Any(_role);
		return true;
	}
	if(query=="class")
	{
		property=Any(_classCard);
		return true;
	}
	if(query=="categories")
	{
		property=Any(_categories);
		return true;
	}
	if(query=="category")
	{
		property=Any(_category);
		return true;
	}
	if(query=="relatedObjectList")
	{
		property=Any(_relatedObjectList);
		return true;
	}
	return false;
}

bool ContactObject::setProperty(const QString &query, Any &property)
{
	if(query=="fn")
	{
		_fn=property.toString();
		return true;
	}
	if(query=="n")
	{
		_n=property.toStringList();
		return true;
	}
	if(query=="homeAddr")
	{
		_homeAdr=property.toString();
		return true;
	}
	if(query=="phone")
	{
		_phone=property.toStringList();
		return true;
	}
	if(query=="phoneType")
	{
		_phoneType=property.toStringList();
		return true;
	}
	if(query=="workAddr")
	{
		_workAdr=property.toString();
		return true;
	}
	if(query=="emails")
	{
		_emails=property.toStringList();
		return true;
	}
	if(query=="defaultEmail")
	{
		_defaultEmail=property.toInt();
		return true;
	}
	if(query=="notes")
	{
		_notes=property.toString();
		return true;
	}
	if(query=="url")
	{
		_URLs=property.toStringList();
		return true;
	}
	if(query=="nick")
	{
		_nick=property.toString();
		return true;
	}
	if(query=="security")
	{
		_security=property.toInt();
		return true;
	}
	if(query=="bdate")
	{
		_bday=property.toString();
		return true;
	}
	if(query=="org")
	{
		_org=property.toString();
		return true;
	}
	if(query=="title")
	{
		_title=property.toString();
		return true;
	}
	if(query=="class")
	{
		_classCard=property.toString();
		return true;
	}
	if(query=="role")
	{
		_role=property.toString();
		return true;
	}
	if(query=="categories")
	{
		_categories=property.toString();
		return true;
	}
	if(query=="category")
	{
		_category=property.toString();
		return true;
	}	
	if(query=="relatedObjectList")
	{
		_relatedObjectList=property.toStringList();
		return true;
	}
	return false;
}

QueryProcessor::QueryType ContactObject::queryType(const QString &query)
{
	if(query=="fn" || query=="n"
		|| query=="homeAdr" || query=="phone" || query=="phoneType"
		|| query=="workAdr" 
		|| query=="emails" || query=="defaultEmail"
		|| query=="notes"
		|| query=="URLs"
		|| query=="nick"
		|| query=="security"
		|| query=="bdate"
		|| query=="org" || query=="title" || query=="role" || query=="class" 
		|| query=="categories" || query=="category"
		|| query=="relatedObjectList")
		return QueryProcessor::ReadWriteQuery;
	
	
	return QueryProcessor::InvalidQuery;
}

// implementation of the contact object factory

ContactObject *ContactObjectFactory::_new(QString _path)
{
	return ClientVFS::thisInstance()->template _new<ContactObject>(_path);
}

ContactObject *ContactObjectFactory::_new(QString _path, QByteArray &_data)
{
	return ClientVFS::thisInstance()->template _new<ContactObject>(_path, _data);
}
