/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.mm.mysql;

import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.DataSource;
import org.gjt.mm.mysql.Driver;

public class MysqlDataSource
implements DataSource,
Referenceable,
Serializable {
    protected static Driver _MysqlDriver = null;
    protected String _HostName = null;
    protected int _port = 1306;
    protected String _DatabaseName = null;
    protected String _Encoding = null;
    protected String _User = null;
    protected String _Password = null;
    protected PrintWriter _LogWriter = null;

    public Connection getConnection() throws SQLException {
        return this.getConnection(this._User, this._Password);
    }

    public Connection getConnection(String UserID, String Password) throws SQLException {
        Properties Props = new Properties();
        if (UserID == null) {
            UserID = "";
        }
        if (Password == null) {
            Password = "";
        }
        Props.put("user", UserID);
        Props.put("password", Password);
        return this.getConnection(Props);
    }

    protected Connection getConnection(Properties Props) throws SQLException {
        StringBuffer JDBCUrl = new StringBuffer("jdbc:mysql://");
        if (this._HostName != null) {
            JDBCUrl.append(this._HostName);
        }
        JDBCUrl.append(":");
        JDBCUrl.append(this._port);
        JDBCUrl.append("/");
        if (this._DatabaseName != null) {
            JDBCUrl.append(this._DatabaseName);
        }
        return _MysqlDriver.connect(JDBCUrl.toString(), Props);
    }

    public String getDatabaseName() {
        return this._DatabaseName;
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this._LogWriter;
    }

    public int getLoginTimeout() throws SQLException {
        return 0;
    }

    public int getPort() {
        return this._port;
    }

    public Reference getReference() throws NamingException {
        String FactoryName = "org.gjt.mm.mysql.MysqlDataSourceFactory";
        Reference Ref2 = new Reference(this.getClass().getName(), FactoryName, null);
        Ref2.add(new StringRefAddr("user", this.getUser()));
        Ref2.add(new StringRefAddr("password", this._Password));
        Ref2.add(new StringRefAddr("serverName", this.getServerName()));
        Ref2.add(new StringRefAddr("port", "" + this.getPort()));
        Ref2.add(new StringRefAddr("databaseName", this.getDatabaseName()));
        return Ref2;
    }

    public String getServerName() {
        return this._HostName;
    }

    public String getURL() {
        String Url = "jdbc:mysql://";
        Url = String.valueOf(Url) + this.getServerName() + ":" + this.getPort() + "/" + this.getDatabaseName();
        return Url;
    }

    public String getUser() {
        return this._User;
    }

    public void setDatabaseName(String DBName) {
        this._DatabaseName = DBName;
    }

    public void setLogWriter(PrintWriter Output) throws SQLException {
        this._LogWriter = Output;
    }

    public void setLoginTimeout(int seconds) throws SQLException {
    }

    public void setPassword(String Pass) {
        this._Password = Pass;
    }

    public void setPort(int p) {
        this._port = p;
    }

    public void setServerName(String ServerName) {
        this._HostName = ServerName;
    }

    public void setUser(String UserID) {
        this._User = UserID;
    }

    static {
        try {
            _MysqlDriver = (Driver)Class.forName("org.gjt.mm.mysql.Driver").newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException("Can not load Driver class org.gjt.mm.mysql.Driver");
        }
    }
}

