/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.util;

public final class SimpleStack {
    private Object[] _stack;
    private int _count = 0;

    public synchronized void push(Object object) {
        if (object == null) {
            return;
        }
        this.ensureCapacity(this._count + 1);
        this._stack[this._count] = object;
        ++this._count;
    }

    public synchronized Object pop() {
        if (this._count == 0) {
            return null;
        }
        --this._count;
        Object object = this._stack[this._count];
        this._stack[this._count] = null;
        return object;
    }

    public synchronized int size() {
        return this._count;
    }

    public boolean isEmpty() {
        return this._count == 0;
    }

    public synchronized void clear() {
        int n = 0;
        while (n < this._stack.length) {
            this._stack[n] = null;
            ++n;
        }
        this._count = 0;
    }

    public void ensureCapacity(int n) {
        if (this._stack == null) {
            this._stack = new Object[n];
        } else if (n > this._stack.length) {
            Object[] objectArray = new Object[n];
            System.arraycopy(this._stack, 0, objectArray, 0, this._stack.length);
            this._stack = objectArray;
        }
    }

    public static void main(String[] stringArray) {
        Object object;
        SimpleStack simpleStack = new SimpleStack();
        int n = 0;
        while (n < stringArray.length) {
            System.out.println("Pushing: " + stringArray[n]);
            simpleStack.push(stringArray[n]);
            ++n;
        }
        System.out.println("Number of elements on stack: " + simpleStack.size());
        while ((object = simpleStack.pop()) != null) {
            System.out.println("pop: " + object);
        }
        System.out.println("Number of elements on stack: " + simpleStack.size());
    }
}

