/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

public final class QueueWriter
extends Writer {
    private char[][] buffer = new char[32][];
    private char[] local;
    private int[] offset = new int[32];
    private int[] length = new int[32];
    private int count;
    private int size;
    private int localPos;

    public QueueWriter() {
        this(1024);
    }

    public QueueWriter(int n) {
        this.local = new char[n];
        this.localPos = 0;
        this.count = -1;
        this.size = 0;
    }

    private void increaseCapacity() {
        int n = this.buffer.length;
        int n2 = n * 2 + 1;
        char[][] cArrayArray = new char[n2][];
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        System.arraycopy(this.buffer, 0, cArrayArray, 0, n);
        System.arraycopy(this.offset, 0, nArray, 0, n);
        System.arraycopy(this.length, 0, nArray2, 0, n);
        System.arraycopy(cArrayArray, n, this.buffer, 0, n);
        System.arraycopy(nArray, n, this.offset, 0, n);
        System.arraycopy(nArray2, n, this.length, 0, n);
        this.buffer = cArrayArray;
        this.offset = nArray;
        this.length = nArray2;
    }

    private void ensureLocalCapacity(int n) {
        if (this.localPos + n >= this.local.length) {
            char[] cArray = new char[this.local.length * 2 + n];
            System.arraycopy(this.local, 0, cArray, 0, this.local.length);
            this.local = cArray;
        }
    }

    public void write(char[] cArray, int n, int n2) {
        if (n2 == 0) {
            return;
        }
        ++this.count;
        if (this.count >= this.buffer.length) {
            this.increaseCapacity();
        }
        this.buffer[this.count] = cArray;
        this.offset[this.count] = n;
        this.length[this.count] = n2;
        this.size += n2;
    }

    public void write(int n) {
        ++this.count;
        if (this.count >= this.buffer.length) {
            this.increaseCapacity();
        }
        this.ensureLocalCapacity(1);
        this.local[this.localPos++] = (char)n;
        this.buffer[this.count] = null;
        this.offset[this.count] = 0;
        this.length[this.count] = 1;
        ++this.size;
    }

    public void write(String string, int n, int n2) {
        if (n2 == 0) {
            return;
        }
        ++this.count;
        if (this.count >= this.buffer.length) {
            this.increaseCapacity();
        }
        this.ensureLocalCapacity(n2);
        string.getChars(n, n + n2, this.local, this.localPos);
        this.buffer[this.count] = null;
        this.offset[this.count] = this.localPos;
        this.length[this.count] = n2;
        this.localPos += n2;
        this.size += n2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.size);
        int n = 0;
        while (n <= this.count) {
            char[] cArray = this.buffer[n] == null ? this.local : this.buffer[n];
            stringBuffer.append(cArray, this.offset[n], this.length[n]);
            ++n;
        }
        return stringBuffer.toString();
    }

    public void writeTo(Writer writer) throws IOException {
        int n = 0;
        while (n <= this.count) {
            char[] cArray = this.buffer[n] == null ? this.local : this.buffer[n];
            writer.write(cArray, this.offset[n], this.length[n]);
            ++n;
        }
    }

    public int size() {
        return this.size;
    }

    public void reset() {
        int n = 0;
        while (n <= this.count) {
            this.buffer[n] = null;
            this.offset[n] = 0;
            this.length[n] = 0;
            this.localPos = 0;
            this.count = -1;
            this.size = 0;
            ++n;
        }
    }

    public void flush() {
    }

    public void close() {
    }

    public static void main(String[] stringArray) throws Exception {
        QueueWriter queueWriter = new QueueWriter(3);
        char[] cArray = "Hello, brave new world".toCharArray();
        int n = 0;
        while (n < 2) {
            int n2 = 0;
            while (n2 < 20) {
                int n3 = 0;
                while (n3 < stringArray.length) {
                    queueWriter.write(new String(stringArray[n3]));
                    queueWriter.write(new String(stringArray[n3]), 0, stringArray[n3].length());
                    queueWriter.write(32);
                    queueWriter.write(cArray, 7, 6);
                    ++n3;
                }
                System.out.println("\ncount: " + queueWriter.count);
                System.out.println("buffer: " + queueWriter.buffer.length);
                System.out.println("local: " + queueWriter.local.length);
                System.out.println("offset: " + queueWriter.offset.length);
                System.out.println("length: " + queueWriter.length.length);
                System.out.println("- - - - Output - - - -");
                PrintWriter printWriter = new PrintWriter(System.err);
                queueWriter.writeTo(printWriter);
                printWriter.flush();
                queueWriter.reset();
                ++n2;
            }
            ++n;
        }
    }
}

