/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.engine;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Date;
import org.webmacro.Broker;
import org.webmacro.Context;
import org.webmacro.FastWriter;
import org.webmacro.WM;
import org.webmacro.engine.TestObject;
import org.webmacro.engine.WMTemplate;
import org.webmacro.util.Log;
import org.webmacro.util.SelectList;

public class StreamTemplate
extends WMTemplate {
    private Reader _in;

    public StreamTemplate(Broker broker, Reader reader, String string) {
        super(broker, string);
        this._in = reader;
    }

    protected Reader getReader() throws IOException {
        if (this._in != null) {
            Reader reader = this._in;
            this._in = null;
            return reader;
        }
        throw new IOException("Already read stream.");
    }

    public String toString() {
        return "StreamTemplate: (stream " + this._in + ")";
    }

    public static void main(String[] stringArray) {
        Object[] objectArray;
        Log.traceExceptions(true);
        Log.setLevel(Log.ALL);
        Log.setTarget(System.err);
        if (stringArray.length != 0) {
            System.out.println("Enabling log types");
            Log.enableTypes(stringArray);
        }
        WM wM = null;
        Context context = null;
        try {
            wM = new WM();
            context = wM.getContext();
            objectArray = new Object[]{"prop"};
            context.setProperty(objectArray, "Example property");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            context.put("helloworld", "Hello World");
            context.put("hello", "Hello");
            context.put("file", "include.txt");
            context.put("today", new Date());
            objectArray = new TestObject[]{new TestObject("apple", false), new TestObject("lemon", true), new TestObject("pear", false), new TestObject("orange", true), new TestObject("watermelon", false), new TestObject("peach", false), new TestObject("lime", true)};
            SelectList selectList = new SelectList(objectArray, 3);
            context.put("sl-fruits", selectList);
            context.put("fruits", objectArray);
            context.put("flipper", new TestObject("flip", false));
            System.out.println("- - - - - - - - - - - - - - - - - - - -");
            System.out.println("Context contains: helloWorld, hello, file, TestObject[] fruits, SelectList sl(fruits, 3), TestObject flipper");
            System.out.println("- - - - - - - - - - - - - - - - - - - -");
            StreamTemplate streamTemplate = new StreamTemplate(wM.getBroker(), new InputStreamReader(System.in), "UTF8");
            streamTemplate.parse();
            FastWriter fastWriter = new FastWriter(System.out, "UTF8");
            System.out.println("*** RESULT ***");
            streamTemplate.write(fastWriter, context);
            fastWriter.close();
            System.out.println("*** DONE ***");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

