/*
 * Decompiled with CFR 0.152.
 */
package org.webmacro.engine;

import java.io.IOException;
import org.webmacro.Context;
import org.webmacro.ContextException;
import org.webmacro.FastWriter;
import org.webmacro.InvalidTypeException;
import org.webmacro.Macro;
import org.webmacro.NotFoundException;
import org.webmacro.engine.BuildContext;
import org.webmacro.engine.BuildException;
import org.webmacro.engine.Directive;
import org.webmacro.engine.GetFileException;

class IncludeDirective
implements Directive {
    private final Macro _fileName;

    IncludeDirective(Macro macro) {
        this._fileName = macro;
    }

    private static String getFile(Context context, String string) throws GetFileException {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        try {
            string4 = string.toString();
            string3 = context.getBroker().getValue("url", string4).toString();
        }
        catch (InvalidTypeException invalidTypeException) {
            string2 = "No URL provider registered in this broker.";
        }
        catch (NotFoundException notFoundException) {
            string2 = "Cannot include " + string4 + ": NOT FOUND";
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
            string2 = "Could not load target " + string + ": NULL VALUE";
        }
        if (string2 != null) {
            throw new GetFileException("#include failed: " + string2);
        }
        return string3;
    }

    public static Object build(BuildContext buildContext, Object object) throws BuildException {
        if (object instanceof Macro) {
            return new IncludeDirective((Macro)object);
        }
        if (object == null) {
            throw new BuildException("Cannot #include null filename");
        }
        try {
            return IncludeDirective.getFile(buildContext, object.toString());
        }
        catch (GetFileException getFileException) {
            throw new BuildException(getFileException.getMessage());
        }
    }

    public final Object evaluate(Context context) throws ContextException {
        Object object = this._fileName.evaluate(context);
        if (object == null) {
            throw new ContextException("#include could not resolve filename: target argument resolved to a null.");
        }
        try {
            return IncludeDirective.getFile(context, object.toString());
        }
        catch (GetFileException getFileException) {
            throw new ContextException(getFileException.getMessage());
        }
    }

    public final void write(FastWriter fastWriter, Context context) throws ContextException, IOException {
        fastWriter.write((String)this.evaluate(context));
    }
}

