/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.dom;

import org.apache.xerces.dom.AttributeMap;
import org.apache.xerces.dom.ChildNode;
import org.apache.xerces.dom.DeepNodeListImpl;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.dom.DocumentTypeImpl;
import org.apache.xerces.dom.ElementDefinitionImpl;
import org.apache.xerces.dom.NamedNodeMapImpl;
import org.apache.xerces.dom.ParentNode;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ElementImpl
extends ParentNode
implements Element {
    static final long serialVersionUID = 3717253516652722278L;
    protected String name;
    protected AttributeMap attributes;

    protected ElementImpl() {
    }

    public ElementImpl(DocumentImpl documentImpl, String string) {
        super(documentImpl);
        this.name = string;
        this.needsSyncData(true);
    }

    public Node cloneNode(boolean bl) {
        ElementImpl elementImpl = (ElementImpl)super.cloneNode(bl);
        if (this.attributes != null) {
            elementImpl.attributes = (AttributeMap)this.attributes.cloneMap(elementImpl);
        }
        return elementImpl;
    }

    public String getAttribute(String string) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.attributes == null) {
            return "";
        }
        Attr attr = (Attr)this.attributes.getNamedItem(string);
        return attr == null ? "" : attr.getValue();
    }

    public String getAttributeNS(String string, String string2) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.attributes == null) {
            return "";
        }
        Attr attr = (Attr)this.attributes.getNamedItemNS(string, string2);
        return attr == null ? "" : attr.getValue();
    }

    public Attr getAttributeNode(String string) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.attributes == null) {
            return null;
        }
        return (Attr)this.attributes.getNamedItem(string);
    }

    public Attr getAttributeNodeNS(String string, String string2) {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.attributes == null) {
            return null;
        }
        return (Attr)this.attributes.getNamedItemNS(string, string2);
    }

    public NamedNodeMap getAttributes() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.attributes == null) {
            this.attributes = new AttributeMap(this, null);
        }
        return this.attributes;
    }

    protected NamedNodeMapImpl getDefaultAttributes() {
        DocumentTypeImpl documentTypeImpl = (DocumentTypeImpl)this.ownerDocument.getDoctype();
        if (documentTypeImpl == null) {
            return null;
        }
        ElementDefinitionImpl elementDefinitionImpl = (ElementDefinitionImpl)documentTypeImpl.getElements().getNamedItem(this.getNodeName());
        if (elementDefinitionImpl == null) {
            return null;
        }
        return (NamedNodeMapImpl)elementDefinitionImpl.getAttributes();
    }

    public NodeList getElementsByTagName(String string) {
        return new DeepNodeListImpl(this, string);
    }

    public NodeList getElementsByTagNameNS(String string, String string2) {
        return new DeepNodeListImpl(this, string, string2);
    }

    public String getNodeName() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.name;
    }

    public short getNodeType() {
        return 1;
    }

    public String getTagName() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.name;
    }

    public boolean hasAttribute(String string) {
        return this.getAttributeNode(string) != null;
    }

    public boolean hasAttributeNS(String string, String string2) {
        return this.getAttributeNodeNS(string, string2) != null;
    }

    public boolean hasAttributes() {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        return this.attributes != null && this.attributes.getLength() != 0;
    }

    public void normalize() {
        if (this.isNormalized()) {
            return;
        }
        if (this.needsSyncChildren()) {
            this.synchronizeChildren();
        }
        ChildNode childNode = this.firstChild;
        while (childNode != null) {
            ChildNode childNode2 = childNode.nextSibling;
            if (childNode.getNodeType() == 3) {
                if (childNode2 != null && childNode2.getNodeType() == 3) {
                    ((Text)((Object)childNode)).appendData(childNode2.getNodeValue());
                    this.removeChild(childNode2);
                    childNode2 = childNode;
                } else if (childNode.getNodeValue().length() == 0) {
                    this.removeChild(childNode);
                }
            } else if (childNode.getNodeType() == 1) {
                childNode.normalize();
            }
            childNode = childNode2;
        }
        if (this.attributes != null) {
            int n = 0;
            while (n < this.attributes.getLength()) {
                Node node = this.attributes.item(n);
                node.normalize();
                ++n;
            }
        }
        this.isNormalized(true);
    }

    public void removeAttribute(String string) {
        if (this.ownerDocument.errorChecking && this.isReadOnly()) {
            throw new DOMException(7, "DOM001 Modification not allowed");
        }
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.attributes == null) {
            return;
        }
        this.attributes.safeRemoveNamedItem(string);
    }

    public void removeAttributeNS(String string, String string2) {
        if (this.ownerDocument.errorChecking && this.isReadOnly()) {
            throw new DOMException(7, "DOM001 Modification not allowed");
        }
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.attributes == null) {
            return;
        }
        this.attributes.safeRemoveNamedItemNS(string, string2);
    }

    public Attr removeAttributeNode(Attr attr) throws DOMException {
        if (this.ownerDocument.errorChecking && this.isReadOnly()) {
            throw new DOMException(7, "DOM001 Modification not allowed");
        }
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.attributes == null) {
            throw new DOMException(8, "DOM008 Not found");
        }
        return (Attr)this.attributes.removeNamedItem(attr.getName());
    }

    public void setAttribute(String string, String string2) {
        Attr attr;
        if (this.ownerDocument.errorChecking && this.isReadOnly()) {
            throw new DOMException(7, "DOM001 Modification not allowed");
        }
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if ((attr = this.getAttributeNode(string)) == null) {
            attr = this.getOwnerDocument().createAttribute(string);
            if (this.attributes == null) {
                this.attributes = new AttributeMap(this, null);
            }
            attr.setNodeValue(string2);
            this.attributes.setNamedItem(attr);
        } else {
            attr.setNodeValue(string2);
        }
    }

    public void setAttributeNS(String string, String string2, String string3) {
        Attr attr;
        if (this.ownerDocument.errorChecking && this.isReadOnly()) {
            throw new DOMException(7, "DOM001 Modification not allowed");
        }
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if ((attr = this.getAttributeNodeNS(string, string2)) == null) {
            attr = this.getOwnerDocument().createAttributeNS(string, string2);
            if (this.attributes == null) {
                this.attributes = new AttributeMap(this, null);
            }
            attr.setNodeValue(string3);
            this.attributes.setNamedItemNS(attr);
        } else {
            attr.setNodeValue(string3);
        }
    }

    public Attr setAttributeNode(Attr attr) throws DOMException {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.ownerDocument.errorChecking) {
            if (this.isReadOnly()) {
                throw new DOMException(7, "DOM001 Modification not allowed");
            }
            if (attr.getOwnerDocument() != this.ownerDocument) {
                throw new DOMException(4, "DOM005 Wrong document");
            }
        }
        if (this.attributes == null) {
            this.attributes = new AttributeMap(this, null);
        }
        return (Attr)this.attributes.setNamedItem(attr);
    }

    public Attr setAttributeNodeNS(Attr attr) throws DOMException {
        if (this.needsSyncData()) {
            this.synchronizeData();
        }
        if (this.ownerDocument.errorChecking) {
            if (this.isReadOnly()) {
                throw new DOMException(7, "DOM001 Modification not allowed");
            }
            if (attr.getOwnerDocument() != this.ownerDocument) {
                throw new DOMException(4, "DOM005 Wrong document");
            }
        }
        if (this.attributes == null) {
            this.attributes = new AttributeMap(this, null);
        }
        return (Attr)this.attributes.setNamedItemNS(attr);
    }

    void setOwnerDocument(DocumentImpl documentImpl) {
        super.setOwnerDocument(documentImpl);
        if (this.attributes != null) {
            this.attributes.setOwnerDocument(documentImpl);
        }
    }

    public void setReadOnly(boolean bl, boolean bl2) {
        super.setReadOnly(bl, bl2);
        if (this.attributes != null) {
            this.attributes.setReadOnly(bl, true);
        }
    }

    protected void setupDefaultAttributes() {
        NamedNodeMapImpl namedNodeMapImpl = this.getDefaultAttributes();
        if (namedNodeMapImpl != null) {
            this.attributes = new AttributeMap(this, namedNodeMapImpl);
        }
    }

    protected void synchronizeData() {
        this.needsSyncData(false);
        boolean bl = this.ownerDocument.mutationEvents;
        this.ownerDocument.mutationEvents = false;
        this.setupDefaultAttributes();
        this.ownerDocument.mutationEvents = bl;
    }
}

