/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.log4j.Category;
import org.apache.log4j.CategoryKey;
import org.apache.log4j.DefaultCategoryFactory;
import org.apache.log4j.ProvisionNode;
import org.apache.log4j.or.ObjectRenderer;
import org.apache.log4j.or.RendererMap;
import org.apache.log4j.spi.CategoryFactory;

public class Hierarchy {
    private static CategoryFactory defaultFactory = new DefaultCategoryFactory();
    Hashtable ht = new Hashtable();
    Category root;
    RendererMap rendererMap;

    public void addRenderer(Class clazz, ObjectRenderer objectRenderer) {
        this.rendererMap.put(clazz, objectRenderer);
    }

    public void clear() {
        this.ht.clear();
    }

    public Category exists(String string) {
        Object v = this.ht.get(new CategoryKey(string));
        if (v instanceof Category) {
            return (Category)v;
        }
        return null;
    }

    public Category getInstance(String string) {
        return this.getInstance(string, defaultFactory);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Category getInstance(String string, CategoryFactory categoryFactory) {
        CategoryKey categoryKey = new CategoryKey(string);
        Hashtable hashtable = this.ht;
        synchronized (hashtable) {
            Object v = this.ht.get(categoryKey);
            if (v == null) {
                Category category = categoryFactory.makeNewCategoryInstance(string);
                category.setHierarchy(this);
                this.ht.put(categoryKey, category);
                this.updateParents(category);
                return category;
            }
            if (v instanceof Category) {
                return (Category)v;
            }
            if (!(v instanceof ProvisionNode)) return null;
            Category category = categoryFactory.makeNewCategoryInstance(string);
            category.setHierarchy(this);
            this.ht.put(categoryKey, category);
            this.updateChildren((ProvisionNode)v, category);
            this.updateParents(category);
            return category;
        }
    }

    public RendererMap getRendererMap() {
        return this.rendererMap;
    }

    public Category getRoot() {
        return this.root;
    }

    private final void updateParents(Category category) {
        String string = category.name;
        int n = string.length();
        boolean bl = false;
        int n2 = string.lastIndexOf(46, n - 1);
        while (n2 >= 0) {
            Serializable serializable;
            String string2 = string.substring(0, n2);
            CategoryKey categoryKey = new CategoryKey(string2);
            Object v = this.ht.get(categoryKey);
            if (v == null) {
                serializable = new ProvisionNode(category);
                this.ht.put(categoryKey, serializable);
            } else {
                if (v instanceof Category) {
                    bl = true;
                    category.parent = (Category)v;
                    break;
                }
                if (v instanceof ProvisionNode) {
                    ((ProvisionNode)v).addElement(category);
                } else {
                    serializable = new IllegalStateException("unexpected object type " + v.getClass() + " in ht.");
                    ((Throwable)serializable).printStackTrace();
                }
            }
            n2 = string.lastIndexOf(46, n2 - 1);
        }
        if (!bl) {
            category.parent = this.root;
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void updateChildren(ProvisionNode var1_1, Category var2_2) {
        var3_3 = var1_1.size();
        var4_4 = 0;
        while (var4_4 < var3_3) {
            block2: {
                var5_5 = (Category)var1_1.elementAt(var4_4);
                if (var5_5.parent == null || !var5_5.parent.name.startsWith(var2_2.name)) ** GOTO lbl8
                break block2;
lbl-1000:
                // 1 sources

                {
                    var5_5 = var5_5.parent;
lbl8:
                    // 2 sources

                    ** while (var5_5.parent != null && var5_5.parent.name.startsWith((String)var2_2.name))
                }
lbl9:
                // 1 sources

                var2_2.parent = var5_5.parent;
                var5_5.parent = var2_2;
            }
            ++var4_4;
        }
    }

    public void shutdown() {
        Category category = this.getRoot();
        category.closeNestedAppenders();
        Hashtable hashtable = this.ht;
        synchronized (hashtable) {
            Category category2;
            Enumeration enumeration = Category.getCurrentCategories();
            while (enumeration.hasMoreElements()) {
                category2 = (Category)enumeration.nextElement();
                category2.closeNestedAppenders();
            }
            category.removeAllAppenders();
            enumeration = Category.getCurrentCategories();
            while (enumeration.hasMoreElements()) {
                category2 = (Category)enumeration.nextElement();
                category2.removeAllAppenders();
            }
        }
    }

    public Hierarchy(Category category) {
        this.root = category;
        this.root.setHierarchy(this);
        this.rendererMap = new RendererMap();
    }
}

