/* 
 *   Creation Date: <2001/01/26 21:33:45 samuel>
 *   Time-stamp: <2001/04/12 11:30:47 samuel>
 *   
 *	<return_vectors.h>
 *	
 *	Possible mac-return vectors (see mainloop.S)
 *   
 *   Copyright (C) 2000, 2001 Samuel Rydh (samuel@ibrium.se)
 *   
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation
 *   
 */

#ifndef _H_RVEC
#define _H_RVEC


// ----------------------------------------------------------------------------
// Bits 17-24 of the RVEC number are flag bits. 
// (That bit 0-3 is not used for flags is assumed in mainloop_asm.S)

#define RVF_fb			17	// First RVF bit
#define RVF_lb			24	// Last RVF bit

#define RVF_FPU_UNSAFE_BIT	17
#define RVF_USES_GPRS_BIT	18
#define RVF_USES_FPRS_BIT	19

#define RVF_FPU_UNSAFE		BIT(RVF_FPU_UNSAFE_BIT)
#define RVF_USES_GPRS		BIT(RVF_USES_GPRS_BIT)
#define RVF_USES_FPRS		BIT(RVF_USES_FPRS_BIT)

// ----------------------------------------------------------------------------

#define NRVECS_LOG2			6
#define NUM_RVECS			64	// = 2 ^ NRVECS_LOG2

#define RVEC_MASK			(NUM_RVECS-1)

#define vFPU				RVF_FPU_UNSAFE
#define vGPRS				RVF_USES_GPRS
#define vFPRS				RVF_USES_FPRS
#define vALL				(vFPU | vGPRS | vFPRS)

// ----------------------------------------------------------------------------

#define	RVEC_NOP			0		// Must be zero
#define RVEC_INITIALIZE			1
#define RVEC_ENABLE_FPU			3		// Load up FPU

#define RVEC_TRACE_TRAP			6
#define RVEC_ISI_TRAP			9		// r4=nip, r5=srr1
#define RVEC_DSI_TRAP			10		// r4=dar, r5=srr1
#define RVEC_ALIGNMENT_TRAP		11		// r4=dar, r5=srr1

#define RVEC_SPR_READ			(13 | vGPRS)	// r4=spr#, r5=gprnum
#define RVEC_SPR_WRITE			14		// r4=spr#, r5=value
#define RVEC_PRIV_INST			(15 | vGPRS)	// r4=opcode
#define RVEC_ILLEGAL_INST		(16 | vGPRS)	// r4=opcode

#define RVEC_UNUSUAL_PROGRAM_EXCEP	17		// r4=opcode, r5=srr1

#define RVEC_ALTIVEC_UNAVAIL_TRAP	18
#define RVEC_ALTIVEC_ASSIST		19		// r4=srr1
#define RVEC_ENABLE_ALTIVEC		20

#define	RVEC_EXIT			(21 | vFPU)
#define RVEC_INTERRUPT			(22 | vFPU)
#define RVEC_OSI_SYSCALL		(23 | vFPU)

#define RVEC_IO_READ			(25 | vALL)	// 
#define RVEC_IO_WRITE			(26 | vALL)	//

#define RVEC_MSR_POW			(27 | vFPU)	// (MSR_POW 0->1) => doze

// Error/debug
#define RVEC_UNUSUAL_DSISR_BITS		(28 | vFPU)	// dar, dsisr (bit 0,5,9 or 11 was set)
#define RVEC_MMU_IO_SEG_ACCESS		(29 | vFPU)	// IO segment access (more or less unused)
#define	RVEC_INTERNAL_ERROR		(30 | vFPU)
#define	RVEC_DEBUGGER			(31 | vFPU)
#define RVEC_BREAK			(32 | vFPU)	// r4 = break_flag
#define RVEC_BAD_NIP			(33 | vFPU)	// r4 = phys_nip

/************************************************************************/
/*	MOL kernel/emulator switch magic				*/
/************************************************************************/

/* Magic to be loaded into r4/r5 before the illegal instruction is issued */
#define MOL_INITIALIZE_R4_MAGIC		0x1915
#define MOL_INITIALIZE_R5_MAGIC		0x1945
#define MOL_ENTRY_R4_MAGIC		0x1475
#define MOL_ENTRY_R5_MAGIC		0x1803
#define MOL_KERNEL_ENTRY_MAGIC		mfmsr	r0	// Any privileged instruction will do

/************************************************************************/
/*	Kernel definitions						*/
/************************************************************************/

#if defined(__KERNEL__)

#if !defined( __ASSEMBLY__ )

#define RVEC_RETURN_1( mregsptr, rvec, arg1 ) \
	({ (mregsptr)->rvec_param[0] = (ulong)(arg1); \
	  return rvec; })

#define RVEC_RETURN_2( mregsptr, rvec, arg1, arg2 ) \
	({ (mregsptr)->rvec_param[0] = (ulong)(arg1); \
	  (mregsptr)->rvec_param[1] = (ulong)(arg2); \
	  return rvec; })

#define RVEC_RETURN_3( mregsptr, rvec, arg1, arg2, arg3 ) \
	({ (mregsptr)->rvec_param[0] = (ulong)(arg1); \
	  (mregsptr)->rvec_param[1] = (ulong)(arg2); \
	  (mregsptr)->rvec_param[2] = (ulong)(arg3); \
	  return rvec; })

#endif /* __ASSEMBLY__ */

/************************************************************************/
/*	Emulator definitions						*/
/************************************************************************/

#else /* __KERNEL__ */

#if !defined(__ASSEMBLY__)
extern void rvec_init( void );
extern void rvec_cleanup( void );
extern void set_rvector( int vnum, void *vector, char *vector_name, int fpu_safe );

// This struct is private to rvec.c/mainloop.S (offsets are HARDCODED)
typedef struct {
	int 	(*rvec)( int rvec /*, arguments */ );
	int 	dbg_count;
	char 	*dbg_name;
	int	filler;
} rvec_table_t;
#endif /* __ASSEMBLY__ */


#define RVEC_ESIZE_LOG2		4	// 2^n = sizeof(rvec_table_t)
#define RVEC_ESIZE		16	// sizeof(rvec_table_t)

// fpu_safe field in set_rvector 
#define kFPU_Unsafe		0
#define kFPU_Safe		1


// RVEC return bit flags. We don't use bit 0-3 since this simplifies the
// implementation in mainloop_asm.S (we can put the flags in cr and still use cr0...)

#define kRVecExitBit		4	// Exit the mainloop
#define kRVecGPRsModifiedBit	5
#define kRVecFPRsModifiedBit	6	// FPRs have been modified (fp0-fp31)

#define	kRVecNormalReturn	0
#define	kRVecExit		BIT(kRVecExitBit)
#define	kRVecGPRsModified	BIT(kRVecGPRsModifiedBit)
#define kRVecFPRsModified	BIT(kRVecFPRsModifiedBit)

#endif /* __KERNEL__ */

#endif   /* _H_RVEC */
