/* 
 *   Creation Date: <2001/03/25 18:04:45 samuel>
 *   Time-stamp: <2001/04/15 12:28:38 samuel>
 *   
 *	<ptaccess.c>
 *	
 *	Handle stores to the (emulated) page table
 *   
 *   Copyright (C) 2001 Samuel Rydh (samuel@ibrium.se)
 *   
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation
 *   
 */

#include "compat.h"
#include <linux/config.h>
#include <linux/types.h>
#include <linux/kernel.h>

#include "mmu.h"
#include "rvec.h"

#define PERFORMANCE_INFO
#include "performance.h"

extern asmlinkage int do_intercept_tlbie( kernel_vars_t *kv, ulong pte0, ulong pte1, ulong pteoffs );

asmlinkage int 
do_intercept_tlbie( kernel_vars_t *kv, ulong pte0, ulong pte1, ulong pteoffs )
{
	ulong v;
	BUMP( do_intercept_tlbie );

	// printk("do_intercept_tlbie %08lX:  %08lX %08lX\n", pteoffs, pte0, pte1 );
	v = (pteoffs >> 6);
	if( pte0 & BIT(25) )	/* secondary hash? */
		v = ~v;
	v ^= (pte0 >> 7) & 0x1fffff;
	v &= 0x3ff;
	v |= (pte0 << 10);

//	printk("EA: %08lX\n", v<<12 );
	table_tlbie( kv, v<<12 );
	
	return RVEC_NOP;
}

