/*   -*- asm -*-
 *
 *   Creation Date: <2001/01/28 20:33:22 samuel>
 *   Time-stamp: <2001/06/16 15:29:32 samuel>
 *   
 *	<molasm.h>
 *	
 *	Utility assembly macros
 *   
 *   Copyright (C) 2001 Samuel Rydh (samuel@ibrium.se)
 *   
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation
 *   
 */

#ifndef _H_MOLASM
#define _H_MOLASM


/************************************************************************/
/*	Vector entry point definitions					*/
/************************************************************************/

#define MOL_SPRG2_MAGIC		0x1779

/*
 * This code uses the dynamic linkage/action symbol functionality of 
 * the MOL kernel loader to automatically install the hooks.
 * Refer to init.c for the actual implementation.
 */

#define VECTOR_HOOK( v )					\
	.long	Action_RELOC_HOOK				;\
	.long	v						;\
	.long	vhook_end_##v - vhook_##v			;\
	.long	vret_##v - vhook_##v				;\
vhook_##v:							;\
	mtsprg0	r3						;\
	addis	r3,0,0	   /* [1] hook address inserted */	;\
	mtsprg1	r1						;\
	ori	r3,r3,0	   /* [3] at module initialization */	;\
	mflr	r1						;\
	mtlr	r3						;\
	blr							;\
								;\
vret_##v:							;\
	nop	/* overwritten instruction is inserted here */	;\
	ba	v + 0x4						;\
vhook_end_##v:							;

/* SPRG0,1 = saved r3,r1, r1 = saved lr */
#define VECTOR_(v, dummy_str, secondary, not_mol_label )	\
	/* not mol return */					;\
716:	mtcr	r3						;\
	mfsprg1	r1						;\
	mfsprg0	r3						;\
717: ; continue_trap_##v:					;\
	.long	Action_VRET + v		/* ba vret_xxx */	;\
								;\
	/* secondary interrupt */				;\
718:	li	r3,v						;\
	b	secondary					;\
								;\
	VECTOR_HOOK( v )					;\
								;\
	/* entrypoint */					;\
	mtlr	r1						;\
	mfcr	r3						;\
	mfsprg2	r1						;\
	cmpwi	r1,MOL_SPRG2_MAGIC				;\
	bne-	not_mol_label					;\
soft_603_entry_##v:						;\
	mfsrr1	r1						;\
	rlwinm.	r1,r1,0,17,17	/* MSR_PR set? */		;\
	mfsprg3	r1						;\
	beq-	718b	/* if not, take a secondary trap? */	;

#define VECTOR(v, dummy_str, secondary) VECTOR_(v, dummy_str, secondary, 716b )

#define TAKE_EXCEPTION_( v ) 					\
	bl	take_exception					;\
	.long	Action_VRET + v					;

#define TAKE_EXCEPTION						\
	bl	take_exception					;\
	b	717b


/************************************************************************/
/*	603 vector HOOKs (r0-r3, cr0 saved by hardware)			*/
/************************************************************************/

#define VECTOR_HOOK_603( v )					\
	.long	Action_RELOC_HOOK				;\
	.long	v						;\
	.long	vhook_end_##v - vhook_##v			;\
	.long	vret_##v - vhook_##v				;\
vhook_##v:							;\
	mfsprg2	r1						;\
	addis	r3,0,0	   /* [1] hook address inserted */	;\
	cmpwi	r1,MOL_SPRG2_MAGIC				;\
	ori	r3,r3,0	   /* [3] at module initialization */	;\
	bne	vret_##v					;\
	mfctr	r0						;\
	mtctr	r3						;\
	bctr							;\
								;\
vret_##v:							;\
	nop	/* overwritten instruction is inserted here */	;\
	ba	v + 0x4						;\
vhook_end_##v:							;

/* r0 = saved ctr */
#define VECTOR_603(v, dummy_str )				\
	VECTOR_HOOK_603( v )					;\
	/* entrypoint goes here */				;

/* all register are assumed unmodified here */
#define SOFT_VECTOR_ENTRY_603( v )				\
	mtsprg0	r3						;\
	mtsprg1 r1						;\
	mfcr	r3						;\
	b	soft_603_entry_##v				;

/************************************************************************/
/*	FUNCTION_HOOK							*/
/************************************************************************/

#define FHOOK( symind )						\
	.long	Action_HOOK_FUNCTION				;\
	.long	symind						;\
	.long	fhook_end_##symind - fhook_##symind		;\
	.long	fret_##symind - fhook_##symind			;\
fhook_##symind:							;\
	mflr	r10						;\
	addis	r9,0,0		/* [1] address inserted */	;\
	ori	r9,r9,0		/* [2] at runtime */		;\
	mtctr	r9						;\
	bctrl							;\
	mtlr	r10						;\
fret_##symind:							;\
	nop	/* overwritten instruction is inserted here */	;\
	nop	/* return (through a relative branch) */	;\
fhook_end_##symind:						;


/************************************************************************/
/*	Utility								*/
/************************************************************************/

.macro LOAD_VARIABLE reg, offs
	lis	\reg,(k_mol_stack + \offs)@ha
	lwz	\reg,(k_mol_stack + \offs)@l(\reg)
.endm

.macro SET_SESSION_TABLE reg
	lis	\reg,(k_session_table)@ha
	addi	\reg,\reg,(k_session_table)@l
.endm


/************************************************************************/
/*	GPR save / restore						*/
/************************************************************************/

.macro xGPR_SAVE p0=-1,p1=-1,p2=-1,p3=-1,p4=-1,p5=-1,p6=-1,p7=-1,p8=-1,p9=-1
	.if	\p0+1
	stw	\p0,xGPR0+\p0*4(r1)
	xGPR_SAVE \p1,\p2,\p3,\p4,\p5,\p6,\p8,\p8,\p9
	.endif
.endm

.macro xGPR_LOAD p0=-1,p1=-1,p2=-1,p3=-1,p4=-1,p5=-1,p6=-1,p7=-1,p8=-1,p9=-1
	.if	\p0+1
	lwz	\p0,xGPR0+\p0*4(r1)
	xGPR_LOAD \p1,\p2,\p3,\p4,\p5,\p6,\p8,\p8,\p9
	.endif
.endm

/************************************************************************/
/*	FPU misc							*/
/************************************************************************/

.macro ENABLE_MSR_FP scr
	mfmsr	\scr
	ori	\scr,\scr,MSR_FP
	mtmsr	\scr
	isync
.endm
		
/************************************************************************/
/*	Segment registers						*/
/************************************************************************/

.macro LOAD_SEGMENT_REGS base, scr, scr2, ind=0
	.if	\ind - 16
	lwz	\scr,(\ind * 4)(\base)
	lwz	\scr2,((\ind+1) * 4)(\base)
	mtsr	\ind,\scr
	mtsr	\ind+1,\scr2
	LOAD_SEGMENT_REGS \base, \scr2, \scr, (\ind+2)
	.endif
.endm

.macro SAVE_SEGMENT_REGS base, scr, scr2, ind=0
	.if	\ind - 16
	mfsr	\scr,\ind
	mfsr	\scr2,\ind+1
	stw	\scr,(\ind * 4)(\base)
	stw	\scr2,((\ind+1) * 4)(\base)
	SAVE_SEGMENT_REGS \base, \scr, \scr2, (\ind+2)
	.endif
.endm

/************************************************************************/
/*	BAT register							*/
/************************************************************************/

.macro SAVE_DBATS varoffs, scr1
	mfpvr	\scr1
	srwi	\scr1,\scr1,16
	cmpwi	r3,1
	beq	33f
	.irp	nn,0,1,2,3,4,5,6,7
	mfspr	\scr1, SPRN_DBAT0U + \nn
	stw	\scr1,\varoffs + (4*\nn)(r1)
	.endr
33:
.endm
.macro SAVE_IBATS varoffs, scr1
	.irp	nn,0,1,2,3,4,5,6,7
	mfspr	\scr1, SPRN_IBAT0U + \nn
	stw	\scr1,(\varoffs + (4*\nn))(r1)
	.endr
.endm

	
/************************************************************************/
/*	Physical/virtual conversion					*/
/************************************************************************/

	/* replaced with lis dreg,addr@ha ; addi dreg,dreg,addr@l */
#define LI_PHYS( dreg, addr ) \
	.long	Action_LI_PHYS + dreg	;\
	.long	addr - r__reloctable_start

#define LI_VIRT( dreg, addr ) \
	lis	dreg,addr@ha 	; \
	addi	dreg,dreg,addr@l

#define LI_PHYS_VARBASE( base ) \
	LI_PHYS( base, k_variable_base )

#define LI_VIRT_VARBASE( base ) \
	LI_VIRT( base, k_variable_base )

		
/************************************************************************/
/*	D E B U G							*/
/************************************************************************/

.macro STOP_EMULATION val
	stw	r3,xDEBUG_SCR1(r1)
	li	r3,\val
	stw	r3,xKERNEL_DBG_STOP(r1)
	li	r3,1
	stw	r3,xINTERRUPT(r1)
	lwz	r3,xDEBUG_SCR1(r1)	
.endm
	
.macro DEBUG_INC num, dummy=""
.if (\num >= 9 || \num<0)
	.print "******* DEBUG_INC num out of range **********" ; .fail 1
.endif
	stw	r3,xDEBUG_SCR1(r1)
	lwz	r3,(xDEBUG0+4*\num)(r1)
	addi	r3,r3,1
	stw	r3,(xDEBUG0+4*\num)(r1)
	lwz	r3,xDEBUG_SCR1(r1)
.endm

.macro DEBUG_TRACE num, dummy=""
	stw	r3,xDEBUG_SCR1(r1)
	lwz	r3,xDEBUG_TRACE(r1)
	addi	r3,r3,1
	stw	r3,xDEBUG_TRACE(r1)
	stw	r3,(xDEBUG0+4*\num)(r1)
	lwz	r3,xDEBUG_SCR1(r1)
.endm

.macro TRACE_VAL val, dummy=""
	stw	r30,xDEBUG_SCR1(r1)
	stw	r29,xDEBUG_SCR2(r1)
	lwz	r30,xDEBUG_TRACE(r1)
	rlwinm	r30,r30,0,24,31			// 256 entries
	rlwinm	r30,r30,2,22,29
	addi	r30,r30,xDBG_TRACE_SPACE
	lis	r29,(\val)@ha
	addi	r29,r29,(\val)@l
	stwx	r29,r30,r1
	lwz	r30,xDEBUG_TRACE(r1)
	addi	r30,r30,1
	rlwinm	r30,r30,0,24,31			// 256 entries
	stw	r30,xDEBUG_TRACE(r1)
	lwz	r29,xDEBUG_SCR2(r1)	
	lwz	r30,xDEBUG_SCR1(r1)
.endm

#endif   /* _H_MOLASM */
