/**************************************************************
*   
*   Creation Date: <97/06/21 17:04:48 samuel>
*   Time-stamp: <2001/06/21 14:44:51 samuel>
*   
*	<memory.h>
*	
*	
*   
*   Copyright (C) 1997, 1999, 2000, 2001 Samuel Rydh
*
*   This program is free software; you can redistribute it and/or
*   modify it under the terms of the GNU General Public License
*   as published by the Free Software Foundation;
*
**************************************************************/


#ifndef _H_MEMORY
#define _H_MEMORY

#include "mmu_mappings.h"

extern void	mem_init( void );
extern void	mem_cleanup( void );

extern char 	*map_phys_mem( char *wanted_ptr, ulong phys_ptr, size_t size, int prot );
extern int	unmap_mem( char *start, size_t length );

extern char	*map_zero( char *wanted_ptr, size_t size );

/* --- MMU memory interface --- */

/* The folowing functions return 0 for RAM, 1 for ROM, <0 if unmapped */
extern int 	mphys_to_lvptr( ulong mptr, char **ret );
extern int 	lvptr_to_mphys( char *lvptr, ulong *ret );
extern int	verify_lvrange( char *base, size_t len );
extern int	verify_mrange( ulong mbase, size_t len );


/* The following MMU-functions below should only be used by the debugger. */
/* The real MMU code is in the kernel */

extern int 	ea_to_mphys( ulong ea, int context, ulong *mphys, int data_trans );
extern int 	ea_to_lvptr( ulong ea, int context, char **lvptr, int data_trans );
extern int	mphys_is_rom( char *lvptr );

/* ---- extern variables ---- */

extern struct mmu_mapping ram;
extern struct mmu_mapping rom;

extern int	translate_ea( ulong mac_ea, int context_ident, int tea_flags, char **ret_lv );
extern int 	translate_mac_phys( ulong mac_physical_ptr, char **ret_lvptr );

/* ---- from emulation/misc.S ---- */

extern void flush_dcache_range( char *start, char *stop );
extern void flush_icache_range( char *start, char *stop );

#endif

